/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class BeanUtil {
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String IS = "is";

    public static boolean isGetter(String methodName, int numberOfParameters) {
        return (methodName.startsWith(GET) && !methodName.equals(GET) || methodName.startsWith(IS) && !methodName.equals(IS)) && numberOfParameters == 0;
    }

    public static boolean isSetter(String methodName, int numberOfParameters) {
        return methodName.startsWith(SET) && !methodName.equals(SET) && numberOfParameters == 1;
    }

    public static boolean isGetter(IMethod method) {
        return method != null && BeanUtil.isGetter(method.getElementName(), method.getNumberOfParameters()) && BeanUtil.checkPropertyReturnType(method);
    }

    public static boolean checkPropertyReturnType(String typeName, String methodName) {
        if (typeName == null || typeName.equals("void")) {
            return false;
        }
        return !methodName.startsWith(IS) || "boolean".equals(typeName) || "java.lang.Boolean".equals(typeName);
    }

    private static boolean checkPropertyReturnType(IMethod method) {
        return method != null && BeanUtil.checkPropertyReturnType(EclipseJavaUtil.getMemberTypeAsString(method), method.getElementName());
    }

    public static boolean isSetter(IMethod method) {
        return method != null && BeanUtil.isSetter(method.getElementName(), method.getNumberOfParameters());
    }

    public static String getPropertyName(String methodName) {
        if (BeanUtil.isGetter(methodName, 0) || BeanUtil.isSetter(methodName, 1)) {
            StringBuffer name = new StringBuffer(methodName);
            if (methodName.startsWith(IS)) {
                name.delete(0, 2);
            } else {
                name.delete(0, 3);
            }
            if (name.length() < 2 || !Character.isUpperCase(name.charAt(1))) {
                name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            }
            return name.toString();
        }
        return null;
    }

    public static String getDefaultBeanName(String className) {
        int lastDotPosition = className.lastIndexOf(".");
        if (lastDotPosition >= 0 && className.length() > lastDotPosition) {
            className = className.substring(lastDotPosition + 1);
        }
        if (className.length() > 0) {
            className = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1);
        }
        return className;
    }

    public static String getDefaultBeanName(IType type) {
        return BeanUtil.getDefaultBeanName(type.getElementName());
    }

    public static String getClassName(String beanName) {
        int lastDotPosition = beanName.lastIndexOf(".");
        String beforeLastDot = "";
        if (lastDotPosition >= 0 && beanName.length() > lastDotPosition) {
            beforeLastDot = beanName.substring(0, lastDotPosition + 1);
            ++lastDotPosition;
        } else {
            lastDotPosition = 0;
        }
        if (beanName.length() > lastDotPosition) {
            beanName = String.valueOf(beforeLastDot) + beanName.substring(lastDotPosition, lastDotPosition + 1).toUpperCase() + beanName.substring(lastDotPosition + 1);
        }
        return beanName;
    }
}

