/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.common.core.CommonCorePlugin;

public class FileUtils {
    static Set validEncodings = new HashSet();
    static Set invalidEncodings = new HashSet();
    static byte[] XML_8 = new byte[]{60, 63, 120, 109, 108};
    static byte[] XML_16;

    static {
        byte[] byArray = new byte[12];
        byArray[0] = -2;
        byArray[1] = -1;
        byArray[3] = 60;
        byArray[5] = 63;
        byArray[7] = 120;
        byArray[9] = 109;
        byArray[11] = 108;
        XML_16 = byArray;
    }

    public static String getEncoding(IFile f) {
        String encoding = null;
        if (f != null && f.exists() && f.isSynchronized(0)) {
            try {
                encoding = f.getCharset();
            }
            catch (CoreException e) {
                CommonCorePlugin.getPluginLog().logError(e);
            }
        }
        return encoding != null ? encoding : "8859_1";
    }

    public static String readFile(File f) {
        if (!f.isFile()) {
            return "";
        }
        ReadBytes bs = FileUtils.readBytes(f);
        if (bs == null) {
            return "";
        }
        String encoding = FileUtils.getEncoding(bs.bs);
        if (encoding == null) {
            return new String(bs.bs, 0, bs.length);
        }
        try {
            return new String(bs.bs, 0, bs.length, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(bs.bs, 0, bs.length);
        }
    }

    public static String readFileWithEncodingCheck(File f, String defaultEncoding) {
        if (!f.isFile()) {
            return "";
        }
        ReadBytes bs = FileUtils.readBytes(f);
        if (bs == null) {
            return "";
        }
        String encoding = FileUtils.getEncoding(bs.bs);
        if (encoding == null) {
            encoding = FileUtils.validateEncoding(defaultEncoding, null);
        }
        if (encoding == null) {
            return new String(bs.bs, 0, bs.length);
        }
        try {
            return new String(bs.bs, 0, bs.length, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(bs.bs, 0, bs.length);
        }
    }

    /*
     * Loose catch block
     */
    public static ReadBytes readBytes(File f) {
        ReadBytes readBytes;
        BufferedInputStream br;
        block12: {
            if (!f.isFile()) {
                return null;
            }
            br = null;
            FileInputStream fr = new FileInputStream(f);
            br = new BufferedInputStream(fr);
            int l = (int)f.length();
            byte[] bs = new byte[l];
            l = br.read(bs, 0, l);
            br.close();
            fr.close();
            readBytes = new ReadBytes(bs, l);
            if (br == null) break block12;
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return readBytes;
        catch (IOException iOException) {
            block13: {
                try {
                    if (br == null) break block13;
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    br.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    public static String readFile(File f, String encoding) {
        ReadBytes bs = FileUtils.readBytes(f);
        if (bs == null) {
            return null;
        }
        try {
            return new String(bs.bs, 0, bs.length, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean isTextFile(File f, int length) {
        boolean bl;
        BufferedReader br;
        block13: {
            if (!f.isFile()) {
                return false;
            }
            br = null;
            FileReader fr = new FileReader(f);
            br = new BufferedReader(fr);
            int l = (int)f.length();
            if (l > length) {
                l = length;
            }
            char[] cs = new char[l];
            br.read(cs, 0, l);
            br.close();
            fr.close();
            bl = FileUtils.isText(new String(cs));
            if (br == null) break block13;
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
        catch (IOException iOException) {
            block14: {
                try {
                    if (br == null) break block14;
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    br.close();
                }
                catch (IOException iOException3) {}
            }
            return false;
        }
    }

    public static boolean isText(String body) {
        if (body == null) {
            return false;
        }
        int l = body.length();
        int i = 0;
        while (i < l) {
            char c = body.charAt(i);
            if (c < ' ' && c != '\n' && c != '\r' && c != 't') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String readStream(InputStream is) {
        StringBuffer sb;
        block12: {
            sb = new StringBuffer("");
            try {
                try {
                    int l;
                    byte[] b = new byte[4096];
                    while ((l = is.read(b, 0, b.length)) >= 0) {
                        sb.append(new String(b, 0, l));
                    }
                }
                catch (IOException e) {
                    CommonCorePlugin.getPluginLog().logError(e);
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public static String readStream(IFile file) throws CoreException {
        String content = null;
        InputStream in = null;
        try {
            String charset = file.getCharset();
            if (charset != null) {
                charset = FileUtils.validateEncoding(charset, null);
            }
            in = file.getContents();
            content = charset == null ? FileUtils.readStream(in) : FileUtils.readStream(in, charset);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    CommonCorePlugin.getPluginLog().logError(e);
                }
            }
        }
        return content;
    }

    public static String readStream(InputStream is, String charset) {
        StringBuffer sb;
        block12: {
            sb = new StringBuffer("");
            try {
                try {
                    int l;
                    byte[] b = new byte[4096];
                    while ((l = is.read(b, 0, b.length)) >= 0) {
                        sb.append(new String(b, 0, l, charset));
                    }
                }
                catch (IOException e) {
                    CommonCorePlugin.getPluginLog().logError(e);
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public static void copyContent(IFile from, IFile to, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        InputStream is = null;
        try {
            is = from.getContents();
            to.setContents(is, force, keepHistory, monitor);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    CommonCorePlugin.getPluginLog().logError(e);
                }
            }
        }
    }

    public static boolean writeFile(File f, String value) {
        return FileUtils.writeFileWithEncodingCheck(f, value, null);
    }

    public static boolean writeFileWithEncodingCheck(File f, String value, String defaultEncoding) {
        if (value == null) {
            return false;
        }
        String encoding = FileUtils.getEncoding(value);
        if (encoding == null) {
            encoding = FileUtils.validateEncoding(defaultEncoding, null);
        }
        if (value.startsWith("<?xml")) {
            String s = FileUtils.validateEncoding(encoding, "UTF-8");
            if (encoding == null) {
                encoding = s;
            } else if (s == null || !s.equals(encoding)) {
                return false;
            }
        }
        if (encoding == null) {
            return FileUtils.writeFileDefault(f, value);
        }
        return FileUtils.writeFile(f, value, encoding);
    }

    public static boolean writeFileDefault(File f, String value) {
        try {
            try {
                if (f.isFile() && !FileUtils.isSameFile(f)) {
                    f.delete();
                }
                if (!f.exists()) {
                    f.createNewFile();
                }
            }
            catch (IOException e) {
                CommonCorePlugin.getPluginLog().logError("Problem writing to file " + f, e);
            }
            catch (SecurityException e) {
                CommonCorePlugin.getPluginLog().logError("Problem writing to file " + f, e);
            }
            PrintWriter pw = new PrintWriter(new FileWriter(f));
            pw.print(value);
            pw.flush();
            pw.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean copyFile(File source, File dest, boolean mkdirs) {
        return FileUtils.copyFile(source, dest, mkdirs, true);
    }

    public static boolean copyFile(File source, File dest) {
        return FileUtils.copyFile(source, dest, false, true);
    }

    public static boolean copyFile(File source, File dest, boolean mkdirs, boolean overwrite) {
        if (mkdirs) {
            dest.getParentFile().mkdirs();
        }
        if (!source.isFile()) {
            return false;
        }
        if (dest.isFile() && !FileUtils.isSameFile(dest)) {
            dest.delete();
        }
        if (dest.isFile() && !overwrite) {
            return false;
        }
        if (!dest.exists()) {
            try {
                dest.createNewFile();
            }
            catch (IOException e1) {
                CommonCorePlugin.getPluginLog().logError(e1);
            }
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(source), 16384);
            os = new BufferedOutputStream(new FileOutputStream(dest), 16384);
            FileUtils.copyStream(is, os);
            return true;
        }
        catch (IOException e) {
            CommonCorePlugin.getPluginLog().logError(e);
            return false;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                CommonCorePlugin.getPluginLog().logError(e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                CommonCorePlugin.getPluginLog().logError(e);
            }
        }
    }

    public static boolean updateFile(File source, File dest, boolean mkdirs) {
        if (!source.isFile()) {
            return false;
        }
        if (dest.isFile() && dest.lastModified() < source.lastModified()) {
            dest.delete();
        }
        return FileUtils.copyFile(source, dest, mkdirs);
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[16384];
        while (true) {
            int r;
            if ((r = is.read(buffer)) > 0) {
                os.write(buffer, 0, r);
                continue;
            }
            if (r == -1) break;
        }
        os.flush();
    }

    public static void clear(File f) {
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            int i = 0;
            while (i < fs.length) {
                FileUtils.remove(fs[i]);
                ++i;
            }
        }
    }

    public static void remove(File f) {
        if (f.isFile()) {
            f.delete();
        } else if (f.isDirectory()) {
            File[] fs = f.listFiles();
            int i = 0;
            while (i < fs.length) {
                FileUtils.remove(fs[i]);
                ++i;
            }
            f.delete();
        }
    }

    public static boolean isSameFile(File f) {
        if (!f.exists()) {
            return false;
        }
        String fn = f.getName();
        try {
            String cn = f.getCanonicalFile().getName();
            return fn.equals(cn);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void copyDir(File from, File to) {
        FileUtils.copyDir(from, to, false);
    }

    public static void copyDir(File from, File to, boolean mkdirs) {
        FileUtils.copyDir(from, to, mkdirs, true);
    }

    public static void copyDir(File from, File to, boolean mkdirs, boolean includeSubdirs) {
        FileUtils.copyDir(from, to, includeSubdirs, mkdirs, false);
    }

    public static void copyDir(File from, boolean includeSubdirs, File to) {
        FileUtils.copyDir(from, to, includeSubdirs, false, false);
    }

    public static void copyDir(File from, File to, boolean includeSubdirs, boolean mkdirs, boolean overwriteOnlyOlderFiles) {
        FileUtils.copyDir(from, to, includeSubdirs, mkdirs, overwriteOnlyOlderFiles, null);
    }

    public static void copyDir(File from, File to, boolean includeSubdirs, boolean mkdirs, boolean overwriteOnlyOlderFiles, FileFilter filter) {
        if (filter != null && !filter.accept(from)) {
            return;
        }
        if (mkdirs) {
            to.mkdirs();
        }
        if (from == null || !from.isDirectory() || !to.isDirectory()) {
            return;
        }
        File[] fs = from.listFiles();
        if (fs == null) {
            return;
        }
        int i = 0;
        while (i < fs.length) {
            String n = fs[i].getName();
            File c = new File(to, n);
            if (!(fs[i].isDirectory() && !includeSubdirs || filter != null && !filter.accept(new File(from, n)))) {
                if (fs[i].isDirectory()) {
                    c.mkdirs();
                    FileUtils.copyDir(fs[i], c, includeSubdirs, mkdirs, overwriteOnlyOlderFiles, filter);
                } else if (overwriteOnlyOlderFiles && fs[i].isFile() && c.isFile()) {
                    FileUtils.copyFile(fs[i], c, false, c.lastModified() < fs[i].lastModified());
                } else {
                    FileUtils.copyFile(fs[i], c);
                }
            }
            ++i;
        }
    }

    public static void unjar(File dest, String jar) throws IOException {
        dest.mkdirs();
        JarFile jf = new JarFile(jar);
        try {
            Enumeration<JarEntry> es = jf.entries();
            while (es.hasMoreElements()) {
                JarEntry je = es.nextElement();
                String n = je.getName();
                File f = new File(dest, n);
                if (je.isDirectory()) {
                    f.mkdirs();
                } else {
                    if (f.exists()) {
                        f.delete();
                    } else {
                        f.getParentFile().mkdirs();
                    }
                    InputStream is = jf.getInputStream(je);
                    FileOutputStream os = new FileOutputStream(f);
                    try {
                        FileUtils.copyStream(is, os);
                    }
                    finally {
                        os.close();
                    }
                }
                long time = je.getTime();
                if (time == -1L) continue;
                f.setLastModified(time);
            }
        }
        finally {
            jf.close();
        }
    }

    public static void unjar(File dest, InputStream is) throws IOException {
        dest.mkdirs();
        JarInputStream jis = new JarInputStream(is);
        try {
            JarEntry je;
            while ((je = jis.getNextJarEntry()) != null) {
                long time;
                String n = je.getName();
                File f = new File(dest, n);
                if (je.isDirectory()) {
                    f.mkdirs();
                } else {
                    if (f.exists()) {
                        f.delete();
                    } else {
                        f.getParentFile().mkdirs();
                    }
                    FileOutputStream os = new FileOutputStream(f);
                    try {
                        FileUtils.copyStream(jis, os);
                    }
                    finally {
                        os.close();
                    }
                }
                if ((time = je.getTime()) == -1L) continue;
                f.setLastModified(time);
            }
        }
        finally {
            jis.close();
        }
    }

    public static void jar(File[] fs, String path) throws IOException {
        FileUtils.jar(fs, path, null);
    }

    public static void jar(File[] fs, String path, Manifest mf) throws IOException {
        File f = new File(path);
        FileOutputStream fos = new FileOutputStream(f);
        JarOutputStream jos = mf == null ? new JarOutputStream(fos) : new JarOutputStream((OutputStream)fos, mf);
        try {
            int i = 0;
            while (i < fs.length) {
                FileUtils.add(fs[i].getParentFile(), fs[i], jos);
                ++i;
            }
        }
        finally {
            jos.close();
            fos.close();
        }
    }

    public static void add(File root, File f, JarOutputStream jos) throws IOException {
        int l = root.getAbsolutePath().length();
        String en = f.getAbsolutePath().substring(l + 1).replace('\\', '/');
        FileUtils.add(f, en, jos);
    }

    public static void add(File f, String name, JarOutputStream jos) throws IOException {
        JarEntry entry;
        String en = name;
        if (f.isDirectory()) {
            en = String.valueOf(en) + "/";
        }
        JarEntry jarEntry = entry = en.endsWith("/") ? null : new JarEntry(en);
        if (f.isDirectory()) {
            File[] fs;
            if ("/".equals(en)) {
                en = "";
            }
            if ((fs = f.listFiles()) != null) {
                int i = 0;
                while (i < fs.length) {
                    FileUtils.add(fs[i], String.valueOf(en) + fs[i].getName(), jos);
                    ++i;
                }
            }
        } else {
            try {
                jos.putNextEntry(entry);
            }
            catch (IOException iOException) {
                return;
            }
            FileInputStream is = new FileInputStream(f);
            byte[] b = new byte[1024];
            int q = 0;
            while ((q = is.available()) > 0) {
                if (q > 1024) {
                    q = 1024;
                }
                q = is.read(b, 0, q);
                jos.write(b, 0, q);
            }
            is.close();
        }
        if (entry != null) {
            jos.closeEntry();
        }
    }

    public static void copy(InputStream f, OutputStream t) throws IOException {
        try {
            byte[] b = new byte[1024];
            int q = 0;
            while ((q = f.read(b, 0, b.length)) > 0) {
                t.write(b, 0, q);
            }
        }
        finally {
            f.close();
            t.close();
        }
    }

    public static void unzip(File dest, String jar) throws IOException {
        dest.mkdirs();
        ZipFile zf = new ZipFile(jar);
        try {
            Enumeration<? extends ZipEntry> es = zf.entries();
            while (es.hasMoreElements()) {
                ZipEntry je = es.nextElement();
                String n = je.getName();
                File f = new File(dest, n);
                if (je.isDirectory()) {
                    f.mkdirs();
                } else {
                    if (f.exists()) {
                        f.delete();
                    } else {
                        f.getParentFile().mkdirs();
                    }
                    InputStream is = zf.getInputStream(je);
                    FileOutputStream os = new FileOutputStream(f);
                    try {
                        FileUtils.copyStream(is, os);
                    }
                    finally {
                        os.close();
                    }
                }
                long time = je.getTime();
                if (time == -1L) continue;
                f.setLastModified(time);
            }
        }
        finally {
            zf.close();
        }
    }

    public static String fileURLToFilePath(String url) {
        int iFirst;
        if (url == null) {
            return null;
        }
        String resultUrl = url.replace('\\', '/');
        if (!resultUrl.startsWith("file:")) {
            return resultUrl;
        }
        int iLast = resultUrl.lastIndexOf(58);
        return iLast == (iFirst = resultUrl.indexOf(58)) ? resultUrl.substring(5) : resultUrl.substring(iLast - 1);
    }

    public static String getRelativePath(String rootpath, String path) {
        String[] r = FileUtils.tokenizePath(rootpath);
        String[] p = FileUtils.tokenizePath(path);
        if (r.length == 0 || p.length == 0 || !r[0].equalsIgnoreCase(p[0])) {
            return null;
        }
        int i = 0;
        while (i < r.length && i < p.length && r[i].equalsIgnoreCase(p[i])) {
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int k = i;
        while (k < r.length) {
            sb.append("/..");
            ++k;
        }
        k = i;
        while (k < p.length) {
            sb.append("/").append(p[k]);
            ++k;
        }
        return sb.toString();
    }

    private static String[] tokenizePath(String path) {
        String tokenizedPath = path.replace('\\', '/');
        StringTokenizer st = new StringTokenizer(tokenizedPath, "/");
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.isEmpty() || ".".equals(t)) continue;
            if ("..".equals(t)) {
                if (l.isEmpty()) continue;
                l.remove(l.size() - 1);
                continue;
            }
            l.add(t);
        }
        return l.toArray(new String[l.size()]);
    }

    public static boolean writeFile(File f, String value, String encoding) {
        try {
            try {
                if (f.isFile() && !FileUtils.isSameFile(f)) {
                    f.delete();
                }
                if (!f.exists()) {
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                }
            }
            catch (IOException e) {
                CommonCorePlugin.getPluginLog().logError(e);
            }
            FileOutputStream fs = new FileOutputStream(f);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, encoding);
            PrintWriter pw = new PrintWriter(osw);
            pw.print(value);
            pw.flush();
            pw.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return FileUtils.writeFileDefault(f, value);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return FileUtils.writeFileDefault(f, value);
        }
    }

    public static String getEncoding(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("<?xml")) {
            int i = s.indexOf("encoding=");
            if (i < 0) {
                return null;
            }
            int j = s.indexOf(34, i += "encoding=".length() + 1);
            if (j < 0) {
                return null;
            }
            return s.substring(i, j);
        }
        return null;
    }

    public static String validateEncoding(String encoding, String defaultEncoding) {
        if (encoding == null || encoding.equals(defaultEncoding)) {
            return defaultEncoding;
        }
        if (validEncodings.contains(encoding)) {
            return encoding;
        }
        if (invalidEncodings.contains(encoding)) {
            return defaultEncoding;
        }
        try {
            if (defaultEncoding != null && defaultEncoding.equals("UTF-16")) {
                new String(XML_16, 0, XML_16.length, encoding);
            } else {
                new String(XML_8, 0, XML_8.length, encoding);
            }
            validEncodings.add(encoding);
            return encoding;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            invalidEncodings.add(encoding);
            return defaultEncoding;
        }
    }

    public static String getEncoding(byte[] bs) {
        if (bs.length < 20) {
            return null;
        }
        if (FileUtils.startsWith(bs, XML_8)) {
            int i = FileUtils.getIndex(bs, (byte)63, 5);
            if (i < 0) {
                return "UTF-8";
            }
            String encoding = FileUtils.getEncoding(new String(bs, 0, i));
            return FileUtils.validateEncoding(encoding, "UTF-8");
        }
        if (FileUtils.startsWith(bs, XML_16)) {
            int i = FileUtils.getIndex(bs, (byte)63, XML_16.length);
            if (i < 0) {
                return "UTF-16";
            }
            try {
                String encoding = FileUtils.getEncoding(new String(bs, 0, i, "UTF-16"));
                return FileUtils.validateEncoding(encoding, "UTF-16");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
        return null;
    }

    static boolean startsWith(byte[] bs, byte[] prefix) {
        int i = 0;
        while (i < prefix.length) {
            if (bs[i] != prefix[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static int getIndex(byte[] bs, byte b, int offset) {
        int i = offset;
        while (i < bs.length) {
            if (bs[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static class ReadBytes {
        byte[] bs;
        int length;

        ReadBytes(byte[] bs, int l) {
            this.bs = bs;
            this.length = l;
        }
    }
}

