/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.util.HttpUtil;
import org.osgi.framework.Bundle;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DtdResolver
implements EntityResolver {
    static Set unfound = new HashSet();

    public InputStream getInputStream(String publicId, String systemId) throws SAXException, IOException {
        Bundle b;
        String location = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolvePublic(publicId, systemId);
        if (location == null) {
            location = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolveSystem(systemId);
        }
        if (location == null) {
            location = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolveURI(systemId);
        }
        if (location == null && systemId != null && systemId.startsWith("file:") && systemId.endsWith(".xsd")) {
            int i = systemId.replace('\\', '/').lastIndexOf(47);
            String systemId2 = systemId.substring(i + 1);
            location = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolveURI(systemId2);
        }
        if ((location == null || location.startsWith("http:")) && systemId != null && (b = Platform.getBundle((String)"org.eclipse.jst.standard.schemas")) != null) {
            int q = systemId.lastIndexOf("/");
            String s = systemId.substring(q + 1);
            URL u = b.getEntry("/dtdsAndSchemas/" + s);
            try {
                if (u != null) {
                    u = FileLocator.resolve((URL)u);
                }
            }
            catch (IOException iOException) {
                u = null;
            }
            if (u != null) {
                location = u.toString();
            }
        }
        if (location == null && systemId != null && !unfound.contains(systemId)) {
            unfound.add(systemId);
        }
        if (location != null) {
            try {
                URL url = new URL(location);
                File file = new File(url.getFile());
                if (file.isFile()) {
                    return new FileInputStream(file);
                }
                if ("jar".equals(url.getProtocol())) {
                    return url.openStream();
                }
            }
            catch (FileNotFoundException e) {
                CommonCorePlugin.getPluginLog().logError(e);
            }
        }
        String resourceType = null;
        if (systemId != null) {
            if (systemId.toLowerCase().endsWith(".dtd")) {
                resourceType = "DTD";
            } else if (systemId.toLowerCase().endsWith(".xsd")) {
                resourceType = "XSD";
            } else if (systemId.toLowerCase().endsWith(".ent")) {
                resourceType = "ENT";
            }
        }
        InputStream is = null;
        if (resourceType != null) {
            try {
                URL url = new URL(systemId);
                if ("http".equals(url.getProtocol())) {
                    is = HttpUtil.getInputStreamFromUrlByGetMethod(systemId);
                }
            }
            catch (MalformedURLException e) {
                CommonCorePlugin.getPluginLog().logError(e);
            }
            catch (IOException e) {
                CommonCorePlugin.getPluginLog().logError(e);
            }
        }
        return is;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream is = this.getInputStream(publicId, systemId);
        if (is != null) {
            return new InputSource(is);
        }
        return null;
    }
}

