/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.resolver.SimpleELContext;
import org.jboss.tools.common.el.core.resolver.Var;

public class ELContextImpl
extends SimpleELContext {
    public static final List<Var> EMPTY = Collections.emptyList();
    protected List<Var> allVars = new ArrayList<Var>();
    protected ELReference[] elReferences;
    protected List<ELReference> elReferenceSet;

    @Override
    public synchronized Var[] getVars() {
        List<Var> vars = this.getVarsAsList();
        return vars.toArray(new Var[vars.size()]);
    }

    @Override
    public synchronized List<Var> getVarsAsList() {
        List<Var> external = this.getExternalVars();
        if (external.isEmpty()) {
            return this.allVars;
        }
        if (this.allVars.isEmpty()) {
            return external;
        }
        ArrayList<Var> result = new ArrayList<Var>();
        result.addAll(this.allVars);
        result.addAll(external);
        return result;
    }

    public List<Var> getExternalVars() {
        return EMPTY;
    }

    public synchronized void addVar(Region region, Var var) {
        var.setRegion(region);
        this.allVars.add(var);
    }

    @Override
    public synchronized Var[] getVars(int offset) {
        List<Var> vars = this.getVarsAsList(offset);
        return vars.toArray(new Var[vars.size()]);
    }

    @Override
    public synchronized List<Var> getVarsAsList(int offset) {
        if (offset < 0) {
            return this.getVarsAsList();
        }
        List<Var> external = this.getExternalVars();
        if (this.allVars.isEmpty()) {
            return external;
        }
        ArrayList<Var> result = new ArrayList<Var>();
        for (Var var : this.allVars) {
            Region region = var.getRegion();
            if (offset < region.getOffset() || offset > region.getOffset() + region.getLength()) continue;
            result.add(var);
        }
        if (!external.isEmpty()) {
            result.addAll(external);
        }
        return result;
    }

    public List<Var> getAllVars() {
        return this.allVars;
    }

    public void setAllVars(List<Var> allVars) {
        this.allVars = allVars;
    }

    @Override
    public synchronized ELReference[] getELReferences() {
        if (this.elReferences == null) {
            if (this.elReferenceSet == null || this.elReferenceSet.isEmpty()) {
                this.elReferences = EMPTY_ARRAY;
                return EMPTY_ARRAY;
            }
            this.elReferences = this.elReferenceSet.toArray(new ELReference[0]);
            this.sortELReferences();
        }
        return this.elReferences;
    }

    public synchronized void addELReference(ELReference reference) {
        if (this.elReferenceSet == null) {
            this.elReferenceSet = new ArrayList<ELReference>();
        }
        this.elReferenceSet.add(reference);
        this.elReferences = null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized ELReference getELReference(int offset) {
        block9: {
            block8: {
                this.getELReferences();
                if (this.elReferences.length == 0) {
                    return null;
                }
                if (this.elReferences.length != 1) break block8;
                ref = this.elReferences[0];
                if (ref.getStartPosition() <= offset && ref.getStartPosition() + ref.getLength() > offset) {
                    return ref;
                }
                break block9;
            }
            left = 0;
            ref = this.elReferences[left];
            if (ref.getStartPosition() > offset) {
                return null;
            }
            if (ref.getStartPosition() + ref.getLength() >= offset) {
                return ref;
            }
            right = this.elReferences.length - 1;
            ref = this.elReferences[right];
            if (ref.getStartPosition() + ref.getLength() < offset) {
                return null;
            }
            if (ref.getStartPosition() > offset) ** GOTO lbl31
            return ref;
lbl-1000:
            // 1 sources

            {
                middle = (right + left) / 2;
                ref = this.elReferences[middle];
                if (ref.getStartPosition() <= offset && ref.getStartPosition() + ref.getLength() > offset) {
                    return ref;
                }
                if (ref.getStartPosition() > offset) {
                    right = middle;
                    continue;
                }
                left = middle;
lbl31:
                // 3 sources

                ** while (right - left > 1)
            }
lbl32:
            // 1 sources

            return null;
        }
        return null;
    }

    @Override
    public synchronized Collection<ELReference> getELReferences(IRegion region) {
        ArrayList<ELReference> references = new ArrayList<ELReference>();
        if (this.elReferenceSet == null || this.elReferenceSet.isEmpty()) {
            return references;
        }
        this.getELReferences();
        int min = this.getMin(region.getOffset());
        int max = this.getMax(region.getOffset() + region.getLength());
        if (min >= 0 && max >= min) {
            int i = min;
            while (i <= max) {
                ELReference ref = this.elReferences[i];
                if (region.getOffset() + region.getLength() >= ref.getStartPosition() && region.getOffset() <= ref.getStartPosition() + ref.getLength()) {
                    references.add(ref);
                }
                ++i;
            }
        }
        return references;
    }

    /*
     * Unable to fully structure code
     */
    private int getMin(int offset) {
        block8: {
            block7: {
                if (this.elReferences.length == 0) {
                    return -1;
                }
                if (this.elReferences.length != 1) break block7;
                ref = this.elReferences[0];
                if (ref.getStartPosition() <= offset && ref.getStartPosition() + ref.getLength() > offset) {
                    return 0;
                }
                break block8;
            }
            left = 0;
            ref = this.elReferences[left];
            if (ref.getStartPosition() + ref.getLength() >= offset) {
                return left;
            }
            right = this.elReferences.length - 1;
            ref = this.elReferences[right];
            if (ref.getStartPosition() + ref.getLength() < offset) {
                return -1;
            }
            if (ref.getStartPosition() > offset) ** GOTO lbl27
            return right;
lbl-1000:
            // 1 sources

            {
                middle = (right + left) / 2;
                ref = this.elReferences[middle];
                if (ref.getStartPosition() <= offset && ref.getStartPosition() + ref.getLength() > offset) {
                    return middle;
                }
                if (ref.getStartPosition() + ref.getLength() < offset) {
                    left = middle + 1;
                    continue;
                }
                right = middle;
lbl27:
                // 3 sources

                ** while (right - left > 1)
            }
lbl28:
            // 1 sources

            return left;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private int getMax(int offset) {
        block8: {
            block7: {
                if (this.elReferences.length == 0) {
                    return -1;
                }
                if (this.elReferences.length != 1) break block7;
                ref = this.elReferences[0];
                if (ref.getStartPosition() <= offset && ref.getStartPosition() + ref.getLength() > offset) {
                    return 0;
                }
                break block8;
            }
            left = 0;
            ref = this.elReferences[left];
            if (ref.getStartPosition() > offset) {
                return -1;
            }
            if (ref.getStartPosition() + ref.getLength() >= offset) {
                return left;
            }
            right = this.elReferences.length - 1;
            ref = this.elReferences[right];
            if (ref.getStartPosition() > offset) ** GOTO lbl27
            return right;
lbl-1000:
            // 1 sources

            {
                middle = (right + left) / 2;
                ref = this.elReferences[middle];
                if (ref.getStartPosition() <= offset && ref.getStartPosition() + ref.getLength() > offset) {
                    return middle;
                }
                if (ref.getStartPosition() > offset) {
                    right = middle - 1;
                    continue;
                }
                left = middle;
lbl27:
                // 3 sources

                ** while (right - left > 1)
            }
lbl28:
            // 1 sources

            return right;
        }
        return -1;
    }

    private void sortELReferences() {
        if (this.elReferenceSet == null || this.elReferenceSet.size() < 2) {
            return;
        }
        Arrays.sort(this.elReferences, new ReferencesComparator());
        ArrayList<ELReference> newReferencesSet = new ArrayList<ELReference>();
        newReferencesSet.add(this.elReferences[0]);
        ELReference last = null;
        int i = 0;
        while (i < this.elReferences.length) {
            ELReference next = this.elReferences[i];
            if (last == null || last.getStartPosition() + last.getLength() < next.getStartPosition()) {
                newReferencesSet.add(next);
                last = next;
            }
            ++i;
        }
        this.elReferenceSet = newReferencesSet;
        if (this.elReferenceSet.size() < this.elReferences.length) {
            this.elReferences = null;
            this.getELReferences();
        }
    }

    static class ReferencesComparator
    implements Comparator<ELReference> {
        ReferencesComparator() {
        }

        @Override
        public int compare(ELReference o1, ELReference o2) {
            if (o1.getStartPosition() != o2.getStartPosition()) {
                return o1.getStartPosition() - o2.getStartPosition();
            }
            return o2.getStartPosition() + o2.getLength() - o1.getStartPosition() - o1.getLength();
        }
    }
}

