/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.ui.launching;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.jdt.debug.VmModel;
import org.jboss.tools.common.jdt.debug.ui.RemoteDebugUIActivator;
import org.jboss.tools.common.jdt.debug.ui.actions.RemoteLaunchAction;
import org.jboss.tools.common.jdt.debug.ui.launching.LaunchRemoteApplicationDialog;

public class RemoteJavaApplicationLaunchShortcut
implements ILaunchShortcut2 {
    private int retValue;
    private boolean restarted;

    public void launch(ISelection selection, String mode) {
        this.executeAction(this.getLaunchableResource(selection));
    }

    private void executeAction(final IResource resource) {
        final boolean oldDiscover = RemoteDebugUIActivator.getDefault().isDiscoverRemoteApplication();
        final IEclipsePreferences preferences = RemoteDebugUIActivator.getDefault().getPreferences();
        preferences.putBoolean("discoverRemoteApplication", true);
        final Job job = RemoteDebugUIActivator.getDefault().getRemoteApplicationJob();
        while (job.getState() != 0) {
            this.restarted = true;
            MessageDialog dialog = new MessageDialog(RemoteJavaApplicationLaunchShortcut.getShell(), "Remote Java Application scan already in progress", null, "Remote Java Application scan already in progress.\nPlease wait for it to be complete.", 3, new String[]{"OK", "Try again"}, 0);
            this.retValue = dialog.open();
            if (this.retValue != 0) continue;
            this.restarted = false;
            return;
        }
        this.restarted = false;
        job.addJobChangeListener(new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                preferences.putBoolean("discoverRemoteApplication", oldDiscover);
                job.removeJobChangeListener((IJobChangeListener)this);
                if (RemoteJavaApplicationLaunchShortcut.this.restarted) {
                    final Display display = Display.getDefault();
                    while (RemoteJavaApplicationLaunchShortcut.this.restarted) {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!display.readAndDispatch()) {
                                    display.sleep();
                                }
                            }
                        });
                    }
                    if (RemoteJavaApplicationLaunchShortcut.this.retValue != 0) {
                        return;
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RemoteJavaApplicationLaunchShortcut.this.showDialog(resource);
                    }
                });
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        });
        job.schedule();
    }

    public void launch(IEditorPart editor, String mode) {
        this.executeAction(this.getLaunchableResource(editor));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return new ILaunchConfiguration[0];
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editor) {
        return new ILaunchConfiguration[0];
    }

    public IResource getLaunchableResource(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            Object selected = ss.getFirstElement();
            if (!(selected instanceof IJavaElement) && selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(IJavaElement.class);
            }
            if (selected instanceof IJavaElement) {
                return ((IJavaElement)selected).getResource();
            }
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editor) {
        ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        if (element != null) {
            try {
                return element.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    private void showDialog(IResource resource) {
        VmModel[] vmModels = RemoteDebugUIActivator.getDefault().getCurrentDebugModels();
        if (vmModels == null || vmModels.length == 0) {
            boolean question = MessageDialog.openQuestion((Shell)RemoteJavaApplicationLaunchShortcut.getShell(), (String)"No remote Java Application Found", (String)"Sorry, could not detect any running remote java applications.\nTry search again?");
            if (question) {
                this.executeAction(resource);
            }
        } else {
            boolean autoConnect = RemoteDebugUIActivator.getDefault().isAutoConnect();
            if (autoConnect && vmModels.length == 1) {
                new RemoteLaunchAction(vmModels[0].getPort()).run();
            } else {
                LaunchRemoteApplicationDialog dialog = new LaunchRemoteApplicationDialog(RemoteJavaApplicationLaunchShortcut.getShell());
                dialog.open();
            }
        }
    }

    private static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }
}

