/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.jdt.debug.VmModel;

public class VmModelCommandUtility {
    private static boolean loggedWarning = false;
    private static String[] WIN_CMD_ARRAY = new String[]{"netstat", "-ona", "-p", "tcp"};
    private static String[] MAC_CMD_ARRAY = new String[]{"lsof", "-i", "-P"};
    private static String[] LINUX_CMD_ARRAY = new String[]{"netstat", "-nlt", "-p", ""};

    /*
     * Exception decompiling
     */
    public static VmModel getVmModelUsingOsCommand(Integer vmPid, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 31[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String[] getOsCommand(String pid) {
        if ("win32".equals(Platform.getOS())) {
            return WIN_CMD_ARRAY;
        }
        if ("macosx".equals(Platform.getOS())) {
            return MAC_CMD_ARRAY;
        }
        if ("linux".equals(Platform.getOS())) {
            String[] cmdarray = LINUX_CMD_ARRAY;
            cmdarray[cmdarray.length - 1] = pid;
            return cmdarray;
        }
        return null;
    }

    private static VmModel processLine(String line, String vmPidStr) {
        if ("win32".equals(Platform.getOS())) {
            return VmModelCommandUtility.processWinLine(line, vmPidStr);
        }
        if ("macosx".equals(Platform.getOS())) {
            return VmModelCommandUtility.processMacLine(line, vmPidStr);
        }
        if ("linux".equals(Platform.getOS())) {
            return VmModelCommandUtility.processLinuxLine(line, vmPidStr);
        }
        return null;
    }

    private static VmModel processLinuxLine(String line, String vmPidStr) {
        String port;
        String pid;
        String[] pids;
        String[] elements = line.split(" ", 7);
        if (elements.length >= 7 && elements[0] != null && elements[0].equals("tcp") && elements[6] != null && (pids = elements[6].split("/")).length == 2 && (pid = pids[0]) != null && pid.equals(vmPidStr) && elements[3] != null && (port = VmModelCommandUtility.getPort(elements[3])) != null) {
            VmModel model = new VmModel();
            model.setPid(vmPidStr);
            model.setMainClass("<Unknown>");
            model.setPort(port);
            model.setTransport("dt_socket");
            return model;
        }
        return null;
    }

    private static VmModel processWinLine(String line, String vmPidStr) {
        String port;
        String[] elements = line.split(" ", 5);
        if (elements.length == 5 && elements[4] != null && elements[4].equals(vmPidStr) && elements[1] != null && (port = VmModelCommandUtility.getPort(elements[1])) != null && !port.isEmpty()) {
            VmModel model = new VmModel();
            model.setPid(vmPidStr);
            model.setMainClass("<Unknown>");
            model.setPort(port);
            model.setTransport("dt_socket");
            return model;
        }
        return null;
    }

    private static VmModel processMacLine(String line, String vmPidStr) {
        String port;
        String[] elements = line.split(" ", 10);
        if (elements.length >= 10 && elements[1] != null && elements[1].equals(vmPidStr) && elements[7] != null && elements[7].equals("TCP") && elements[8] != null && (port = VmModelCommandUtility.getPort(elements[8])) != null && !port.isEmpty()) {
            VmModel model = new VmModel();
            model.setPid(vmPidStr);
            model.setMainClass("<Unknown>");
            model.setPort(port);
            model.setTransport("dt_socket");
            return model;
        }
        return null;
    }

    private static String getPort(String element) {
        String[] ports = element.split(":");
        String port = ports.length == 2 ? ports[1] : ports[0];
        return port;
    }

    private static String clearWhiteSpace(String line) {
        line = line.trim();
        while (line.contains("\t")) {
            line = line.replace(" ", "\t");
        }
        while (line.contains("  ")) {
            line = line.replace("  ", " ");
        }
        return line;
    }
}

