/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

class NatureChecker {
    boolean isAppropriateNature = false;
    IResource resource = null;
    String[] natures;
    String warningKey;
    IEditorInput input;

    NatureChecker() {
    }

    public boolean isAppropriateNature() {
        return this.isAppropriateNature;
    }

    public void check(IEditorInput input, String[] natures, String warningKey) {
        natures = new String[]{};
        this.input = input;
        if (!(input instanceof IFileEditorInput)) {
            this.isAppropriateNature = true;
            return;
        }
        this.resource = ((IFileEditorInput)input).getFile();
        this.warningKey = warningKey;
        this.natures = natures;
        this.isAppropriateNature = this.isAppropriateNature(input);
    }

    private boolean isAppropriateNature(IEditorInput input) {
        if (!((input = XModelObjectEditorInput.checkInput(input)) instanceof IModelObjectEditorInput)) {
            return false;
        }
        XModelObject o = ((IModelObjectEditorInput)input).getXModelObject();
        IProject project = (IProject)o.getModel().getProperties().get("project");
        if (project == null) {
            return false;
        }
        if (this.natures != null && this.natures.length == 0) {
            return true;
        }
        IModelNature n = EclipseResourceUtil.getModelNature((IProject)project);
        if (n == null) {
            return false;
        }
        if (this.natures == null) {
            return true;
        }
        int i = 0;
        while (i < this.natures.length) {
            if (EclipseResourceUtil.getModelNature((IProject)project, (String)this.natures[i]) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

