/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.editor.AbstractSectionEditor;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.editor.EditorActionBarContributorWrapper;
import org.jboss.tools.common.editor.ErrorSelectionListener;
import org.jboss.tools.common.editor.NatureChecker;
import org.jboss.tools.common.editor.ObjectEditorErrorTickUpdater;
import org.jboss.tools.common.editor.ObjectMultiPageEditorMessages;
import org.jboss.tools.common.editor.ObjectTextEditor;
import org.jboss.tools.common.editor.ResourceChangeListener;
import org.jboss.tools.common.editor.TreeFormPage;
import org.jboss.tools.common.editor.TreeGuiEditor;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.options.Preference;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.outline.XModelObjectContentOutlineProvider;
import org.jboss.tools.common.model.ui.select.XModelObjectSelectionProvider;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectCache;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTSync;
import org.jboss.tools.common.text.ext.IMultiPageEditor;

public class ObjectMultiPageEditor
extends MultiPageEditorPart
implements XModelTreeListener,
IGotoMarker,
IMultiPageEditor {
    protected AbstractSectionEditor treeEditor;
    protected TreeFormPage treeFormPage;
    protected ObjectTextEditor textEditor;
    protected IModelObjectEditorInput input;
    protected XModel model = null;
    protected XModelObjectCache cache = null;
    protected XModelObject object = null;
    protected long timeStamp = -1L;
    protected long lastModifiedTimeStamp = -1L;
    protected boolean isErrorMode = false;
    protected XModelTreeListenerSWTSync syncListener = new XModelTreeListenerSWTSync(this);
    public XModelObjectContentOutlineProvider outline = new XModelObjectContentOutlineProvider();
    private ActivationListener fActivationListener = new ActivationListener();
    protected XModelObjectSelectionProvider selectionProvider = new XModelObjectSelectionProvider();
    protected NatureChecker natureChecker = new NatureChecker();
    protected ObjectEditorErrorTickUpdater errorTickUpdater;
    private QualifiedName persistentTabQualifiedName = new QualifiedName("", "Selected_tab");
    int selectedPageIndex = 0;
    boolean lock2 = false;
    boolean waitForMerge = false;
    TextSelectionProvider textSelectionProvider = new TextSelectionProvider();
    private long fModificationStamp = -1L;
    private boolean fIsSanityCheckEnabled = true;
    PostponedTextSelection postponedTextSelection = new PostponedTextSelection();

    public ObjectMultiPageEditor() {
        this.errorTickUpdater = new ObjectEditorErrorTickUpdater(this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.natureChecker.check(input, this.getSupportedNatures(), this.getNatureWarningMessageKey());
        super.init(site, this.natureChecker.input);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.getPartService().addPartListener((IPartListener)this.fActivationListener);
        window.getShell().addShellListener((ShellListener)this.fActivationListener);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(XModelObjectEditorInput.checkInput(input));
        this.updateFile();
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ObjectMultiPageEditor.this.firePropertyChange(258);
                }
            });
        } else {
            this.firePropertyChange(258);
        }
        if (this.errorTickUpdater != null && this.getFile() != null) {
            this.errorTickUpdater.updateEditorImage(this.getFile());
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        if (editor instanceof ITextEditor) {
            return new PostMultiPageEditorSite(this, editor);
        }
        return new MultiPageEditorSite((MultiPageEditorPart)this, editor);
    }

    public boolean isAppropriateNature() {
        return this.natureChecker.isAppropriateNature;
    }

    protected String[] getSupportedNatures() {
        return null;
    }

    protected String getNatureWarningMessageKey() {
        return "SharableEditors.natureWarning.message";
    }

    private void updateFile() {
        IFile file = this.getFile();
        if (file != null) {
            try {
                file.refreshLocal(0, null);
            }
            catch (CoreException coreException) {}
        }
    }

    private IFile getFile() {
        IEditorInput input = this.getEditorInput();
        return input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    private void loadSelectedTab() {
        IFile file = this.getFile();
        try {
            if ("yes".equals(PreferenceModelUtilities.getPreferenceModel().getByPath(Preference.EDITOR_PATH).getAttributeValue("selectSourceTab"))) {
                this.selectedPageIndex = this.getSourcePageIndex();
            } else if (file == null) {
                this.loadSelectedTabForStorage();
            } else {
                String q = file.getPersistentProperty(this.persistentTabQualifiedName);
                this.selectedPageIndex = q == null ? 0 : Integer.parseInt(q);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.selectedPageIndex = 0;
        }
        catch (CoreException coreException) {
            this.selectedPageIndex = 0;
        }
    }

    private void loadSelectedTabForStorage() {
        if (this.object == null) {
            return;
        }
        String path = this.object.getPath();
        QualifiedName qn = new QualifiedName("", "Selected_tab_" + path);
        IProject p = EclipseResourceUtil.getProject((XModelObject)this.object);
        if (p == null || !p.isOpen()) {
            return;
        }
        try {
            String q = p.getPersistentProperty(qn);
            this.selectedPageIndex = q == null ? 0 : Integer.parseInt(q);
        }
        catch (NumberFormatException numberFormatException) {
            this.selectedPageIndex = 0;
        }
        catch (CoreException coreException) {
            this.selectedPageIndex = 0;
        }
    }

    private void saveSelectedTab() {
        IFile file = this.getFile();
        if (file == null) {
            this.saveSelectedTabForStorage();
        } else {
            try {
                if (file.isAccessible()) {
                    file.setPersistentProperty(this.persistentTabQualifiedName, "" + this.selectedPageIndex);
                }
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    private void saveSelectedTabForStorage() {
        if (this.object == null) {
            return;
        }
        IProject p = EclipseResourceUtil.getProject((XModelObject)this.object);
        if (p == null || !p.isOpen()) {
            return;
        }
        String path = this.object.getPath();
        QualifiedName qn = new QualifiedName("", "Selected_tab_" + path);
        try {
            p.setPersistentProperty(qn, "" + this.selectedPageIndex);
        }
        catch (CoreException coreException) {}
    }

    public final boolean isWrongEntity() {
        return this.getModelObject() != null && this.isWrongEntity(this.getModelObject().getModelEntity().getName());
    }

    protected boolean isWrongEntity(String entity) {
        return false;
    }

    protected XModelObject getModelObject() {
        return this.cache == null ? null : this.cache.getObject();
    }

    protected void createPages() {
        IEditorInput _input = this.getEditorInput();
        this.setPartName(_input.getName());
        if (!(_input instanceof IModelObjectEditorInput)) {
            this.createUnloadedPage();
            return;
        }
        this.input = (IModelObjectEditorInput)this.getEditorInput();
        this.object = this.input.getXModelObject();
        this.timeStamp = this.object == null ? -1L : this.object.getTimeStamp();
        this.lastModifiedTimeStamp = this.object == null || this.object.isModified() ? -1L : this.object.getLastModificationTimeStamp();
        this.cache = new XModelObjectCache(this.object);
        this.outline.setCache(this.cache);
        this.model = this.object.getModel();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.doCreatePages();
        this.model.addModelTreeListener((XModelTreeListener)this.syncListener);
        this.loadSelectedTab();
        if (this.selectedPageIndex < this.getPageCount()) {
            this.setActivePage(this.selectedPageIndex);
        }
        this.updateSelectionProvider();
        new ResourceChangeListener((IEditorPart)this, this.getContainer());
    }

    public void selectPageByName(String name) {
        if (name == null) {
            return;
        }
        int i = 0;
        while (i < this.getPageCount()) {
            String h = this.getPageText(i);
            if (name.equals(h)) {
                if (this.selectedPageIndex == i) {
                    return;
                }
                this.selectedPageIndex = i;
                this.switchToPage(i);
            }
            ++i;
        }
    }

    protected void createUnloadedPage() {
        this.createTextPage();
    }

    protected void doCreatePages() {
    }

    protected void createTreePage() {
        this.installTreePage(new TreeGuiEditor());
    }

    protected void createTextPage() {
        this.textEditor = this.createTextEditor();
        try {
            int index = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(index, ObjectMultiPageEditorMessages.PAGES_EDITOR_SOURCE_TAB);
            this.textEditor.setObject(this.object);
            this.textEditor.addFocusListener((FocusListener)new TextFocusListener());
            this.outline.addSelectionChangedListener(new OutlineSelectionListener());
        }
        catch (PartInitException ex) {
            ModelUIPlugin.getPluginLog().logError((Throwable)ex);
            this.textEditor = null;
        }
    }

    protected final void installTreePage(AbstractSectionEditor treeEditor) {
        this.treeEditor = treeEditor;
        Control control = treeEditor.createControl(this.getContainer());
        treeEditor.addErrorSelectionListener(this.createErrorSelectionListener());
        int index = this.addPage(control);
        this.setPageText(index, "Tree");
        this.selectionProvider.addHost("treeEditor", treeEditor.getSelectionProvider());
    }

    protected ObjectTextEditor createTextEditor() {
        return null;
    }

    public boolean isDirty() {
        if (super.isDirty()) {
            return true;
        }
        if (this.input == null) {
            return false;
        }
        XModelObject o = this.getModelObject();
        return o != null && this.lastModifiedTimeStamp != o.getLastModificationTimeStamp() || this.textEditor != null && this.textEditor.isModified();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.input == null) {
            if (this.textEditor != null) {
                this.textEditor.save();
            }
            return;
        }
        if (!this.checkReadOnlyOnSave()) {
            if (monitor != null) {
                monitor.setCanceled(true);
            }
            return;
        }
        this.lock2 = false;
        try {
            XModelObject o;
            if (this.textEditor != null && this.textEditor.isModified()) {
                this.textEditor.save();
            }
            if ((o = this.getModelObject()) == null || !o.isActive()) {
                return;
            }
            XModelObject p = o.getParent();
            if (!(p instanceof FolderImpl)) {
                return;
            }
            FolderImpl f = (FolderImpl)p;
            if (this.treeFormPage != null) {
                this.treeFormPage.doSave(monitor);
            }
            this.enableSanityChecking(false);
            try {
                f.saveChild(o);
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
            this.updateModificationStamp(this.getEditorInput());
            this.enableSanityChecking(true);
            if (this.textEditor != null) {
                this.textEditor.setModified(false);
            }
            this.lastModifiedTimeStamp = o.getLastModificationTimeStamp();
            this.firePropertyChange(257);
            this.saveX(monitor);
            f.updateRegistration(o);
        }
        finally {
            this.lock2 = false;
        }
    }

    void saveX(IProgressMonitor monitor) {
        if (!(this.textEditor instanceof AbstractTextEditor)) {
            return;
        }
        try {
            Method m = AbstractTextEditor.class.getDeclaredMethod("performSave", Boolean.TYPE, IProgressMonitor.class);
            m.setAccessible(true);
            m.invoke((Object)this.textEditor, Boolean.TRUE, monitor);
        }
        catch (SecurityException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void doSaveAs() {
        this.performSaveAs(null);
    }

    public void gotoMarker(IMarker marker) {
        if (marker == null || this.getModelObject() == null || !marker.exists()) {
            return;
        }
        String path = marker.getAttribute("path", null);
        if (path != null) {
            XModelObject o = this.getModelObject().getModel().getByPath(path);
            if (o == null) {
                return;
            }
            XModelObject f = FileSystemsHelper.getFile((XModelObject)o);
            if (f != null && f != this.object && this.object.getFileType() == 1 && this.getFile() != null && this.getFile().equals(f.getAdapter(IFile.class))) {
                if (f == o) {
                    o = this.object;
                } else if ((o = this.object.getChildByPath(o.getPath().substring(f.getPath().length() + 1))) == null) {
                    return;
                }
            }
            this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)o));
            if (!"Tree".equals(marker.getAttribute("tab", null))) {
                this.switchToPage(this.getSourcePageIndex());
            }
            this.postponedTextSelection.clean();
            if (marker.getAttribute("lineNumber", -1) != -1) {
                if (this.textEditor != null) {
                    this.textEditor.gotoMarker(marker);
                }
            } else {
                String attr = marker.getAttribute("attribute", "");
                if (attr == null || attr.length() == 0) {
                    this.postponedTextSelection.select(o, null);
                } else {
                    this.postponedTextSelection.select(o, attr);
                }
            }
        } else {
            this.postponedTextSelection.clean();
            if (this.textEditor != null) {
                this.switchToPage(this.getSourcePageIndex());
                this.textEditor.gotoMarker(marker);
            }
        }
    }

    protected void switchToPage(int page) {
        if (this.getActivePage() != page && page >= 0) {
            this.setActivePage(page);
            this.pageChange(page);
        }
    }

    protected boolean isErrorMode() {
        return this.isErrorMode;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void dispose() {
        XModelObject o;
        this.saveSelectedTab();
        super.dispose();
        if (this.model == null) {
            return;
        }
        this.model.removeModelTreeListener((XModelTreeListener)this.syncListener);
        this.model = null;
        if (this.syncListener != null) {
            this.syncListener.dispose();
        }
        this.syncListener = null;
        if (this.treeFormPage != null) {
            this.treeFormPage.dispose();
        }
        if (this.treeEditor != null) {
            this.treeEditor.disposeGui();
        }
        if (this.fActivationListener != null) {
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            window.getPartService().removePartListener((IPartListener)this.fActivationListener);
            Shell shell = window.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fActivationListener = null;
        }
        if ((o = this.getModelObject()) != null && o.isModified() && o.isActive()) {
            try {
                XAction action = XActionInvoker.getAction((String)"DiscardActions.Discard", (XModelObject)this.object);
                if (action != null) {
                    action.executeHandler(this.object, null);
                } else if (this.object.getParent() instanceof FolderImpl) {
                    ((FolderImpl)this.object.getParent()).discardChildFile(this.object);
                }
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        if (this.outline != null) {
            this.outline.dispose();
        }
        this.outline = null;
        if (this.errorTickUpdater != null) {
            this.errorTickUpdater.dispose();
            this.errorTickUpdater = null;
        }
    }

    protected void initEditors() {
        this.checkErrorMode();
        if (this.isErrorMode) {
            this.setErrorMode();
        } else {
            this.setNormalMode();
        }
        if (this.textEditor != null) {
            this.textEditor.setObject(this.object);
        }
    }

    public void nodeChanged(XModelTreeEvent event) {
        if (this.lock2) {
            return;
        }
        if (event.getDetails() == "beforeMerge" && event.getModelObject() == this.getModelObject()) {
            this.waitForMerge = true;
            return;
        }
        if (event.getDetails() == "afterMerge" && event.getModelObject() == this.getModelObject()) {
            this.waitForMerge = false;
        }
        if (this.waitForMerge) {
            return;
        }
        if (this.needsUpdate()) {
            Display.getDefault().syncExec((Runnable)new U());
        }
    }

    public void structureChanged(XModelTreeEvent event) {
        XModelObjectEditorInput ei;
        if (this.lock2) {
            return;
        }
        if (this.waitForMerge) {
            return;
        }
        if ((event.getModelObject() instanceof FileSystemImpl || event.getDetails() instanceof FileSystemImpl) && this.getFile() != null && this.getFile().exists() && this.getEditorInput() instanceof XModelObjectEditorInput && (ei = (XModelObjectEditorInput)this.getEditorInput()).updateXModelObject()) {
            this.lock2 = true;
            try {
                XModelObject o = ei.getXModelObject();
                if (this.textEditor != null) {
                    this.textEditor.setObject(o);
                }
                this.object = o;
                this.setInput(ei);
                this.lastModifiedTimeStamp = this.object == null || this.object.isModified() ? -1L : this.object.getLastModificationTimeStamp();
                this.cache = new XModelObjectCache(this.object);
                this.outline.setCache(this.cache);
                this.model = this.object.getModel();
                this.updateTitle();
                this.timeStamp = -1L;
                this.update0();
            }
            finally {
                this.lock2 = false;
            }
        }
        if (this.needsUpdate()) {
            Display.getDefault().syncExec((Runnable)new U());
        }
    }

    protected boolean needsUpdate() {
        XModelObject o = this.getModelObject();
        if (o == this.object && (o == null || o.getTimeStamp() == this.timeStamp)) {
            if (o != null && o.getLastModificationTimeStamp() != this.lastModifiedTimeStamp) {
                if (!o.isModified()) {
                    this.lastModifiedTimeStamp = o.getLastModificationTimeStamp();
                }
                this.firePropertyChange(257);
                if (this.textEditor != null) {
                    this.textEditor.updateModification();
                }
            }
            return false;
        }
        this.object = o;
        this.timeStamp = o == null ? -1L : o.getTimeStamp();
        return true;
    }

    public void update0() {
        this.setPartName(this.getEditorInput().getName());
        this.checkErrorMode();
        if (this.isErrorMode) {
            this.setErrorMode();
        } else {
            this.setNormalMode();
        }
        if (this.textEditor != null) {
            this.textEditor.updateDocument();
        }
    }

    protected void setErrorMode() {
    }

    protected void setNormalMode() {
    }

    protected void checkErrorMode() {
        boolean i;
        if (this.object == null) {
            return;
        }
        boolean bl = i = this.isWrongEntity() || "yes".equals(this.object.get("isIncorrect"));
        if (this.isErrorMode == i) {
            return;
        }
        this.isErrorMode = i;
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter.isAssignableFrom(IContentOutlinePage.class)) {
            if (this.input == null) {
                return null;
            }
            return this.outline;
        }
        if (ITextEditor.class == adapter && this.textEditor instanceof ITextEditor) {
            return this.textEditor;
        }
        return super.getAdapter(adapter);
    }

    protected ErrorSelectionListener createErrorSelectionListener() {
        return new ErrorSelectionListenerImpl();
    }

    protected int getSourcePageIndex() {
        return this.getPageCount() - 1;
    }

    void doErrorSelected(int line, int position) {
        this.setActivePage(this.getSourcePageIndex());
        this.pageChange(this.getSourcePageIndex());
        if (this.textEditor != null) {
            this.textEditor.setCursor(line, position);
        }
    }

    public void activateErrorTab() {
        this.setActivePage(0);
    }

    protected void updateEditableMode() {
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public StructuredTextEditor getSourceEditor() {
        if (this.textEditor instanceof StructuredTextEditor) {
            return (StructuredTextEditor)this.textEditor;
        }
        return null;
    }

    protected AbstractSelectionProvider getTextSelectionProvider() {
        this.textSelectionProvider.init();
        return this.textSelectionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableSanityChecking(boolean enable) {
        ObjectMultiPageEditor objectMultiPageEditor = this;
        synchronized (objectMultiPageEditor) {
            this.fIsSanityCheckEnabled = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safelySanityCheckState(IEditorInput input) {
        boolean enabled = false;
        ObjectMultiPageEditor objectMultiPageEditor = this;
        synchronized (objectMultiPageEditor) {
            enabled = this.fIsSanityCheckEnabled;
        }
        if (enabled) {
            this.doSanityCheckState(input);
        }
    }

    protected boolean doSanityCheckState(IEditorInput input) {
        if (input == null) {
            return false;
        }
        if (input instanceof IFileEditorInput) {
            File f;
            IFile iFile = ((IFileEditorInput)input).getFile();
            if (iFile == null) {
                return false;
            }
            File file = f = iFile.getLocation() == null ? null : iFile.getLocation().toFile();
            if (f == null) {
                return false;
            }
            if (this.fModificationStamp == -1L) {
                this.fModificationStamp = f.lastModified();
            }
            long stamp = f.lastModified();
            try {
                this.handleEditorInputChanged();
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
            if (stamp != this.fModificationStamp) {
                this.fModificationStamp = stamp;
                return true;
            }
        }
        return false;
    }

    private void updateModificationStamp(IEditorInput input) {
        try {
            if (input instanceof IFileEditorInput) {
                this.fModificationStamp = ((IFileEditorInput)input).getFile().getLocation().toFile().lastModified();
            }
        }
        finally {
            this.fModificationStamp = -1L;
        }
    }

    private void handleEditorInputChanged() throws XModelException {
        XModelObject o = this.getModelObject();
        if (o == null) {
            return;
        }
        if (this.input instanceof IFileEditorInput && o.getParent() instanceof FolderImpl) {
            FolderImpl f = (FolderImpl)o.getParent();
            IFile file = ((IFileEditorInput)this.input).getFile();
            if (file.isSynchronized(0)) {
                return;
            }
            f.updateChildFile(o, file.getLocation().toFile());
            if (this.textEditor instanceof ITextEditor) {
                IDocumentProvider provider = ((ITextEditor)this.textEditor).getDocumentProvider();
                if (provider instanceof IDocumentProviderExtension) {
                    IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
                    try {
                        extension.synchronize((Object)this.input);
                    }
                    catch (CoreException e) {
                        ModelUIPlugin.getDefault().logError(e);
                    }
                }
            } else {
                try {
                    file.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ModelUIPlugin.getDefault().logError(e);
                }
            }
            f.setModified(false);
            this.firePropertyChange(257);
        }
    }

    protected void pageChange(int newPageIndex) {
        this.deactivateSite(false, false);
        boolean isText = this.selectedPageIndex == this.getSourcePageIndex();
        this.selectedPageIndex = newPageIndex;
        Control control = this.getControl(newPageIndex);
        if (control != null) {
            control.setVisible(true);
        }
        this.setFocus();
        IEditorPart activeEditor = this.getEditor(newPageIndex);
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributorWrapper) {
            contributor = ((EditorActionBarContributorWrapper)contributor).getActiveContributer();
        }
        if (contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(activeEditor);
        }
        this.updateSelectionProvider();
        if (this.postponedTextSelection.selected != null) {
            Display.getDefault().asyncExec((Runnable)this.postponedTextSelection);
        }
        if (isText && newPageIndex != this.getSourcePageIndex()) {
            this.synchronizeSelectionWithText();
        }
        this.activateSite();
    }

    protected void synchronizeSelectionWithText() {
    }

    protected void updateSelectionProvider() {
    }

    protected boolean checkReadOnlyOnSave() {
        IFile f = this.getFile();
        if (f == null || !f.exists() || !f.isReadOnly()) {
            return true;
        }
        String title = "Save problems";
        String msg = " Cannot could not be completed.";
        Status status = new Status(4, "org.jboss.tools.common.model.ui", 0, MessageFormat.format("File {0} is read-only.", f.getLocation().toString()), (Throwable)new Exception());
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)msg, (IStatus)status);
        return false;
    }

    protected TreeFormPage createTreeFormPage() {
        this.treeFormPage = new TreeFormPage();
        this.treeFormPage.setLabel("Tree");
        this.treeFormPage.setTitle("%TreeFormPage%");
        this.treeFormPage.addErrorSelectionListener(this.createErrorSelectionListener());
        return this.treeFormPage;
    }

    protected void addFormPage(TreeFormPage formPage) {
        try {
            int index = this.addPage((IEditorPart)formPage, this.getEditorInput());
            this.setPageText(index, formPage.getLabel());
            this.selectionProvider.addHost("treeEditor", formPage.getSelectionProvider());
            formPage.getEditorSite().getKeyBindingService();
        }
        catch (PartInitException ex) {
            ModelUIPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[DOLOOP]], but top level block is 21[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initSaveAsDialog(SaveAsDialog dialog) {
        IFile original;
        IFile iFile = original = this.input instanceof IFileEditorInput ? ((IFileEditorInput)this.input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
    }

    private IFile runSaveAsDialog(SaveAsDialog dialog, IProgressMonitor progressMonitor) {
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return null;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getFile(filePath);
    }

    void updateTitle() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ObjectMultiPageEditor.this.setPartName(ObjectMultiPageEditor.this.getEditorInput().getName());
            }
        });
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public void switchToSourceTab() {
        this.setActiveEditor((IEditorPart)this.textEditor);
    }

    class ActivationListener
    extends ShellAdapter
    implements IPartListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;

        ActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
            if (ObjectMultiPageEditor.this.getActivePage() != ObjectMultiPageEditor.this.getSourcePageIndex() && ObjectMultiPageEditor.this.textEditor != null && ObjectMultiPageEditor.this.textEditor.isModified()) {
                ObjectMultiPageEditor.this.textEditor.save();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void shellActivated(ShellEvent e) {
            ObjectMultiPageEditor.this.updateEditableMode();
            e.widget.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ActivationListener.this.handleActivation();
                    if (((ActivationListener)ActivationListener.this).ObjectMultiPageEditor.this.textEditor != null && ((ActivationListener)ActivationListener.this).ObjectMultiPageEditor.this.textEditor.isModified()) {
                        ((ActivationListener)ActivationListener.this).ObjectMultiPageEditor.this.textEditor.save();
                    }
                }
            });
        }

        private void handleActivation() {
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart != null && this.fActivePart.getSite() == ObjectMultiPageEditor.this.getSite()) {
                this.fIsHandlingActivation = true;
                try {
                    ObjectMultiPageEditor.this.doSanityCheckState(ObjectMultiPageEditor.this.getEditorInput());
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }
    }

    class ErrorSelectionListenerImpl
    implements ErrorSelectionListener {
        ErrorSelectionListenerImpl() {
        }

        @Override
        public void errorSelected(int line, int position) {
            ObjectMultiPageEditor.this.doErrorSelected(line, position);
        }
    }

    class OutlineSelectionListener
    implements ISelectionChangedListener {
        boolean isFiringToSource = false;

        OutlineSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.isFiringToSource) {
                return;
            }
            ISelection s = event.getSelection();
            if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                return;
            }
            if (ObjectMultiPageEditor.this.selectionProvider.isFiringSelection() && ObjectMultiPageEditor.this.getActivePage() == ObjectMultiPageEditor.this.getSourcePageIndex()) {
                return;
            }
            if (ObjectMultiPageEditor.this.outline.getControl() == null || ObjectMultiPageEditor.this.outline.getControl().isDisposed()) {
                return;
            }
            boolean isFocused = ObjectMultiPageEditor.this.outline.getControl().isFocusControl();
            if (isFocused) {
                this.isFiringToSource = true;
                ObjectMultiPageEditor.this.selectionProvider.setSelection(event.getSelection());
                this.isFiringToSource = false;
                return;
            }
            if (!isFocused && ObjectMultiPageEditor.this.getActivePage() == ObjectMultiPageEditor.this.getSourcePageIndex()) {
                return;
            }
            Object o = ((IStructuredSelection)s).getFirstElement();
            if (!(o instanceof XModelObject)) {
                return;
            }
            XModelObject so = (XModelObject)o;
            this.isFiringToSource = true;
            ObjectMultiPageEditor.this.postponedTextSelection.select(so, null);
            this.isFiringToSource = false;
        }
    }

    class PostMultiPageEditorSite
    extends MultiPageEditorSite {
        private ISelectionChangedListener postSelectionChangedListener;

        public PostMultiPageEditorSite(ObjectMultiPageEditor multiPageEditor, IEditorPart editor) {
            super((MultiPageEditorPart)multiPageEditor, editor);
            this.postSelectionChangedListener = null;
        }

        private ISelectionChangedListener getPostSelectionChangedListener() {
            if (this.postSelectionChangedListener == null) {
                this.postSelectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        PostMultiPageEditorSite.this.handlePostSelectionChanged(event);
                    }
                };
            }
            return this.postSelectionChangedListener;
        }

        protected void handlePostSelectionChanged(SelectionChangedEvent event) {
            XModelObject o;
            if (ObjectMultiPageEditor.this.selectedPageIndex != ObjectMultiPageEditor.this.getSourcePageIndex()) {
                return;
            }
            ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
            ISelection s = event.getSelection();
            if (s == null || s.isEmpty()) {
                return;
            }
            if (s instanceof ITextSelection && (o = ObjectMultiPageEditor.this.textEditor.findModelObjectAtCursor()) != null) {
                SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, (ISelection)new StructuredSelection((Object)o));
                if (parentProvider instanceof XModelObjectSelectionProvider) {
                    ((XModelObjectSelectionProvider)parentProvider).postSelectionChanged(newEvent);
                }
            }
        }

        public void setSelectionProvider(ISelectionProvider provider) {
            ISelectionProvider oldSelectionProvider = this.getSelectionProvider();
            if (oldSelectionProvider != null && oldSelectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)oldSelectionProvider).removePostSelectionChangedListener(this.getPostSelectionChangedListener());
            }
            super.setSelectionProvider(provider);
            if (provider != null && provider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)provider).addPostSelectionChangedListener(this.getPostSelectionChangedListener());
            }
        }
    }

    class PostponedTextSelection
    implements Runnable {
        XModelObject selected = null;
        String attribute = null;
        boolean _lock = false;

        PostponedTextSelection() {
        }

        public void clean() {
            this.selected = null;
            this.attribute = null;
        }

        public void select(XModelObject object, String attr) {
            if (ObjectMultiPageEditor.this.textEditor == null || this._lock) {
                return;
            }
            if (ObjectMultiPageEditor.this.getActivePage() == ObjectMultiPageEditor.this.getSourcePageIndex()) {
                this._lock = true;
                try {
                    ObjectMultiPageEditor.this.textEditor.selectModelObject(object, attr);
                }
                finally {
                    this._lock = false;
                }
            } else {
                this.selected = object;
                this.attribute = attr == null || attr.length() == 0 ? null : attr;
            }
        }

        @Override
        public void run() {
            if (this.selected == null || ObjectMultiPageEditor.this.textEditor == null) {
                return;
            }
            if (this._lock) {
                return;
            }
            this._lock = true;
            try {
                ObjectMultiPageEditor.this.textEditor.selectModelObject(this.selected, this.attribute);
            }
            finally {
                this._lock = false;
            }
            this.clean();
        }
    }

    class TextFocusListener
    extends FocusAdapter {
        TextFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (!ObjectMultiPageEditor.this.textEditor.isModified()) {
                return;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ((TextFocusListener)TextFocusListener.this).ObjectMultiPageEditor.this.textEditor.save();
                }
            });
        }
    }

    private class TextSelectionProvider
    extends AbstractSelectionProvider
    implements ISelectionChangedListener {
        boolean inites = false;

        private TextSelectionProvider() {
        }

        public void init() {
            if (this.inites) {
                return;
            }
            this.inites = true;
            if (ObjectMultiPageEditor.this.textEditor instanceof TextEditor) {
                ((TextEditor)ObjectMultiPageEditor.this.textEditor).getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        @Override
        protected XModelObject getSelectedModelObject() {
            XModelObject o;
            XModelObject xModelObject = o = ObjectMultiPageEditor.this.textEditor == null ? null : ObjectMultiPageEditor.this.textEditor.findModelObjectAtCursor();
            if (o != null) {
                return o;
            }
            return ObjectMultiPageEditor.this.getModelObject();
        }

        @Override
        protected void setSelectedModelObject(XModelObject object) {
            ObjectMultiPageEditor.this.postponedTextSelection.select(object, null);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fireSelectionChanged();
        }

        public void dispose() {
            if (ObjectMultiPageEditor.this.textEditor instanceof TextEditor) {
                ((TextEditor)ObjectMultiPageEditor.this.textEditor).getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    class U
    implements Runnable {
        U() {
        }

        @Override
        public void run() {
            ObjectMultiPageEditor.this.lock2 = true;
            try {
                ObjectMultiPageEditor.this.update0();
                while (ObjectMultiPageEditor.this.needsUpdate()) {
                    ObjectMultiPageEditor.this.update0();
                }
            }
            finally {
                ObjectMultiPageEditor.this.lock2 = false;
            }
        }
    }
}

