/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.action.ModelContributionManager;
import org.jboss.tools.common.model.ui.dnd.ControlDragDrop;
import org.jboss.tools.common.model.ui.navigator.LabelDecoratorImpl;
import org.jboss.tools.common.model.ui.navigator.NavigatorLabelProvider;
import org.jboss.tools.common.model.ui.navigator.TreeDragDropProvider;
import org.jboss.tools.common.model.ui.navigator.TreeViewerMenuInvoker;
import org.jboss.tools.common.model.ui.navigator.TreeViewerModelListenerImpl;
import org.jboss.tools.common.model.ui.outline.OutlineMenuInvoker;
import org.jboss.tools.common.model.ui.outline.XModelObjectContentProvider;
import org.jboss.tools.common.model.util.XModelObjectCache;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTASync;

public class XModelObjectTreeViewComponent {
    XModel model;
    XModelObjectCache cache;
    XModelObjectContentProvider content = new XModelObjectContentProvider();
    ILabelProvider label;
    TreeViewerMenuInvoker menu = new OutlineMenuInvoker();
    TreeViewerModelListenerImpl listener;
    XModelTreeListenerSWTASync syncListener;
    private TreeDragDropProvider dndProvider = new TreeDragDropProvider();
    private ControlDragDrop dnd = new ControlDragDrop();
    TreeViewer treeViewer = null;
    IEditorPart part;
    SelectionProviderImpl selectionProvider = new SelectionProviderImpl();

    public XModelObjectTreeViewComponent(IEditorPart part) {
        this(part, new TreeViewerModelListenerImpl());
    }

    public void setMenuInvoker(TreeViewerMenuInvoker menu) {
    }

    protected XModelObjectTreeViewComponent(IEditorPart part, TreeViewerModelListenerImpl listener) {
        this.part = part;
        this.listener = listener;
        this.syncListener = new XModelTreeListenerSWTASync(listener);
    }

    public void setCache(XModelObjectCache cache) {
        this.cache = cache;
        this.setModel(cache.getObject().getModel());
        this.content.setRoot(cache);
    }

    public void setModel(XModel model) {
        if (this.model == model) {
            return;
        }
        if (this.model == null && this.treeViewer != null && this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
            model.addModelTreeListener((XModelTreeListener)this.syncListener);
        }
        if (model == null) {
            this.model.removeModelTreeListener((XModelTreeListener)this.syncListener);
        }
        this.model = model;
        if (model != null) {
            model.addModelTreeListener((XModelTreeListener)this.syncListener);
        }
    }

    public void setModelObject(XModelObject object) {
        if (object == null && this.cache == null) {
            return;
        }
        if (object != null && this.cache != null && this.cache.getObject() == object) {
            return;
        }
        this.cache = object == null ? null : new XModelObjectCache(object);
        this.setModel(object == null ? null : object.getModel());
        this.content.setRoot(this.cache);
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)this.cache);
        }
    }

    public Control createControl(Composite parent, int style) {
        this.treeViewer = new TreeViewer(parent, style);
        this.treeViewer.setAutoExpandLevel(2);
        this.label = LabelDecoratorImpl.decorateLabelProvider((ILabelProvider)new NavigatorLabelProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.label);
        this.treeViewer.setContentProvider((IContentProvider)this.content);
        this.treeViewer.setInput((Object)(this.cache == null ? null : this.cache));
        this.initContextMenu();
        this.menu.setViewer((Viewer)this.treeViewer);
        this.treeViewer.getTree().addMouseListener((MouseListener)this.menu);
        this.listener.setViewer(this.treeViewer);
        this.dnd.setProvider(this.dndProvider);
        this.dndProvider.setTree(this.treeViewer.getTree());
        this.dnd.enable();
        if (this.cache != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (XModelObjectTreeViewComponent.this.treeViewer != null) {
                        ISelection s = XModelObjectTreeViewComponent.this.treeViewer.getSelection();
                        if (s != null && !s.isEmpty()) {
                            return;
                        }
                        XModelObjectTreeViewComponent.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)XModelObjectTreeViewComponent.this.cache.getObject()));
                    }
                }
            });
        }
        this.selectionProvider.setTreeViewer(this.getViewer());
        return this.treeViewer.getTree();
    }

    protected void initContextMenu() {
        ModelContributionManager menuMgr = new ModelContributionManager(null, this.menu){

            @Override
            public XActionList getActionList(XModelObject o) {
                if (o.getFileType() != 1) {
                    return super.getActionList(o);
                }
                String ent = String.valueOf(o.getModelEntity().getName()) + "_EditorActionList";
                XModelEntity entity = o.getModel().getMetaData().getEntity(ent);
                return entity != null ? entity.getActionList() : super.getActionList(o);
            }
        };
        this.menu.setStandardInvoker(menuMgr);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                XModelObjectTreeViewComponent.this.fillContextMenu(manager);
            }
        });
        TreeViewer treeViewer = this.getViewer();
        Menu menu = menuMgr.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
        this.part.getSite().registerContextMenu((MenuManager)menuMgr, (ISelectionProvider)treeViewer);
    }

    protected void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (menu instanceof ModelContributionManager) {
            ((ModelContributionManager)menu).setSelection((ISelection)selection);
        }
        menu.update(true);
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, 2816);
    }

    public void dispose() {
        this.treeViewer = null;
        this.disconnect();
        this.model = null;
        if (this.content != null) {
            this.content.dispose();
            this.content = null;
        }
        if (this.syncListener != null) {
            this.syncListener.dispose();
            this.syncListener = null;
        }
        if (this.listener != null) {
            this.listener.disopse();
        }
        this.listener = null;
        if (this.selectionProvider != null) {
            this.selectionProvider.dispose();
        }
        this.selectionProvider = null;
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        this.part = null;
    }

    private void disconnect() {
        if (this.model != null) {
            this.model.removeModelTreeListener((XModelTreeListener)this.syncListener);
        }
    }

    public void addFilter(XFilteredTreeConstraint filter) {
        this.content.addFilter(filter);
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    class SelectionProviderImpl
    implements ISelectionProvider {
        ArrayList<ISelectionChangedListener> listeners = new ArrayList();
        ISelection selection = null;
        TreeViewer tv;

        SelectionProviderImpl() {
        }

        public void setTreeViewer(TreeViewer tv) {
            this.tv = tv;
            ISelectionChangedListener[] cl = this.listeners.toArray(new ISelectionChangedListener[0]);
            int i = 0;
            while (i < cl.length) {
                tv.addSelectionChangedListener(cl[i]);
                ++i;
            }
            if (this.selection != null) {
                tv.setSelection(this.selection);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
            if (this.tv != null) {
                this.tv.addSelectionChangedListener(listener);
            }
        }

        public ISelection getSelection() {
            return this.tv == null ? this.selection : this.tv.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
            if (this.tv != null) {
                this.tv.removeSelectionChangedListener(listener);
            }
        }

        public void setSelection(ISelection selection) {
            if (this.isEqualSelection(selection)) {
                return;
            }
            this.selection = selection;
            if (this.tv != null) {
                this.tv.setSelection(selection);
            } else {
                int i = 0;
                while (i < this.listeners.size()) {
                    ISelectionChangedListener l = this.listeners.get(i);
                    l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                    ++i;
                }
            }
        }

        private boolean isEqualSelection(ISelection selection) {
            if (!(this.selection instanceof StructuredSelection) && !(selection instanceof StructuredSelection)) {
                return true;
            }
            if (this.selection instanceof StructuredSelection || selection instanceof StructuredSelection) {
                return false;
            }
            return ((StructuredSelection)this.selection).getFirstElement() == ((StructuredSelection)selection).getFirstElement();
        }

        public void fireSelectionChanged() {
            if (this.listeners.isEmpty()) {
                return;
            }
            ISelection selection = this.getSelection();
            if (selection == null) {
                return;
            }
            SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().selectionChanged(newEvent);
            }
        }

        public XModelObject getModelObject(ISelection selection) {
            if (selection == null || selection.isEmpty()) {
                return null;
            }
            IStructuredSelection s = (IStructuredSelection)selection;
            Object o = s.getFirstElement();
            return o instanceof XModelObject ? (XModelObject)o : null;
        }

        public void dispose() {
            if (this.listeners != null) {
                this.listeners.clear();
            }
            this.listeners = null;
            this.tv = null;
        }
    }
}

