/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor.form;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.editor.form.DefaultChildrenForm;
import org.jboss.tools.common.editor.form.IForm;
import org.jboss.tools.common.editor.form.PropertyForm;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public class FormPlace {
    Composite composite = null;
    XModelObject selected = null;
    IForm form = null;

    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(Display.getDefault().getSystemColor(1));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        if (this.form != null) {
            this.form.createControl(this.composite);
        }
        return this.composite;
    }

    public Control getControl() {
        return this.composite;
    }

    public void setSelectedObject(XModelObject object) {
        if (this.selected == object) {
            return;
        }
        this.selected = object;
        Class c = this.getFormClassForSelection();
        if (this.form == null || c == null || this.form.getClass() != c) {
            if (this.form != null) {
                this.form.dispose();
                this.form = null;
            }
            if (c != null) {
                this.installForm(c);
            }
        } else {
            this.form.setInput(this.selected);
        }
    }

    private void installForm(Class cls) {
        try {
            this.form = (IForm)cls.newInstance();
        }
        catch (InstantiationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return;
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return;
        }
        this.form.setInput(this.selected);
        if (this.composite != null && !this.composite.isDisposed()) {
            Control c = this.form.createControl(this.composite);
            c.setLayoutData((Object)new GridData(1808));
            this.composite.update();
            this.composite.layout();
        }
    }

    public void dispose() {
        if (this.form != null) {
            this.form.dispose();
        }
        this.form = null;
        if (this.composite != null) {
            if (!this.composite.isDisposed()) {
                this.composite.dispose();
            }
            this.composite = null;
        }
    }

    private Class getFormClassForSelection() {
        if (this.selected == null) {
            return null;
        }
        XChild[] cs = this.selected.getModelEntity().getChildren();
        int cl = cs.length;
        if (cl == 0) {
            return PropertyForm.class;
        }
        if (cl > 1) {
            return PropertyForm.class;
        }
        if (cl == 1) {
            return DefaultChildrenForm.class;
        }
        return null;
    }

    public void update() {
        if (this.form != null) {
            this.form.update();
        }
    }
}

