/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor.form;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.jboss.tools.common.editor.SelectionNotifier;
import org.jboss.tools.common.editor.XModelObjectTreeViewComponent;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.forms.ExpandableForm;
import org.jboss.tools.common.model.ui.widgets.BorderedControl;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.util.XModelObjectCache;

public class SampleTreeForm
extends ExpandableForm
implements ISelectionChangedListener {
    private XModelObject xmo;
    private XModelObjectTreeViewComponent tree;
    private XFilteredTreeConstraint[] filters = new XFilteredTreeConstraint[0];
    private SelectionNotifier notifier;
    boolean selectionLock = false;
    private HashMap<String, String> actionMapping = new HashMap();

    public SampleTreeForm(IEditorPart part) {
        this.tree = new XModelObjectTreeViewComponent(part);
        this.headingText = "Tree Form";
        this.setCollapsable(Boolean.FALSE);
        this.createActionMapping();
    }

    @Override
    public void setFocus() {
        Control c;
        if (this.tree != null && this.tree.getViewer() != null && (c = this.tree.getViewer().getControl()) != null && !c.isDisposed()) {
            c.setFocus();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.tree != null) {
            this.tree.dispose();
        }
        this.tree = null;
        if (this.actionMapping != null) {
            this.actionMapping.clear();
        }
        this.actionMapping = null;
    }

    public void addFilter(XFilteredTreeConstraint filter) {
        this.filters = new XFilteredTreeConstraint[]{filter};
    }

    @Override
    protected Control createClientArea(Composite parent, IWidgetSettings settings) {
        BorderedControl borderedControl = new BorderedControl(parent, 0, settings.getBorder("Table.Border"));
        borderedControl.setLayoutData(new GridData(1808));
        Control treeControl = this.tree.createControl((Composite)borderedControl, 768);
        treeControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SampleTreeForm.this.tree.dispose();
            }
        });
        GridData gd = new GridData(1808);
        treeControl.setLayoutData((Object)gd);
        if (this.notifier != null) {
            this.tree.getViewer().addSelectionChangedListener((ISelectionChangedListener)this.notifier);
        }
        return borderedControl;
    }

    @Override
    public void initialize(Object model) {
        this.xmo = (XModelObject)model;
        this.model = this.xmo.getModel();
        this.setHeadingText(this.xmo.getAttributeValue("name"));
        int i = 0;
        while (i < this.filters.length) {
            this.tree.addFilter(this.filters[i]);
            ++i;
        }
        this.tree.setCache(new XModelObjectCache(this.xmo));
    }

    public void setSelectionNotifier(SelectionNotifier notifier) {
        SelectionNotifier oldListener = this.notifier;
        if (this.tree != null && this.tree.getViewer() != null) {
            if (notifier != null) {
                if (oldListener != null) {
                    this.tree.getViewer().removeSelectionChangedListener((ISelectionChangedListener)oldListener);
                }
                this.tree.getViewer().addPostSelectionChangedListener((ISelectionChangedListener)notifier);
            } else {
                this.tree.getViewer().removeSelectionChangedListener((ISelectionChangedListener)notifier);
            }
        }
        this.notifier = notifier;
        notifier.addSelectionChangedListener(this);
    }

    @Override
    public void setHeadingText(String heading) {
        if (heading.equals(this.getHeadingText())) {
            return;
        }
        super.setHeadingText(heading);
        if (this.section != null && !this.section.isDisposed()) {
            this.section.setText(this.getHeadingText());
        }
    }

    @Override
    public void update() {
        super.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.tree == null || this.tree.getViewer() == null) {
            return;
        }
        if (this.selectionLock) {
            return;
        }
        this.selectionLock = true;
        try {
            TreeViewer viewer = this.tree.getViewer();
            ISelection oldSelection = viewer.getSelection();
            ISelection newSelection = event.getSelection();
            if (oldSelection.equals(newSelection) || newSelection instanceof ITextSelection) {
                return;
            }
            viewer.setSelection(newSelection);
            if (viewer.getSelection().isEmpty() && !oldSelection.isEmpty()) {
                viewer.setSelection(oldSelection);
            }
        }
        finally {
            this.selectionLock = false;
        }
    }

    private void createActionMapping() {
        this.actionMapping.put(ActionFactory.COPY.getId(), "CopyActions.Copy");
        this.actionMapping.put(ActionFactory.CUT.getId(), "CopyActions.Cut");
        this.actionMapping.put(ActionFactory.PASTE.getId(), "CopyActions.Paste");
        this.actionMapping.put(ActionFactory.DELETE.getId(), "DeleteActions.Delete");
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        XAction action;
        Control c;
        String actionPath = this.actionMapping.get(actionId);
        if (actionPath == null) {
            return false;
        }
        Control control = c = this.tree.getViewer() == null ? null : this.tree.getViewer().getControl();
        if (c == null || !c.isFocusControl()) {
            return false;
        }
        ISelection selection = this.tree.getSelectionProvider().getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection ss = (StructuredSelection)selection;
        if (!(ss.getFirstElement() instanceof XModelObject)) {
            return true;
        }
        XModelObject object = (XModelObject)ss.getFirstElement();
        XModelObject[] os = null;
        if (ss.size() > 1) {
            os = new XModelObject[ss.size()];
            Iterator it = ss.iterator();
            int i = 0;
            while (i < os.length) {
                os[i] = (XModelObject)it.next();
                ++i;
            }
        }
        if ((action = XActionInvoker.getAction((String)actionPath, (XModelObject)object)) == null) {
            return true;
        }
        if (os == null) {
            if (!action.isEnabled(object)) {
                return true;
            }
            XActionInvoker.invoke((String)actionPath, (XModelObject)object, (Properties)new Properties());
        } else {
            if (!action.isEnabled(object, os)) {
                return true;
            }
            XActionInvoker.invoke((String)actionPath, (XModelObject)object, (XModelObject[])os, (Properties)new Properties());
        }
        return true;
    }
}

