/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.viewers.xpl.CheckStateChangedEvent;
import org.jboss.tools.common.model.ui.viewers.xpl.ICheckStateListener;
import org.jboss.tools.common.model.ui.viewers.xpl.ICheckable;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class CheckTreeAdapter
extends DefaultValueAdapter
implements ITreeContentProvider {
    protected CheckTree tree;
    protected CheckLabelProvider labelProvider;
    protected ISelectionChangedListener selectionChangedListener;
    private Image IMAGE_CHECK = EclipseResourceUtil.getImage((String)"images/common/check.gif");
    private Image IMAGE_UNCHECK = EclipseResourceUtil.getImage((String)"images/common/uncheck.gif");
    private Image IMAGE_HALFCHECK = EclipseResourceUtil.getImage((String)"images/common/halfcheck.gif");

    public CheckTreeAdapter() {
        this.tree = new CheckTree();
        this.tree.addRoot(new CheckItem("Item1", 1));
        this.tree.addRoot(new CheckItem("Item2", 0));
        this.tree.addRoot(new CheckItem("Item3", 2));
    }

    public Object[] getChildren(Object parentElement) {
        return ((CheckItem)parentElement).getChildrens();
    }

    public Object getParent(Object element) {
        return ((CheckItem)element).getParent();
    }

    public boolean hasChildren(Object element) {
        return ((CheckItem)element).hasChildren();
    }

    public Object[] getElements(Object inputElement) {
        return this.tree.getRoot();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.tree != null) {
            this.tree.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.selectionChangedListener = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == ILabelProvider.class) {
            if (this.labelProvider == null) {
                this.labelProvider = new CheckLabelProvider();
            }
            return this.labelProvider;
        }
        if (adapter == ITreeContentProvider.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public class CheckItem
    implements ICheckable {
        private ArrayList<CheckItem> childs;
        private CheckItem parent;
        private int state;
        private int userState;
        private String name;
        private CheckTree tree;
        private Object data;

        private CheckItem() {
        }

        public CheckItem(String name, int state) {
            this.childs = new ArrayList();
            this.parent = null;
            this.name = name;
            this.state = state;
            this.userState = state;
        }

        public CheckItem(String name, int state, CheckItem parent) {
            this.childs = new ArrayList();
            this.name = name;
            this.state = state;
            this.userState = state;
            if (parent != null) {
                parent.addChild(this);
            }
        }

        public CheckItem(String name, int state, Object data) {
            this.childs = new ArrayList();
            this.parent = null;
            this.name = name;
            this.state = state;
            this.data = data;
            this.userState = state;
        }

        public CheckItem(String name, int state, Object data, CheckItem parent) {
            this.childs = new ArrayList();
            this.name = name;
            this.state = state;
            this.data = data;
            this.userState = state;
            if (parent != null) {
                parent.addChild(this);
            }
        }

        public void addChild(CheckItem child) {
            this.childs.add(child);
            child.setParent(this);
            if (this.childs.size() == 1) {
                this.setState(child.getState());
            }
            if (this.getState() != 2 && this.getState() != child.getState()) {
                this.setState(2);
            }
        }

        public void removeChild(CheckItem child) {
            this.childs.remove(this.childs.indexOf(child));
            child.setParent(null);
        }

        public CheckItem[] getChildrens() {
            return this.childs.toArray(new CheckItem[this.childs.size()]);
        }

        public boolean hasChildren() {
            return this.childs.size() > 0;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CheckItem getParent() {
            return this.parent;
        }

        public void setParent(CheckItem parent) {
            this.parent = parent;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        @Override
        public void addCheckStateListener(ICheckStateListener listener) {
        }

        @Override
        public int getState(Object element) {
            if (element == null) {
                return this.state;
            }
            if (this.tree != null) {
                return this.tree.getState(element);
            }
            return 0;
        }

        @Override
        public void removeCheckStateListener(ICheckStateListener listener) {
        }

        @Override
        public boolean setState(Object element, int state) {
            if (this.tree != null) {
                return this.tree.setState(element, state);
            }
            this.setState(state);
            return Boolean.FALSE;
        }

        public CheckTree getTree() {
            return this.tree;
        }

        public void setTree(CheckTree tree) {
            this.tree = tree;
            if (this.hasChildren()) {
                Iterator<CheckItem> i = this.childs.iterator();
                while (i.hasNext()) {
                    i.next().setTree(tree);
                }
            }
        }

        protected void toState(int nextState) {
            if (nextState == 1) {
                this.setState(this, 1);
                if (this.hasChildren()) {
                    CheckItem[] childs = this.getChildrens();
                    int i = 0;
                    while (i < childs.length) {
                        childs[i].toState(nextState);
                        ++i;
                    }
                }
            } else if (nextState == 0) {
                this.setState(this, 0);
                if (this.hasChildren()) {
                    CheckItem[] childs = this.getChildrens();
                    int i = 0;
                    while (i < childs.length) {
                        childs[i].toState(nextState);
                        ++i;
                    }
                }
            } else if (!this.hasChildren()) {
                this.setState(this, this.getUserState());
            } else {
                this.setUserState(nextState);
                if (this.hasChildren()) {
                    CheckItem[] childs = this.getChildrens();
                    int i = 0;
                    while (i < childs.length) {
                        childs[i].toState(nextState);
                        ++i;
                    }
                }
                boolean skipHalf = Boolean.TRUE;
                CheckItem[] childs = this.getChildrens();
                int childUserState = childs[0].getUserState();
                int i = 1;
                while (i < childs.length) {
                    if (childs[i].getUserState() == 2) {
                        skipHalf = Boolean.FALSE;
                        break;
                    }
                    if (childUserState != childs[i].getUserState()) {
                        skipHalf = Boolean.FALSE;
                        break;
                    }
                    ++i;
                }
                if (skipHalf) {
                    this.setState(this, childUserState);
                } else {
                    this.setState(this, nextState);
                }
            }
        }

        @Override
        public void toggle(Object element) {
            if (element == this) {
                int nextState = this.getNextState();
                this.toState(nextState);
                Iterator<CheckItem> i = this.childs.iterator();
                while (i.hasNext()) {
                    i.next().toState(nextState);
                }
                if (this.parent != null) {
                    this.parent.toggle(element);
                }
            } else {
                for (CheckItem item : this.childs) {
                    item.setUserState(item.getState());
                }
                CheckItem[] childs = this.getChildrens();
                int childState = childs[0].getState();
                int j = 1;
                while (j < childs.length) {
                    if (childState != childs[j].getState()) {
                        childState = 2;
                        break;
                    }
                    ++j;
                }
                this.setState(this, childState);
                if (this.parent != null) {
                    this.parent.toggle(element);
                }
            }
        }

        private int getNextState() {
            if (this.getState() == 0) {
                if (this.hasChildren()) {
                    boolean skipHalf = Boolean.TRUE;
                    if (this.hasChildren()) {
                        CheckItem[] childs = this.getChildrens();
                        int childUserState = childs[0].getUserState();
                        int i = 1;
                        while (i < childs.length) {
                            if (childs[i].getUserState() == 2) {
                                skipHalf = Boolean.FALSE;
                                break;
                            }
                            if (childUserState != childs[i].getUserState()) {
                                skipHalf = Boolean.FALSE;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (skipHalf) {
                        return 1;
                    }
                    return 2;
                }
                return 1;
            }
            if (this.getState() == 2) {
                return 1;
            }
            return 0;
        }

        public boolean hasChildUserState() {
            Iterator<CheckItem> i = this.childs.iterator();
            while (i.hasNext()) {
                if (!i.next().hasChildUserState()) continue;
                return Boolean.TRUE;
            }
            return this.state != this.userState;
        }

        public int getUserState() {
            return this.userState;
        }

        public void setUserState(int userState) {
            this.userState = userState;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }

    protected class CheckLabelProvider
    extends LabelProvider {
        protected CheckLabelProvider() {
        }

        public String getText(Object element) {
            return ((CheckItem)element).getName();
        }
    }

    public class CheckTree
    implements ICheckable {
        private ArrayList<ICheckStateListener> listeners = new ArrayList();
        private ArrayList<CheckItem> roots = new ArrayList();

        public void dispose() {
            this.listeners.clear();
        }

        public CheckItem[] getRoot() {
            return this.roots.toArray(new CheckItem[this.roots.size()]);
        }

        public void addRoot(CheckItem child) {
            this.roots.add(child);
            child.setTree(this);
        }

        public void removeRoot(CheckItem child) {
            this.roots.remove(this.roots.indexOf(child));
            child.setTree(null);
        }

        public boolean hasChildren(CheckItem element) {
            return this.roots.size() > 0;
        }

        @Override
        public void addCheckStateListener(ICheckStateListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public int getState(Object element) {
            if (element == null) {
                return 0;
            }
            return ((CheckItem)element).getState();
        }

        @Override
        public void removeCheckStateListener(ICheckStateListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public boolean setState(Object element, int state) {
            CheckItem item = (CheckItem)element;
            int oldState = item.getState();
            item.setState(state);
            if (oldState != state) {
                this.fireStateChanged(item);
            }
            return Boolean.TRUE;
        }

        protected void fireStateChanged(CheckItem item) {
            Iterator<ICheckStateListener> i = this.listeners.iterator();
            CheckStateChangedEvent event = new CheckStateChangedEvent(this, item, item.getState());
            while (i.hasNext()) {
                i.next().checkStateChanged(event);
            }
        }

        @Override
        public void toggle(Object element) {
        }
    }
}

