/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.actions.IActionProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultTreeSelectionContentAssistProcessor;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXAttributeTreeContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXModelObjectLabelProvider;

public class DefaultTreeSelectionAdapter
extends DefaultValueAdapter
implements IAdaptable,
ISelectionProvider,
ISelectionChangedListener {
    public static final String LINK_ACTION = "linkAction";
    protected ILabelProvider labelProvider;
    protected ITreeContentProvider treeContentProvider;
    ArrayList<ISelectionChangedListener> selectionChangeListeners = new ArrayList();
    private ActionProvider actionProvider;
    private DefaultValueAdapter.XActionWrapper labelAction;

    @Override
    public void dispose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.labelProvider = null;
        if (this.treeContentProvider != null) {
            this.treeContentProvider.dispose();
        }
        this.treeContentProvider = null;
        if (this.actionProvider != null) {
            this.actionProvider.dispose();
        }
        this.actionProvider = null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IValueProvider.class) {
            return this;
        }
        if (adapter == IValueChangeListener.class) {
            return this;
        }
        if (adapter == IAttributeErrorProvider.class) {
            return this;
        }
        if (adapter == ISelectionProvider.class) {
            return this;
        }
        if (adapter == ISelectionChangedListener.class) {
            return this;
        }
        if (adapter == ILabelProvider.class) {
            if (this.labelProvider == null) {
                this.labelProvider = new DefaultXModelObjectLabelProvider();
            }
            return this.labelProvider;
        }
        if (adapter == ITreeContentProvider.class) {
            return this.getTreeContentProvider();
        }
        if (adapter == IActionProvider.class) {
            return this.getActionProvider();
        }
        if (adapter == IContentAssistProcessor.class) {
            DefaultTreeSelectionContentAssistProcessor processor = new DefaultTreeSelectionContentAssistProcessor();
            ITreeContentProvider tree = this.getTreeContentProvider();
            if (tree instanceof DefaultXAttributeTreeContentProvider) {
                processor.setTreeProvider((DefaultXAttributeTreeContentProvider)tree);
                return processor;
            }
            return null;
        }
        Assert.isTrue((boolean)true, (String)("DefaultTreeSelectionAdapter instance itself cannot provide adapter for " + adapter.getName()));
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.add(listener);
    }

    public ISelection getSelection() {
        Object v = this.getValue();
        Object object = v == null ? null : this.getObjectByPath(v.toString());
        return object == null ? new StructuredSelection() : new StructuredSelection(object);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        for (XModelObject object : selection) {
            if (this.getFilteredTree() == null) {
                return;
            }
            if (!this.getFilteredTree().isSelectable(object)) continue;
            this.valueChange(new PropertyChangeEvent(this, "IPropertyEditor.value", null, this.getPathByObject(object)));
            if (this.labelAction == null) continue;
            this.labelAction.setXModelObject(object);
        }
    }

    private Object getObjectByPath(String path) {
        if (this.getFilteredTree() != null) {
            return this.getFilteredTree().find(path);
        }
        return null;
    }

    private String getPathByObject(Object object) {
        return this.getFilteredTree().getValue((XModelObject)object);
    }

    private XFilteredTree getFilteredTree() {
        if (this.getTreeContentProvider() instanceof DefaultXAttributeTreeContentProvider) {
            return ((DefaultXAttributeTreeContentProvider)this.getTreeContentProvider()).getFilteredTree();
        }
        return null;
    }

    @Override
    protected ActionProvider getActionProvider() {
        if (this.actionProvider == null) {
            this.actionProvider = new ActionProvider();
        }
        return this.actionProvider;
    }

    public ITreeContentProvider getTreeContentProvider() {
        if (this.treeContentProvider == null) {
            DefaultXAttributeTreeContentProvider treeContentProvider = new DefaultXAttributeTreeContentProvider(this.attribute, this.model, this.modelObject);
            this.treeContentProvider = treeContentProvider;
        }
        return this.treeContentProvider;
    }

    private void initActions() {
        XAction xAction;
        String linkActionName;
        this.treeContentProvider = this.getTreeContentProvider();
        if (this.treeContentProvider instanceof DefaultXAttributeTreeContentProvider && (linkActionName = ((DefaultXAttributeTreeContentProvider)this.treeContentProvider).getProperties().getProperty(LINK_ACTION)) != null && (xAction = XActionInvoker.getAction((String)linkActionName, (XModelObject)this.modelObject)) != null) {
            DefaultValueAdapter.XActionWrapper linkAction = new DefaultValueAdapter.XActionWrapper(xAction);
            linkAction.setEnabled(true);
            this.getActionProvider().putAction("Label.Selected", (IAction)linkAction);
        }
    }

    @Override
    public void setAttribute(XAttribute attribute) {
        super.setAttribute(attribute);
        if (this.modelObject != null && attribute != null) {
            this.initActions();
        }
    }

    @Override
    public void setModelObject(XModelObject object) {
        super.setModelObject(object);
        if (this.modelObject != null && this.attribute != null) {
            this.initActions();
        }
    }

    class ActionProvider
    implements IActionProvider {
        private HashMap<String, IAction> actions = new HashMap();

        ActionProvider() {
        }

        @Override
        public IAction getAction(String actionName) {
            return this.actions.get(actionName);
        }

        @Override
        public IAction[] getActions() {
            return this.actions.values().toArray(new IAction[this.actions.values().size()]);
        }

        public void putAction(String actionAlias, IAction action) {
            this.actions.put(actionAlias, action);
        }

        public void dispose() {
            if (this.actions != null) {
                this.actions.clear();
            }
            this.actions = null;
        }

        @Override
        public void update(ISelection selection) {
        }
    }
}

