/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.viewers.xpl.ICheckable;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.wizards.query.list.TreeItemSelectionManager;

public class CheckTreeFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    protected IPropertyEditor propertyEditor;
    protected IValueChangeListener valueChangeListener;
    protected IValueProvider valueProvider;
    protected IContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected ISelectionChangedListener selectionChangedListener;
    protected ISelectionProvider selectionProvider;
    private String stringValue;
    private TreeViewer viewer;

    public CheckTreeFieldEditor() {
    }

    public CheckTreeFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        Control control = this.getLabelComposite();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.viewer.getControl().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Control control = this.getLabelComposite(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.verticalAlignment = 1024;
        control.setLayoutData((Object)gd);
        this.getListControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = numColumns;
        gd.grabExcessHorizontalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.getListControl(parent)};
    }

    private Control getListControl(Composite parent) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            return this.viewer.getControl();
        }
        this.viewer = new TreeViewer(parent);
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setContentProvider(this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)this.contentProvider);
        new TreeItemSelectionManager(this.viewer, new Flipper());
        if (this.selectionProvider != null) {
            this.viewer.setSelection(this.selectionProvider.getSelection(), true);
        }
        if (this.selectionChangedListener != null) {
            this.viewer.addSelectionChangedListener(this.selectionChangedListener);
        }
        return this.viewer.getControl();
    }

    protected void init() {
        this.stringValue = this.valueProvider.getStringValue(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.viewer != null && this.viewer.getTree() != null && !this.viewer.getTree().isDisposed()) {
            this.viewer.getTree().dispose();
        }
        this.viewer = null;
        this.propertyEditor = null;
        this.valueChangeListener = null;
        this.valueProvider = null;
        this.contentProvider = null;
        this.labelProvider = null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
            this.contentProvider = (IContentProvider)propertyEditor.getAdapter(ITreeContentProvider.class);
            this.labelProvider = (ILabelProvider)propertyEditor.getAdapter(ILabelProvider.class);
            this.selectionChangedListener = (ISelectionChangedListener)propertyEditor.getAdapter(ISelectionChangedListener.class);
            this.selectionProvider = (ISelectionProvider)propertyEditor.getAdapter(ISelectionProvider.class);
        }
        this.init();
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent event) {
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected void valueChanged(String newValue) {
        String oldValue = this.stringValue;
        this.stringValue = newValue;
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
        this.valueChangeListener.valueChange(event);
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    @Override
    public void paste() {
    }

    @Override
    public void delete() {
    }

    class Flipper
    implements TreeItemSelectionManager.Listener {
        Flipper() {
        }

        @Override
        public void flip(TreeItem item) {
            Object checkItem = item.getData();
            if (checkItem instanceof ICheckable) {
                ((ICheckable)checkItem).toggle(checkItem);
            }
            CheckTreeFieldEditor.this.viewer.refresh();
        }

        @Override
        public boolean isSelected(Object data) {
            if (data instanceof ICheckable) {
                ICheckable o = (ICheckable)data;
                return o.getState(null) != 0;
            }
            return false;
        }
    }
}

