/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.text.MessageFormat;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBoxCellEditorEx
extends CellEditor {
    private CCombo combo;
    private String[] items = new String[0];
    private Object value = null;
    private int selection;
    private boolean skipDeactivate = Boolean.FALSE;

    public ComboBoxCellEditorEx() {
    }

    public ComboBoxCellEditorEx(Composite parent) {
        this.create(parent);
    }

    public ComboBoxCellEditorEx(Composite parent, int style) {
        this.setStyle(style);
        this.create(parent);
    }

    public ComboBoxCellEditorEx(Composite parent, String[] items, int style) {
        if (items != null) {
            this.items = items;
        }
        this.setStyle(style);
        this.create(parent);
    }

    public void activate() {
        super.activate();
    }

    public void create(Composite parent) {
        super.create(parent);
    }

    public void deactivate() {
        if (!this.skipDeactivate) {
            super.deactivate();
        }
    }

    protected Control createControl(Composite parent) {
        this.combo = new CCombo(parent, this.getStyle());
        this.combo.setItems(this.items);
        this.combo.setFont(parent.getFont());
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ComboBoxCellEditorEx.this.keyReleaseOccured(e);
            }
        });
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                if (!ComboBoxCellEditorEx.this.isActivated()) {
                    return;
                }
                int i = ComboBoxCellEditorEx.this.combo.getSelectionIndex();
                if (i >= 0) {
                    ComboBoxCellEditorEx.this.combo.setText(ComboBoxCellEditorEx.this.combo.getItem(i));
                }
                ComboBoxCellEditorEx.this.applyEditorValueAndDeactivate();
            }
        });
        this.combo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ComboBoxCellEditorEx.this.focusLost();
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComboBoxCellEditorEx.this.check();
            }
        });
        this.setValueValid(true);
        return this.combo;
    }

    protected boolean check() {
        String value = this.combo.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (typedValue == null && newValidState) {
            Assert.isTrue((boolean)false, (String)"Validator isn't limiting the cell editor's type range");
        }
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
        return newValidState;
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.setFocus();
        }
    }

    public void focusLost() {
        if (this.check()) {
            this.value = this.combo.getText();
        }
        this.fireApplyEditorValue();
        super.focusLost();
    }

    public Control getControl() {
        return super.getControl();
    }

    protected void fireApplyEditorValue() {
        super.fireApplyEditorValue();
    }

    protected void fireCancelEditor() {
        this.skipDeactivate = Boolean.TRUE;
        super.fireCancelEditor();
        this.skipDeactivate = Boolean.FALSE;
        this.deactivate();
    }

    protected void doSetValue(Object value) {
        int selection;
        this.value = value;
        if (value instanceof Integer) {
            selection = (Integer)value;
            this.combo.select(selection);
        }
        if (value instanceof String) {
            selection = this.findIndex(value);
            if (selection < 0) {
                this.combo.setText(value.toString());
            } else {
                this.combo.select(selection);
            }
        }
        this.doSetFocus();
    }

    private int findIndex(Object value) {
        String[] items = this.getItems();
        if (items == null) {
            return 0;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    private void populateComboBoxItems() {
        if (this.combo != null && this.items != null) {
            this.combo.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.combo.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    private void applyEditorValueAndDeactivate() {
        String newValue = this.combo.getText();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
        } else {
            this.value = newValue;
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }
}

