/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.editor.IButtonControl;
import org.jboss.tools.common.model.ui.widgets.DefaultSettings;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class DefaultButtonControl
implements IButtonControl {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Composite composite;
    private IWidgetSettings settings;
    private ArrayList<String> actions = new ArrayList();
    private HashMap<String, ButtonWrapper> buttons = new HashMap();
    private Layout layout;

    @Override
    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    @Override
    public void setWidgetSettings(IWidgetSettings settings) {
        this.settings = settings;
    }

    @Override
    public void addButton(String action, String label) {
        this.actions.add(action);
        this.buttons.put(action, new ButtonWrapper(action, label));
        if (this.composite != null) {
            this.createButton(this.composite, this.buttons.get(action));
            this.refresh();
        }
    }

    @Override
    public void removeButton(String action) {
        this.actions.remove(action);
        this.buttons.remove(action);
        if (this.composite != null) {
            this.buttons.get(action).dispose();
            this.refresh();
        }
    }

    @Override
    public void clear() {
        Iterator<String> i = this.actions.iterator();
        while (i.hasNext()) {
            ButtonWrapper buttonWrapper = this.buttons.get(i.next());
            buttonWrapper.dispose();
        }
        this.refresh();
        this.actions.clear();
        this.buttons.clear();
    }

    @Override
    public Control createControl(Composite parent) {
        if (this.composite == null) {
            this.composite = new Composite(parent, 0);
            this.composite.setBackgroundMode(1);
            if (this.layout == null) {
                this.layout = this.createDefaultLayout();
            }
            this.composite.setLayout(this.layout);
            if (this.buttons.size() > 0) {
                for (String object : this.actions) {
                    ButtonWrapper buttonWrapper = this.buttons.get(object);
                    if (buttonWrapper != null) {
                        this.createButton(this.composite, buttonWrapper);
                        continue;
                    }
                    if (!ModelUIPlugin.getDefault().isDebugging()) continue;
                    ModelUIPlugin.getPluginLog().logInfo("No button for action: " + object);
                }
            } else {
                int margins = 0;
                if (this.layout instanceof GridLayout) {
                    margins += ((GridLayout)this.layout).marginWidth * 2;
                }
                GridData gd = new GridData();
                gd.widthHint = margins + this.convertHorizontalDLUsToPixels((Control)this.composite, 61);
                this.composite.setLayoutData((Object)gd);
            }
        }
        return this.composite;
    }

    protected Layout createDefaultLayout() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        return layout;
    }

    protected Control createButton(Composite parent, ButtonWrapper buttonWrapper) {
        int style = this.getSettings().getStyle("Button.Style");
        if (style == -1) {
            style = 8;
        }
        Control buttonControl = buttonWrapper.createControl(parent, style);
        Color bg = this.getSettings().getColor("Button.Background");
        Color fg = this.getSettings().getColor("Button.Foreground");
        Font font = this.getSettings().getFont("Button.Font");
        buttonControl.setBackground(bg);
        buttonControl.setForeground(fg);
        buttonControl.setFont(font);
        GridData gd = new GridData();
        gd.widthHint = this.convertHorizontalDLUsToPixels(buttonControl, 61);
        buttonControl.setLayoutData((Object)gd);
        return buttonControl;
    }

    protected void refresh() {
        if (this.composite == null || this.composite.isDisposed()) {
            return;
        }
        Collection<ButtonWrapper> collection = this.buttons.values();
        for (ButtonWrapper buttonWrapper : collection) {
            buttonWrapper.getControl().setRedraw(Boolean.FALSE.booleanValue());
        }
        this.composite.setRedraw(Boolean.FALSE.booleanValue());
        this.composite.layout(Boolean.TRUE.booleanValue());
        collection = this.buttons.values();
        for (ButtonWrapper buttonWrapper : collection) {
            buttonWrapper.getControl().setRedraw(Boolean.TRUE.booleanValue());
        }
        this.composite.setRedraw(Boolean.TRUE.booleanValue());
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public void setEnabled(String action, boolean enabled) {
        this.buttons.get(action).setEnabled(enabled);
    }

    @Override
    public void dispose() {
        this.clear();
        this.composite.dispose();
        this.composite = null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.pcs.firePropertyChange(event);
    }

    protected void doButtonPressed(Button control, String action) {
        if (ModelUIPlugin.getDefault().isDebugging()) {
            ModelUIPlugin.getPluginLog().logInfo("Button pressed: " + action);
        }
        this.firePropertyChange(new PropertyChangeEvent(control, action, null, Boolean.TRUE));
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    protected int convertVerticalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        double verticalDialogUnitSize = (double)height * 0.125;
        return (int)Math.round((double)dlus * verticalDialogUnitSize);
    }

    public IWidgetSettings getSettings() {
        if (this.settings == null) {
            this.settings = DefaultSettings.getDefault();
        }
        return this.settings;
    }

    public void setSettings(IWidgetSettings settings) {
        this.settings = settings;
    }

    class ButtonWrapper {
        private String buttonAction;
        private String buttonLabel;
        private Button buttonControl;
        private boolean enabled = Boolean.TRUE;

        private ButtonWrapper() {
        }

        public ButtonWrapper(String buttonAction, String buttonLabel) {
            this.buttonAction = buttonAction;
            this.buttonLabel = buttonLabel;
        }

        public Control createControl(Composite parent, int style) {
            if (this.buttonControl == null) {
                this.buttonControl = new Button(parent, style);
                this.buttonControl.setText(this.buttonLabel);
                this.buttonControl.setEnabled(this.enabled);
                this.buttonControl.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        DefaultButtonControl.this.doButtonPressed(ButtonWrapper.this.buttonControl, ButtonWrapper.this.buttonAction);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            return this.buttonControl;
        }

        public Control getControl() {
            return this.buttonControl;
        }

        public void dispose() {
            this.buttonControl.dispose();
            this.buttonControl = null;
            this.buttonAction = null;
            this.buttonLabel = null;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            if (this.buttonControl != null) {
                this.buttonControl.setEnabled(enabled);
            }
        }
    }
}

