/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.text.MessageFormat;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.AttributeContentProposalProviderFactory;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditorDialog;

public class DialogCellEditorEx
extends DialogCellEditor {
    protected Text text;
    protected String textValue = null;
    protected String startValue = null;
    private Button button;
    private static final int defaultStyle = 0;
    private boolean skipDeactivate = Boolean.FALSE;
    protected IValueChangeListener valueChangeListener;
    protected IValueProvider valueProvider;
    protected PropertyEditor propertyEditor;
    protected PropertyEditorDialog dialog;
    protected boolean externalEditing = false;
    int modifyLock = 0;
    boolean editable = true;
    protected CPL2 popup = new CPL2();
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private boolean isSelection = false;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put("cell_editor_dots_button_image", ImageDescriptor.createFromFile(DialogCellEditor.class, (String)"images/dots_button.gif"));
    }

    public DialogCellEditorEx() {
        this.setStyle(0);
    }

    public DialogCellEditorEx(Composite parent) {
        this(parent, 0);
    }

    public DialogCellEditorEx(Composite parent, int style) {
        super(parent, style);
    }

    protected Control getTextControl() {
        return this.text;
    }

    protected Button getButtonControl() {
        return this.button;
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DialogCellEditorEx.this.focusLost();
            }
        });
        result.setText("...");
        this.button = result;
        return this.button;
    }

    protected Control createControl(Composite parent) {
        return (Composite)super.createControl(parent);
    }

    protected void doSetValue(Object value) {
        super.doSetValue(value);
        super.fireEditorValueChanged(true, false);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        if (this.propertyEditor != null) {
            Object oldValue = ((IValueProvider)this.propertyEditor.getAdapter(IValueProvider.class)).getValue();
            DefaultValueAdapter a = (DefaultValueAdapter)this.propertyEditor.getInput();
            boolean auto = a.isAutoStore();
            a.setAutoStore(false);
            this.propertyEditor.setValue(this.getValue());
            if (this.propertyEditor.callsExternal()) {
                this.externalEditing = true;
                Object s = this.propertyEditor.callExternal(cellEditorWindow.getShell());
                if (s != null && s.equals(oldValue)) {
                    s = null;
                }
                if (s != null) {
                    this.propertyEditor.setValue(s);
                } else if (this.editable) {
                    this.text.forceFocus();
                }
                a.setAutoStore(auto);
                this.externalEditing = false;
                return s;
            }
            this.dialog = new PropertyEditorDialog(ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), this.propertyEditor);
            this.dialog.create();
            String title = MessageFormat.format("Edit {0}", WizardKeys.getAttributeDisplayName((XAttribute)a.getAttribute(), (boolean)true));
            this.dialog.getShell().setText(title);
            this.externalEditing = true;
            ExtendedFieldEditor fieldEditor = this.propertyEditor.getFieldEditor(null);
            int i = this.dialog.open();
            if (i != 0) {
                this.propertyEditor.setValue(oldValue);
                a.setAutoStore(auto);
                if (this.editable) {
                    this.text.forceFocus();
                }
                this.externalEditing = false;
                return null;
            }
            fieldEditor.store();
            a.setAutoStore(auto);
            this.externalEditing = false;
            return ((IValueProvider)this.propertyEditor.getAdapter(IValueProvider.class)).getValue();
        }
        return null;
    }

    public void setPropertyEditor(PropertyEditor editor) {
        this.propertyEditor = editor;
        if (editor != null) {
            this.addContentAssist(this.text);
        }
    }

    public void setValueProvider(IValueProvider valueProvider) {
        this.valueProvider = valueProvider;
        this.setValue(valueProvider.getValue());
    }

    public Control getControl() {
        StackTraceElement[] es = new Throwable().getStackTrace();
        if (es.length > 1 && es[1].getClassName().endsWith(".CellEditorActionHandler")) {
            return this.text;
        }
        return super.getControl();
    }

    protected Control createContents(Composite cell) {
        this.text = new Text(cell, 16384);
        this.text.setFont(cell.getFont());
        this.text.setBackground(cell.getBackground());
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((byte)e.character == 13) {
                    if (DialogCellEditorEx.this.popup.isPopupOpened) {
                        return;
                    }
                    DialogCellEditorEx.this.fireApplyEditorValue();
                    DialogCellEditorEx.this.fireCancelEditor();
                }
                DialogCellEditorEx.this.doChecks();
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    DialogCellEditorEx.this.text.setText(DialogCellEditorEx.this.startValue);
                    DialogCellEditorEx.this.fireCancelEditor();
                }
                DialogCellEditorEx.this.doChecks();
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DialogCellEditorEx.this.modifyLock > 0) {
                    return;
                }
                ++DialogCellEditorEx.this.modifyLock;
                DialogCellEditorEx.this.doSetValue(DialogCellEditorEx.this.textValue != null ? DialogCellEditorEx.this.textValue : DialogCellEditorEx.this.text.getText());
                --DialogCellEditorEx.this.modifyLock;
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DialogCellEditorEx.this.focusLost();
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                DialogCellEditorEx.this.doChecks();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                DialogCellEditorEx.this.doChecks();
            }
        });
        return this.text;
    }

    protected void focusLost() {
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl != null && (focusControl.equals(this.button) || focusControl.equals(this.text))) {
            return;
        }
        if (this.skipDeactivate) {
            return;
        }
        if (!this.externalEditing) {
            String v = this.textValue != null ? this.textValue : this.text.getText();
            ++this.modifyLock;
            super.doSetValue((Object)v);
            --this.modifyLock;
            super.focusLost();
        }
    }

    protected void updateContents(Object value) {
        if (this.modifyLock > 0) {
            return;
        }
        if (this.text == null) {
            return;
        }
        String txt = "";
        if (value != null) {
            txt = value.toString();
        }
        this.setTextEditable(txt.indexOf(10) < 0 && txt.indexOf(13) < 0);
        if (!this.editable) {
            this.textValue = txt;
            txt = txt.replace('\n', ' ').replace('\t', ' ').replace('\r', ' ');
        }
        ++this.modifyLock;
        this.text.setText(txt);
        super.doSetValue(value);
        --this.modifyLock;
        this.doSetFocus();
    }

    void setTextEditable(boolean b) {
        if (this.editable == b) {
            return;
        }
        this.editable = b;
        this.text.setEditable(b);
        int c = b ? 2 : 15;
        this.text.setForeground(Display.getDefault().getSystemColor(c));
    }

    protected void doSetFocus() {
        if (this.editable && !this.externalEditing) {
            this.text.forceFocus();
            this.text.setSelection(0, this.text.getText().length());
            this.doChecks();
        }
    }

    protected void fireApplyEditorValue() {
        super.fireApplyEditorValue();
        if (this.propertyEditor != null) {
            if (this.propertyEditor.getInput() instanceof DefaultValueAdapter && ((DefaultValueAdapter)this.propertyEditor.getInput()).isAutoStore()) {
                this.fireCancelEditor();
            }
        } else if (this.text != null && !this.text.isDisposed() && this.editable) {
            this.text.forceFocus();
        }
    }

    protected void addContentAssist(Text text) {
        if (this.propertyEditor != null && this.propertyEditor.getInput() instanceof DefaultValueAdapter) {
            DefaultValueAdapter valueAdapter = (DefaultValueAdapter)this.propertyEditor.getInput();
            AttributeContentProposalProviderFactory.registerContentAssist(valueAdapter, (Control)text, this.popup);
        }
    }

    protected void fireCancelEditor() {
        this.skipDeactivate = Boolean.TRUE;
        super.fireCancelEditor();
        this.skipDeactivate = Boolean.FALSE;
        this.deactivate();
    }

    public void activate() {
        super.activate();
        this.skipDeactivate = false;
        if (this.text != null) {
            this.startValue = this.text.getText();
        }
    }

    public void deactivate() {
        if (!this.skipDeactivate) {
            this.skipDeactivate = true;
            this.startValue = null;
            super.deactivate();
        }
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        return this.isCopyEnabled();
    }

    public boolean isDeleteEnabled() {
        return this.isCopyEnabled();
    }

    public boolean isPasteEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.doChecks();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int pos = this.text.getCaretPosition();
            if (pos < this.text.getCharCount()) {
                this.text.setSelection(pos, pos + 1);
                this.text.insert("");
            }
        }
        this.doChecks();
    }

    public void performPaste() {
        this.text.paste();
        this.doChecks();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getCharCount() > 0;
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    private void doChecks() {
        if (this.text != null && !this.text.isDisposed()) {
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    class CPL2
    implements IContentProposalListener2 {
        boolean isPopupOpened = false;

        CPL2() {
        }

        public void proposalPopupClosed(ContentProposalAdapter adapter) {
            this.isPopupOpened = false;
        }

        public void proposalPopupOpened(ContentProposalAdapter adapter) {
            this.isPopupOpened = true;
        }
    }
}

