/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultComboBoxValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ComboBoxCellEditorEx;
import org.jboss.tools.common.model.ui.attribute.editor.ComboBoxFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.SelectionEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class DropDownEditor
extends SelectionEditor {
    protected ComboBoxCellEditorEx cellEditor;
    protected ComboBoxFieldEditor fieldEditor;

    public DropDownEditor() {
    }

    public DropDownEditor(IWidgetSettings settings) {
        super(settings);
        this.lineEditor = true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.cellEditor != null) {
            this.cellEditor.dispose();
        }
        this.cellEditor = null;
        if (this.fieldEditor != null) {
            this.fieldEditor.dispose();
        }
        this.fieldEditor = null;
    }

    @Override
    protected CellEditor createCellEditor(Composite parent) {
        this.cellEditor = new ComboBoxCellEditorEx(parent, this.getTags(), 8);
        return this.cellEditor;
    }

    @Override
    protected ExtendedFieldEditor createFieldEditor(Composite parent) {
        this.fieldEditor = new ComboBoxFieldEditor(this.settings);
        this.fieldEditor.setDropDown(Boolean.TRUE);
        this.fieldEditor.setLabelText(this.getLabelText());
        this.fieldEditor.setPropertyEditor(this);
        return this.fieldEditor;
    }

    private String[] getTags() {
        IListContentProvider listContentProvider = (IListContentProvider)this.getAdapter(IListContentProvider.class);
        ILabelProvider labelProvider = (ILabelProvider)this.getAdapter(ILabelProvider.class);
        Object[] elements = listContentProvider.getElements(this);
        String[] tags = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            tags[i] = labelProvider.getText(elements[i]);
            ++i;
        }
        return tags;
    }

    @Override
    public Object getInput() {
        if (this.input == null) {
            this.setInput(new DefaultComboBoxValueAdapter());
        }
        return this.input;
    }
}

