/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditorDialog;
import org.jboss.tools.common.model.ui.navigator.LabelDecoratorImpl;
import org.jboss.tools.common.model.ui.widgets.DefaultSettings;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;
import org.jboss.tools.common.model.ui.widgets.xpl.SelectableFormLabel;
import org.jboss.tools.common.util.PlatformUtil;

public abstract class ExtendedFieldEditor
extends FieldEditor {
    public static final String LABEL_SELECTED = "Label.Selected";
    public static final String IS_VALID = "field_editor_is_valid";
    public static final String VALUE = "field_editor_value";
    protected static final int HORIZONTAL_GAP = 8;
    private IPreferenceStore preferenceStore = null;
    private boolean isDefaultPresented = false;
    private Label label;
    private IAction labelAction;
    private boolean selectableLabel;
    private boolean enabled = Boolean.TRUE;
    private IAttributeErrorProvider errorProvider;
    private PropertyEditorDialog ownerDialog;
    protected IWidgetSettings settings;
    protected Composite labelComposite;
    protected Label errorSymbolLabel;
    Color foreground = null;
    Image errorStateImage = null;

    public ExtendedFieldEditor() {
    }

    public ExtendedFieldEditor(IWidgetSettings settings) {
        this.settings = settings;
    }

    public void setOwnerDialog(PropertyEditorDialog dialog) {
        this.ownerDialog = dialog;
    }

    public PropertyEditorDialog getOwnerDialog() {
        return this.ownerDialog;
    }

    protected abstract void adjustForNumColumns(int var1);

    protected void applyFont() {
    }

    protected void checkParent(Control control, Composite parent) {
        Assert.isTrue((control.getParent() == parent ? 1 : 0) != 0, (String)"Different parents");
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    public Control getLabelComposite() {
        return this.labelComposite;
    }

    protected Label getLabelControl() {
        return this.label;
    }

    public Control getLabelComposite(Composite parent) {
        return this.createLabelComposite(parent);
    }

    public Label getLabelControl(Composite parent) {
        this.getLabelComposite(parent);
        return this.getLabelControl();
    }

    public Control createLabelComposite(Composite parent) {
        if (this.getLabelComposite() == null) {
            this.labelComposite = new Composite(parent, 0);
            if (this.settings instanceof WhiteSettings) {
                this.labelComposite.setBackground(Display.getDefault().getSystemColor(1));
            }
            this.labelComposite.setBackgroundMode(1);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 2;
            this.labelComposite.setLayout((Layout)layout);
            Color fg = this.getSettings().getColor("Label.Foreground");
            this.createLabelControl(this.labelComposite);
            this.errorSymbolLabel = new Label(this.labelComposite, 0);
            this.errorSymbolLabel.setImage(LabelDecoratorImpl.emptyImage);
            this.errorSymbolLabel.setForeground(fg);
            if (this.settings instanceof WhiteSettings) {
                this.errorSymbolLabel.setBackground(Display.getDefault().getSystemColor(1));
            }
        } else {
            this.checkParent((Control)this.labelComposite, parent);
        }
        return this.labelComposite;
    }

    Color getForeground() {
        if (this.foreground == null || this.foreground.isDisposed()) {
            this.foreground = new Color(null, 10, 36, 106);
        }
        return this.foreground;
    }

    protected Label createLabelControl(Composite parent) {
        if (this.label == null) {
            if (this.getLabelAction() != null) {
                int style = this.getSettings().getStyle("Hyperlink.Style");
                Color fg = this.getSettings().getColor("Hyperlink.Foreground");
                Color disabled = this.getSettings().getColor("Hyperlink.Disabled");
                Color activeColor = this.getSettings().getColor("Hyperlink.ActiveColor");
                Font font = this.getSettings().getFont("Hyperlink.Font");
                Cursor cursor = this.getSettings().getCursor("Hyperlink.ActiveCursor");
                if (style == -1) {
                    style = 0;
                }
                SelectableFormLabel selectableLabel = new SelectableFormLabel(parent, style);
                selectableLabel.setFont(font);
                selectableLabel.setActiveCursor(cursor);
                selectableLabel.setPassiveColor(fg);
                selectableLabel.setActiveColor(activeColor);
                selectableLabel.setActiveCursor(cursor);
                selectableLabel.setDisabledColor(disabled);
                boolean enabled = this.getLabelAction().isEnabled() && this.isEnabled();
                selectableLabel.setEnabled(enabled);
                selectableLabel.setToolTipText(enabled ? this.getHyperlinkLableToolTip() : null);
                this.label = selectableLabel;
                selectableLabel.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (ExtendedFieldEditor.this.labelAction != null) {
                            ExtendedFieldEditor.this.labelAction.run();
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.getLabelAction().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if ("enabled".equals(event.getProperty())) {
                            boolean enabled = ExtendedFieldEditor.this.getLabelAction().isEnabled();
                            ((SelectableFormLabel)ExtendedFieldEditor.this.label).setEnabled(enabled);
                            ExtendedFieldEditor.this.label.setToolTipText(enabled ? ExtendedFieldEditor.this.getHyperlinkLableToolTip() : null);
                            ((SelectableFormLabel)ExtendedFieldEditor.this.label).redraw();
                        }
                    }
                });
            } else {
                int style = this.getSettings().getStyle("Label.Style");
                if (style == -1) {
                    style = 0;
                }
                Color fg = this.getSettings().getColor("Label.Foreground");
                Font font = this.getSettings().getFont("Label.Font");
                this.label = new Label(parent, style);
                this.label.setFont(font);
                this.label.setForeground(fg);
                this.label.setEnabled(this.isEnabled());
            }
            String text = this.getLabelText();
            if (text != null) {
                this.label.setText(text);
            }
            this.label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ExtendedFieldEditor.this.label = null;
                }
            });
            if (this.settings instanceof WhiteSettings && !PlatformUtil.isGTK3()) {
                this.label.setBackground(Display.getDefault().getSystemColor(1));
            }
        } else {
            this.checkParent((Control)this.label, parent);
        }
        return this.label;
    }

    public IAction getLabelAction() {
        return this.labelAction;
    }

    public void setLabelAction(IAction action) {
        this.labelAction = action;
        this.setSelectableLabel(this.labelAction != null);
    }

    protected String getHyperlinkLableToolTip() {
        return null;
    }

    public boolean isSelectableLabel() {
        return this.selectableLabel;
    }

    public void setSelectableLabel(boolean b) {
        this.selectableLabel = b;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void dispose() {
        if (this.label != null && !this.label.isDisposed()) {
            this.label.dispose();
        }
        this.setPropertyChangeListener(null);
        this.label = null;
        this.setPropertyChangeListener(null);
        this.setPage(null);
        if (this.foreground != null && !this.foreground.isDisposed()) {
            this.foreground.dispose();
            this.foreground = null;
        }
    }

    public void load() {
        if (this.preferenceStore != null) {
            this.isDefaultPresented = false;
            this.doLoad();
            this.refreshValidState();
        }
    }

    public void loadDefault() {
        if (this.preferenceStore != null) {
            this.isDefaultPresented = true;
            this.doLoadDefault();
            this.refreshValidState();
        }
    }

    public boolean presentsDefaultValue() {
        return this.isDefaultPresented;
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        if (this.getLabelControl() != null) {
            this.getLabelControl().setText(text);
        }
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.preferenceStore = store;
    }

    protected void setPresentsDefaultValue(boolean b) {
        this.isDefaultPresented = b;
    }

    public void setErrorProvider(IAttributeErrorProvider errorProvider) {
        this.errorProvider = errorProvider;
        if (this instanceof PropertyChangeListener && errorProvider != null) {
            errorProvider.addErrorStateListener((PropertyChangeListener)((Object)this));
        }
    }

    public IAttributeErrorProvider getErrorProvider() {
        return this.errorProvider;
    }

    public void store() {
        if (this.preferenceStore == null) {
            return;
        }
        if (this.isDefaultPresented) {
            this.preferenceStore.setToDefault(this.getPreferenceName());
        } else {
            this.doStore();
        }
    }

    protected void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)14);
        int widthHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.setEnabled(enabled);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.label != null && !this.label.isDisposed()) {
            if (this.getLabelAction() != null) {
                this.label.setEnabled(this.getLabelAction().isEnabled() && enabled);
            } else {
                this.label.setEnabled(enabled);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public IWidgetSettings getSettings() {
        if (this.settings == null) {
            this.settings = DefaultSettings.getDefault();
        }
        return this.settings;
    }

    public void setSettings(IWidgetSettings settings) {
        this.settings = settings;
    }

    public abstract void cut();

    public abstract void copy();

    public abstract void paste();

    public abstract void delete();

    protected void updateErrorState() {
        if (this.getErrorProvider() != null && this.errorSymbolLabel != null && !this.errorSymbolLabel.isDisposed()) {
            boolean error = this.getErrorProvider().hasErrors();
            Image image = null;
            String tooltip = null;
            if (error) {
                image = LabelDecoratorImpl.errorImage;
                tooltip = this.getErrorProvider().getError();
            } else {
                image = LabelDecoratorImpl.emptyImage;
            }
            if (this.errorStateImage != image || image != null && this.errorSymbolLabel != null && tooltip != null && !tooltip.equals(this.errorSymbolLabel.getToolTipText())) {
                this.errorStateImage = image;
                this.errorSymbolLabel.setImage(this.errorStateImage);
                this.errorSymbolLabel.setToolTipText(tooltip);
            }
        }
    }

    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        if ("IPropertyEditor.error".equals(evt.getPropertyName())) {
            this.updateErrorState();
        }
    }
}

