/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.templates.configuration.MetaClassTemplateHelper;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

class JavaAdapter {
    private String superClass;
    private String[] interfacees;
    private IJavaProject javaProject;
    private IJavaElement javaElement;
    private IPackageFragmentRoot packageFragmentRoot;
    private String className;
    private String packageName;
    private static JavaAdapter INSTANCE;
    long lastTimeChange = 0L;

    private JavaAdapter() {
        JavaCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                JavaAdapter.this.lastTimeChange = System.currentTimeMillis();
            }
        });
    }

    public static JavaAdapter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JavaAdapter();
        }
        return INSTANCE;
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            this.javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError("Cannot find Java Project Nature.", (Throwable)e);
            return null;
        }
        IResource r = EclipseResourceUtil.getJavaSourceRoot((IProject)project);
        if (r == null || !r.exists()) {
            r = project;
        }
        this.packageFragmentRoot = this.javaProject == null ? null : this.javaProject.getPackageFragmentRoot(r);
        return this.packageFragmentRoot;
    }

    public void init(IProject project, String publicId, String xPath, String name) {
        if (publicId != null) {
            this.superClass = MetaClassTemplateHelper.instance.getSuperClassName(project, publicId, xPath);
            this.interfacees = MetaClassTemplateHelper.instance.getInterfacesName(project, publicId, xPath);
        }
        if (project == null) {
            return;
        }
        this.packageName = null;
        String fullClassName = null;
        if (name == null) {
            name = "";
        }
        fullClassName = String.valueOf(name.replace('.', '/')) + ".java";
        if (name.lastIndexOf(46) > 0) {
            this.className = name.substring(name.lastIndexOf(46) + 1);
            this.packageName = name.substring(0, name.lastIndexOf(46));
        } else {
            this.className = name;
            this.packageName = "";
        }
        try {
            this.javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            ModelUIPlugin.getPluginLog().logError("Cannot find Java Project Nature.", (Throwable)new Exception());
            return;
        }
        this.packageFragmentRoot = this.javaProject == null ? null : this.javaProject.getPackageFragmentRoot(this.javaProject.getResource());
        try {
            if (this.javaProject == null) {
                this.javaElement = null;
            } else {
                this.javaElement = this.javaProject.findElement((IPath)new Path(fullClassName));
                if (this.javaElement == null) {
                    this.javaElement = this.javaProject.findType(name);
                }
                if (this.javaElement == null) {
                    this.javaElement = this.javaProject.findType(name, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (JavaModelException javaModelException) {
            this.javaElement = null;
        }
    }

    public String getSuperClass() {
        if (this.superClass == null || this.superClass.length() == 0) {
            this.superClass = "java.lang.Object";
        }
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public String[] getInterfacees() {
        return this.interfacees;
    }

    public void setInterfacees(String[] interfacees) {
        this.interfacees = interfacees;
    }

    public IJavaElement getJavaElement() {
        return this.javaElement;
    }

    public void setJavaElement(IJavaElement javaElement) {
        this.javaElement = javaElement;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.packageFragmentRoot;
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
        this.packageFragmentRoot = packageFragmentRoot;
    }
}

