/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.IValueFilter;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.JavaHyperlinkCellEditor;
import org.jboss.tools.common.model.ui.attribute.editor.JavaHyperlinkLineFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.ValueEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class JavaEclipseChoicerEditor
extends ValueEditor {
    protected JavaHyperlinkCellEditor cellEditor;
    protected JavaHyperlinkLineFieldEditor fieldEditor;

    public JavaEclipseChoicerEditor() {
    }

    public JavaEclipseChoicerEditor(IWidgetSettings settings) {
        super(settings);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.cellEditor != null) {
            this.cellEditor.dispose();
        }
        this.cellEditor = null;
        if (this.fieldEditor != null) {
            this.fieldEditor.dispose();
        }
        this.fieldEditor = null;
    }

    @Override
    public boolean isGreedyEditor() {
        return false;
    }

    @Override
    protected CellEditor createCellEditor(Composite parent) {
        this.cellEditor = new JavaHyperlinkCellEditor(parent, 0);
        this.cellEditor.setPropertyEditor(this);
        return this.cellEditor;
    }

    @Override
    protected ExtendedFieldEditor createFieldEditor(Composite parent) {
        this.fieldEditor = new JavaHyperlinkLineFieldEditor(this.settings);
        return this.fieldEditor;
    }

    @Override
    public String getChangeButtonName() {
        return JFaceResources.getString((String)"openBrowse");
    }

    @Override
    public boolean callsExternal() {
        return true;
    }

    @Override
    public Object callExternal(Shell shell) {
        Object result;
        IProject p;
        IJavaProject jp = null;
        DefaultValueAdapter adapter = (DefaultValueAdapter)this.getInput();
        XModelObject o = adapter.getModelObject();
        if (o != null && (p = EclipseResourceUtil.getProject((XModelObject)o)) != null) {
            jp = EclipseResourceUtil.getJavaProject((IProject)p);
        }
        String title = MessageFormat.format("Select {0}", this.getAttributeName());
        if (adapter != null && adapter.getAttribute() != null) {
            String key = adapter.getAttribute().getModelEntity().getName() + "." + adapter.getAttribute().getName().replace(' ', '_') + ".edit";
            String t = WizardKeys.getLabelText((String)key);
            title = t != null ? t : MessageFormat.format("Select {0}", WizardKeys.getAttributeDisplayName((XAttribute)adapter.getAttribute(), (boolean)true));
        }
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(shell, false, (IRunnableContext)ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow(), jp == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{jp}), 0, this.createTypeSelectionExtension());
        dialog.setTitle(title);
        IValueProvider valueProvider = (IValueProvider)adapter.getAdapter(IValueProvider.class);
        String v = valueProvider.getStringValue(true);
        dialog.setInitialPattern(v);
        int status = dialog.open();
        if (status == 0 && (result = dialog.getFirstResult()) instanceof IType) {
            return ((IType)result).getFullyQualifiedName('.');
        }
        return null;
    }

    TypeSelectionExtension createTypeSelectionExtension() {
        final ITypeInfoFilterExtension filter = this.createFilterExtension();
        if (filter == null) {
            return null;
        }
        return new TypeSelectionExtension(){

            public ITypeInfoFilterExtension getFilterExtension() {
                return filter;
            }
        };
    }

    ITypeInfoFilterExtension createFilterExtension() {
        IValueFilter filter;
        if (this.getInput() instanceof IAdaptable && (filter = (IValueFilter)((IAdaptable)this.getInput()).getAdapter(IValueFilter.class)) != null) {
            return new FilterExtension(filter);
        }
        return null;
    }

    class FilterExtension
    implements ITypeInfoFilterExtension {
        IValueFilter filter;

        public FilterExtension(IValueFilter filter) {
            this.filter = filter;
        }

        public boolean select(ITypeInfoRequestor typeInfoRequestor) {
            String pkg = typeInfoRequestor.getPackageName();
            String cls = typeInfoRequestor.getTypeName();
            String q = pkg == null || pkg.length() == 0 ? cls : String.valueOf(pkg) + "." + cls;
            return this.filter.accept(q);
        }
    }
}

