/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.StringEditor;
import org.jboss.tools.common.model.ui.widgets.DefaultSettings;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.util.extension.ExtensionPointUtil;

public class PropertyEditorFactory {
    public static final String ATTRIBUTE_EDITOR_EXT_POINT = "org.jboss.tools.common.model.ui.attributeEditor";
    private static Map<String, Class<?>> classes = new HashMap();
    static Set<String> defaultEditorIds = new HashSet<String>();

    public static PropertyEditor createPropertyEditor(Object adapter, XAttribute attribute, XModelObject modelObject) {
        return PropertyEditorFactory.createPropertyEditor(adapter, attribute, attribute.isRequired());
    }

    public static PropertyEditor createPropertyEditor(Object adapter, XAttribute attribute, XAttributeData attributeData) {
        return PropertyEditorFactory.createPropertyEditor(adapter, attribute, attributeData.getMandatoryFlag());
    }

    private static PropertyEditor createPropertyEditor(Object adapter, XAttribute attribute, boolean required) {
        return PropertyEditorFactory.createPropertyEditor(adapter, attribute, required, DefaultSettings.getDefault());
    }

    public static PropertyEditor createPropertyEditor(Object adapter, XAttribute attribute, XModelObject modelObject, IWidgetSettings settings) {
        return PropertyEditorFactory.createPropertyEditor(adapter, attribute, attribute.isRequired(), settings);
    }

    public static PropertyEditor createPropertyEditor(Object adapter, XAttribute attribute, XAttributeData attributeData, IWidgetSettings settings) {
        return PropertyEditorFactory.createPropertyEditor(adapter, attribute, attributeData.getMandatoryFlag(), settings);
    }

    private static PropertyEditor createPropertyEditor(Object adapter, XAttribute attribute, boolean required, IWidgetSettings settings) {
        PropertyEditor propertyEditor = null;
        try {
            propertyEditor = (PropertyEditor)PropertyEditorFactory.getEditorClass(attribute).newInstance();
            propertyEditor.setSettings(settings);
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InstantiationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        if (propertyEditor == null) {
            propertyEditor = new StringEditor(settings);
        }
        String labelText = WizardKeys.getAttributeDisplayName((XAttribute)attribute, (boolean)true);
        String editorName = attribute.getEditor().getName();
        if (!"CheckBox".equals(editorName) && !"ListRadio".equals(editorName)) {
            labelText = String.valueOf(labelText) + ":";
        }
        if (required) {
            labelText = String.valueOf(labelText) + "*";
        }
        propertyEditor.setLabelText(labelText);
        propertyEditor.setInput(adapter);
        return propertyEditor;
    }

    private static Class<?> getEditorClass(XAttribute attribute) {
        return PropertyEditorFactory.getEditorClass(attribute.getEditor().getName());
    }

    private static Class<?> getEditorClass(String id) {
        Class<Object> c;
        block3: {
            c = classes.get(id);
            if (c != null) {
                return c;
            }
            c = StringEditor.class;
            try {
                c = ExtensionPointUtil.findClassByElementId((String)ATTRIBUTE_EDITOR_EXT_POINT, (String)id).getClass();
            }
            catch (CoreException coreException) {
                if (defaultEditorIds.contains(id)) break block3;
                defaultEditorIds.add(id);
                ModelUIPlugin.getPluginLog().logInfo("PropertyEditorFactory: Default editor used for " + id);
            }
        }
        classes.put(id, c);
        return c;
    }
}

