/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class TreeSelectionFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
ISelectionChangedListener {
    protected TreeViewer treeViewer;
    protected int style = -1;
    protected IPropertyEditor propertyEditor;
    protected ILabelProvider labelProvider;
    protected ITreeContentProvider treeContentProvider;
    protected ISelectionChangedListener selectionChangedListener;
    protected ISelectionProvider selectionProvider;

    public TreeSelectionFieldEditor() {
    }

    public TreeSelectionFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = numColumns;
        Control tree = this.createTreeControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = numColumns;
        tree.setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected Control getTreeControl() {
        if (this.treeViewer != null) {
            return this.treeViewer.getControl();
        }
        return null;
    }

    protected Control createTreeControl(Composite parent) {
        if (this.treeViewer == null) {
            this.treeViewer = new TreeViewer(parent, this.getStyle());
            this.treeViewer.setAutoExpandLevel(2);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
            this.treeViewer.setInput((Object)this);
            if (this.selectionProvider != null) {
                this.treeViewer.setSelection(this.selectionProvider.getSelection(), true);
                this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (this.selectionChangedListener != null) {
                this.treeViewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (TreeSelectionFieldEditor.this.getOwnerDialog() != null) {
                        TreeSelectionFieldEditor.this.getOwnerDialog().okPressed();
                    }
                }
            });
        }
        return this.treeViewer.getTree();
    }

    public int getStyle() {
        if (this.style != -1) {
            return this.style;
        }
        return this.getSettings().getStyle("Table.Style");
    }

    public void setStyle(int i) {
        this.style = i;
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.labelProvider = (ILabelProvider)propertyEditor.getAdapter(ILabelProvider.class);
            this.treeContentProvider = (ITreeContentProvider)propertyEditor.getAdapter(ITreeContentProvider.class);
            this.selectionChangedListener = (ISelectionChangedListener)propertyEditor.getAdapter(ISelectionChangedListener.class);
            this.selectionProvider = (ISelectionProvider)propertyEditor.getAdapter(ISelectionProvider.class);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(event.getSelection());
        }
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.createTreeControl(parent)};
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getTreeControl() != null) {
            this.getTreeControl().setEnabled(enabled);
        }
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    @Override
    public void paste() {
    }

    @Override
    public void delete() {
    }
}

