/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.resources.ResourceLayoutManager;
import org.jboss.tools.common.model.ui.texteditors.TextActionHelper;

public class DefaultEditorPart
extends EditorPart
implements ITextEditor,
ITextOperationTarget {
    private Map<String, IAction> actions = new HashMap<String, IAction>();
    private ArrayList<String> actionMapping = new ArrayList();

    public IDocumentProvider getDocumentProvider() {
        return null;
    }

    public void close(boolean save) {
        this.store();
    }

    public boolean isEditable() {
        return false;
    }

    public void doRevertToSaved() {
    }

    public void setAction(String actionID, IAction action) {
        this.actions.put(actionID, action);
    }

    public IAction getAction(String id) {
        return this.actions.get(id);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
    }

    public void removeActionActivationCode(String actionId) {
    }

    public boolean showsHighlightRangeOnly() {
        return false;
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
    }

    public IRegion getHighlightRange() {
        return null;
    }

    public void resetHighlightRange() {
    }

    public void selectAndReveal(int offset, int length) {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        boolean cfr_ignored_0 = input instanceof IFileEditorInput;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createControl(parent);
        this.createActions();
    }

    protected Control createControl(Composite parent) {
        return null;
    }

    public Image getTitleImage() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public void setFocus() {
    }

    public Object getAdapter(Class adapter) {
        if (ITextOperationTarget.class.equals((Object)adapter)) {
            return this;
        }
        return null;
    }

    private IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    private void store() {
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        ResourceLayoutManager.getDefault().store((IResource)file);
    }

    public void doSave(IProgressMonitor monitor) {
        this.store();
    }

    public void doSaveAs() {
        this.store();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public boolean canDoOperation(int operation) {
        Collection<IAction> actions = this.actions.values();
        for (IAction action : actions) {
            if (!action.isEnabled()) continue;
            return true;
        }
        return true;
    }

    public void doOperation(int operation) {
        if (operation > this.actionMapping.size()) {
            ModelUIPlugin.getPluginLog().logError((Throwable)new IllegalArgumentException("Can not find global action with index: " + operation));
        } else {
            String globalAction = this.actionMapping.get(operation);
            this.doGlobalAction(globalAction);
        }
    }

    protected void createActions() {
        this.actionMapping.add(null);
        this.actionMapping.add(1, ActionFactory.UNDO.getId());
        this.actionMapping.add(2, ActionFactory.REDO.getId());
        this.actionMapping.add(3, ActionFactory.CUT.getId());
        this.actionMapping.add(4, ActionFactory.COPY.getId());
        this.actionMapping.add(5, ActionFactory.PASTE.getId());
        this.actionMapping.add(6, ActionFactory.DELETE.getId());
        this.actionMapping.add(7, ActionFactory.SELECT_ALL.getId());
        this.actionMapping.add(8, "ShiftRight");
        this.actionMapping.add(9, "ShiftLeft");
        this.actionMapping.add(10, ActionFactory.PRINT.getId());
        TextActionHelper.addCutAction(this);
        TextActionHelper.addCopyAction(this);
        TextActionHelper.addPasteAction(this);
        TextActionHelper.addDeleteAction(this);
    }

    public void doGlobalAction(String action) {
    }

    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    public void dispose() {
    }
}

