/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.XModelBuffer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.common.model.ui.editors.dnd.DefaultDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.DropUtils;
import org.jboss.tools.common.model.ui.editors.dnd.IAttributeValueLoader;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.web.WebUtils;

public class AbsoluteFilePathAttributeValueLoader
implements IAttributeValueLoader {
    String fPathAttributeName;
    String fWidthAttributeName;
    String fHeightAttributeName;

    public AbsoluteFilePathAttributeValueLoader(String pathAttributeName, String widthAttributeName, String heightAttributeName) {
        this.fPathAttributeName = pathAttributeName;
        this.fWidthAttributeName = widthAttributeName;
        this.fHeightAttributeName = heightAttributeName;
    }

    @Override
    public void fillTagAttributes(IDropWizardModel model) {
        String v;
        IFile file = DropUtils.getResourceForMimeData(model.getDropData());
        if (file == null) {
            return;
        }
        IEditorInput editorInput = model.getDropData().getEditorInput();
        IFile context = null;
        if (editorInput instanceof IFileEditorInput) {
            context = ((IFileEditorInput)editorInput).getFile();
        }
        String string = v = context == null ? null : this.dropFileToFile(file, context, model);
        if (v == null) {
            v = this.getPath(context, file);
        }
        model.setAttributeValue(this.fPathAttributeName, (Object)v);
        if (model instanceof DefaultDropWizardModel) {
            ((DefaultDropWizardModel)model).setPreferable(this.fPathAttributeName);
        }
    }

    protected String getPath(IFile context, IFile resource) {
        return WebUtils.getWebPath(null, (IFile)resource);
    }

    private String dropFileToFile(IFile source, IFile target, IDropWizardModel model) {
        XModelObject t = EclipseResourceUtil.getObjectByResource((IResource)target);
        XModelObject s = EclipseResourceUtil.getObjectByResource((IResource)source);
        if (t == null || s == null) {
            return null;
        }
        XModelBuffer b = s.getModel().getModelBuffer();
        XModelObject c = b.source();
        b.clear();
        b.addSource(s);
        try {
            if (!DnDUtil.isPasteEnabled(t)) {
                return null;
            }
            Properties p = new Properties();
            String tagName = model.getTagProposal().getName();
            p.setProperty("isDrop", "true");
            if (tagName != null) {
                p.setProperty("context:tagName", tagName);
            }
            DnDUtil.paste(t, p);
            String string = p.getProperty("start text");
            return string;
        }
        catch (XModelException xModelException) {
            return null;
        }
        finally {
            b.clear();
            if (c != null) {
                b.addSource(c);
            }
        }
    }
}

