/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editors.dnd.DefaultDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.DropCommandFactory;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.DropWizard;
import org.jboss.tools.common.model.ui.editors.dnd.DropWizardDialog;
import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizard;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardExtension;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposal;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposalFactory;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagProposalsComposite;

public abstract class DefaultDropCommand
implements IDropCommand {
    protected ITagProposalFactory tagProposalFactory;
    private IDropWizardModel fDropWizardDataModel = null;

    @Override
    public void setTagProposalFactory(ITagProposalFactory tagProposalFactory) {
        this.tagProposalFactory = tagProposalFactory;
    }

    @Override
    public ITagProposalFactory getTagProposalFactory() {
        return this.tagProposalFactory;
    }

    protected IDropWizardModel createSpecificModel() {
        DefaultDropWizardModel newModel = new DefaultDropWizardModel(this.tagProposalFactory);
        return newModel;
    }

    @Override
    public IDropWizardModel getDefaultModel() {
        if (this.fDropWizardDataModel == null) {
            this.fDropWizardDataModel = this.createSpecificModel();
        }
        return this.fDropWizardDataModel;
    }

    @Override
    public void initialize() {
        if (this.getDefaultModel().getDropData() == null) {
            throw new IllegalStateException("Wizard model isn't intialized, call setDropDataFirst");
        }
        ITagProposal[] proposals = TagProposalsComposite.getTagProposals(this.getDefaultModel().getDropData().getMimeType(), this.getDefaultModel().getDropData(), this.tagProposalFactory);
        if (proposals.length == 1) {
            this.getDefaultModel().setTagProposal(proposals[0]);
        }
    }

    protected boolean doNotShowDialog() {
        return XModelTransferBuffer.getInstance().isEnabled() && XModelTransferBuffer.getInstance().isCtrlPressed();
    }

    @Override
    public void execute(DropData data) {
        Shell[] existedShells = PlatformUI.getWorkbench().getDisplay().getShells();
        boolean dialogWasAlreadyOpened = false;
        Shell[] shellArray = existedShells;
        int n = existedShells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell sh = shellArray[n2];
            if (DropWizardMessages.Wizard_Window_Title.equalsIgnoreCase(sh.getText())) {
                dialogWasAlreadyOpened = true;
            }
            ++n2;
        }
        if (!dialogWasAlreadyOpened) {
            this.getDefaultModel().setDropData(data);
            this.initialize();
            if (this.getDefaultModel().isWizardRequired() || this.getCustomWizardName() != null) {
                DropWizardDialog dialog;
                IDropWizard wizard = this.createDropWizard();
                boolean doNotShowDialog = this.doNotShowDialog();
                boolean runWithoutDialog = doNotShowDialog && wizard instanceof IDropWizardExtension;
                DropWizardDialog dropWizardDialog = dialog = runWithoutDialog ? null : new DropWizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), wizard);
                if (runWithoutDialog) {
                    ((IDropWizardExtension)((Object)wizard)).initWithoutUI();
                    wizard.performFinish();
                } else {
                    if ("true".equals(System.getProperty("org.jboss.tools.common.test"))) {
                        dialog.setBlockOnOpen(false);
                        dialog.open();
                        return;
                    }
                    if (doNotShowDialog && wizard.canFinish()) {
                        try {
                            dialog.create();
                            wizard.performFinish();
                        }
                        finally {
                            dialog.close();
                        }
                    } else {
                        dialog.open();
                    }
                }
            } else {
                this.execute();
            }
            this.getDefaultModel().setDropData(null);
        }
    }

    protected String getCustomWizardName() {
        return null;
    }

    protected IDropWizard createDropWizard() {
        DropWizard wizard = new DropWizard();
        wizard.setCommand(this);
        return wizard;
    }

    @Override
    public void execute() {
        if (this.getDefaultModel().getDropData() == null) {
            throw new IllegalStateException("Call setDndData() first");
        }
        if (this.getDefaultModel().getTagProposal() != IDropWizardModel.UNDEFINED_TAG_PROPOSAL) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            try {
                workspace.run((IWorkspaceRunnable)this, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        } else {
            this.executeUnknownTag();
        }
    }

    protected void executeUnknownTag() {
        DropCommandFactory.getInstance().getDropCommand("exadel/unknown", this.tagProposalFactory).execute(this.getDefaultModel().getDropData());
    }
}

