/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.DropUtils;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposal;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagAttributesComposite;

public class DefaultElementGenerator
implements IElementGenerator {
    IDropWizardModel fDataModel;
    protected String generatedEndTag = "";

    @Override
    public void setDataModel(Object object) {
        if (object instanceof IDropWizardModel) {
            this.fDataModel = (IDropWizardModel)object;
            return;
        }
        throw new IllegalArgumentException("Object parameter must be instance of " + this.getClass().getName());
    }

    public IDropWizardModel getWizardDataModel() {
        return this.fDataModel;
    }

    public DropData getDropData() {
        return this.fDataModel.getDropData();
    }

    protected void generateChildren(IElementGenerator.ElementNode node) {
    }

    protected IElementGenerator.ElementNode generateRoot() {
        IElementGenerator.ElementNode root = IElementGenerator.RootNode.newRoot();
        this.generateNode(root);
        return root;
    }

    protected void generateNode(IElementGenerator.ElementNode root) {
        String tagName;
        ITagProposal proposal = this.getWizardDataModel().getTagProposal();
        DropUtils.AttributeDescriptorValueProvider valueProvider = this.getWizardDataModel().getDropData().getValueProvider();
        if (valueProvider != null) {
            valueProvider.setProposal(proposal);
        }
        String string = tagName = valueProvider == null ? null : valueProvider.getTag();
        if (tagName != null) {
            String fullName = tagName;
            if (tagName.indexOf(58) < 0) {
                fullName = fullName.toLowerCase();
            }
            fullName = this.applayTagPreferences(fullName);
            IElementGenerator.ElementNode node = root.addChild(fullName);
            TagAttributesComposite.AttributeDescriptorValue[] values = this.getWizardDataModel().getAttributeValueDescriptors();
            int i = 0;
            while (i < values.length) {
                Object value = values[i].getValue();
                if (value != null && !"".equals(value.toString().trim())) {
                    node.addAttribute(this.applayAttributePreferences(values[i].getName()), value.toString());
                }
                ++i;
            }
            this.generateChildren(node);
            if (valueProvider.canHaveBody()) {
                node.getChildren().add(SEPARATOR);
                node.empty = false;
            }
        } else {
            String prefix = this.getWizardDataModel().getTagProposal().getPrefix();
            String name = this.getWizardDataModel().getTagProposal().getName();
            if (prefix != null && prefix.length() > 0) {
                name = String.valueOf(prefix) + ":" + name;
            }
            root.addChild(name);
        }
    }

    @Override
    public String generateStartTag() {
        this.generatedEndTag = "";
        IElementGenerator.ElementNode root = this.generateRoot();
        IElementGenerator.NodeWriter w = new IElementGenerator.NodeWriter(true);
        root.flush(w, 0);
        String[] result = w.getResult();
        String startText = result[0];
        this.generatedEndTag = result.length < 2 ? "" : (result.length == 3 ? String.valueOf(result[1]) + "\n" + result[2] : result[1]);
        return startText;
    }

    @Override
    public String generateEndTag() {
        return this.generatedEndTag;
    }

    protected String applayAttributePreferences(String attribute) {
        return attribute;
    }

    protected String applayTagPreferences(String tagName) {
        return tagName;
    }
}

