/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

public class FreeCaretStyledText
extends StyledText
implements PaintListener {
    int fX = -1;
    int fY = -1;
    boolean fEnabled = false;

    public FreeCaretStyledText(Composite parent, int style) {
        super(parent, style);
        super.addPaintListener((PaintListener)this);
    }

    public void dispose() {
        super.removePaintListener((PaintListener)this);
    }

    public void enableFreeCaret(boolean set) {
        this.fEnabled = set;
        if (!set) {
            this.redraw();
        }
    }

    public void myRedraw(int x, int y) {
        this.fX = x;
        this.fY = y;
        if (this.fEnabled) {
            this.redraw();
        }
    }

    public void paintControl(PaintEvent e) {
        if (!this.fEnabled) {
            return;
        }
        if (this.fX == -1 || this.fY == -1) {
            return;
        }
        GC gc = e.gc;
        gc.setForeground(gc.getBackground());
        int lh = this.getLineHeight();
        if (lh <= 0) {
            lh = 3;
        }
        gc.setXORMode(true);
        gc.setLineStyle(3);
        int i = 0;
        while (i < lh) {
            gc.drawLine(this.fX, this.fY + i, this.fX, this.fY + i);
            i += 2;
        }
    }
}

