/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public interface IElementGenerator {
    public static final ElementNode SEPARATOR = new ElementNode(null, true){

        @Override
        public void flush(NodeWriter writer, int indent) {
            writer.next();
        }
    };

    public void setDataModel(Object var1);

    public String generateStartTag();

    public String generateEndTag();

    public static class AttributeNode
    extends NamedNode {
        String value;

        public AttributeNode(String name, String value) {
            this.name = name;
            this.value = AttributeNode.escapeHtml(value, true);
        }

        public void flush(NodeWriter sb) {
            sb.append(" ").append(this.name).append("=\"").append(this.value).append("\"");
        }
    }

    public static class CommentNode
    extends NamedNode {
        public CommentNode(String text) {
            this.name = text;
        }

        @Override
        public void flush(NodeWriter sb, int indent) {
            if (indent >= 0) {
                sb.appendIndent(indent);
            }
            sb.append("<!-- ").append(this.name).append(" -->");
            if (indent >= 0) {
                sb.append("\n");
            }
        }
    }

    public static class ElementNode
    extends NamedNode {
        List<AttributeNode> attributes = new ArrayList<AttributeNode>();
        List<NamedNode> children = new ArrayList<NamedNode>();
        boolean empty;
        String text = null;

        public ElementNode(String name, boolean empty) {
            this.name = name;
            this.empty = empty;
        }

        public ElementNode(String name, String text) {
            this.name = name;
            this.text = text == null ? null : ElementNode.escapeHtml(text, false);
            this.empty = text == null;
        }

        public void addAttribute(String name, String value) {
            this.attributes.add(new AttributeNode(name, value));
        }

        public ElementNode addChild(String name) {
            ElementNode c = new ElementNode(name, true);
            this.children.add(c);
            this.empty = false;
            return c;
        }

        public CommentNode addComment(String text) {
            CommentNode c = new CommentNode(text);
            this.children.add(c);
            this.empty = false;
            return c;
        }

        public void addTextChild(String text) {
            TextNode c = new TextNode(text);
            this.children.add(c);
            this.empty = false;
        }

        public ElementNode addChild(String name, String text) {
            ElementNode c = new ElementNode(name, text);
            this.children.add(c);
            this.empty = false;
            return c;
        }

        public List<NamedNode> getChildren() {
            return this.children;
        }

        @Override
        public void flush(NodeWriter sb, int indent) {
            if (indent >= 0) {
                sb.appendIndent(indent);
            }
            sb.append("<").append(this.name);
            for (AttributeNode a : this.attributes) {
                a.flush(sb);
            }
            if (this.empty) {
                sb.append("/>");
            } else if (this.text != null) {
                sb.append(">");
                for (NamedNode c : this.children) {
                    c.flush(sb, -1);
                }
                sb.append(this.text).append("</").append(this.name).append(">");
            } else {
                sb.append(">").append("\n");
                for (NamedNode c : this.children) {
                    c.flush(sb, indent + 1);
                }
                sb.appendIndent(indent);
                sb.append("</").append(this.name).append(">");
            }
            if (indent >= 0) {
                sb.append("\n");
            }
        }
    }

    public static class NamedNode {
        protected String name;

        public static String escapeHtml(String text, boolean isAttribute) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                if (ch == '<') {
                    sb.append("&lt;");
                } else if (ch == '>') {
                    sb.append("&gt;");
                } else if (ch == '&' && !NamedNode.isEscapedSequence(text, i)) {
                    sb.append("&amp;");
                } else if (isAttribute && ch == '\"') {
                    sb.append("&quot;");
                } else {
                    sb.append(ch);
                }
                ++i;
            }
            return sb.toString();
        }

        static boolean isEscapedSequence(String text, int p) {
            if (text.charAt(p) != '&') {
                return false;
            }
            int i = p + 1;
            while (i < text.length()) {
                char ch = text.charAt(i);
                if (ch == '&') {
                    return false;
                }
                if (ch == ';') {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void flush(NodeWriter sb, int indent) {
        }
    }

    public static class NodeWriter {
        static final String ECLIPSE_EDITORS_PLUGIN = "org.eclipse.ui.editors";
        List<StringBuilder> builders = new ArrayList<StringBuilder>();
        StringBuilder current = null;
        boolean separate = true;
        String indentUnit = "\t";

        public static int getTabWidth() {
            return Platform.getPreferencesService().getInt(ECLIPSE_EDITORS_PLUGIN, "tabWidth", 4, new IScopeContext[]{InstanceScope.INSTANCE});
        }

        public static boolean useSpaces() {
            return Platform.getPreferencesService().getBoolean(ECLIPSE_EDITORS_PLUGIN, "spacesForTabs", false, new IScopeContext[]{InstanceScope.INSTANCE});
        }

        public static String computeIndentUnit() {
            if (!NodeWriter.useSpaces()) {
                return "\t";
            }
            int n = NodeWriter.getTabWidth();
            StringBuilder sb = new StringBuilder(n);
            int i = 0;
            while (i < n) {
                sb.append(' ');
                ++i;
            }
            return sb.toString();
        }

        public NodeWriter(boolean separate) {
            this.next();
            this.separate = separate;
            this.indentUnit = NodeWriter.computeIndentUnit();
        }

        public void next() {
            if (this.separate) {
                while (this.current != null && this.current.length() > 0 && (this.current.charAt(this.current.length() - 1) == '\r' || this.current.charAt(this.current.length() - 1) == '\n')) {
                    this.current.setLength(this.current.length() - 1);
                }
                this.current = new StringBuilder();
                this.builders.add(this.current);
            }
        }

        public NodeWriter append(String s) {
            this.current.append(s);
            return this;
        }

        public String[] getResult() {
            String[] result = new String[this.builders.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = this.builders.get(i).toString();
                ++i;
            }
            return result;
        }

        public String getText() {
            if (this.builders.size() == 1) {
                return this.builders.get(0).toString();
            }
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i < this.builders.size()) {
                result.append(this.builders.get(i).toString());
                ++i;
            }
            return result.toString();
        }

        public void appendIndent(int indent) {
            int i = 0;
            while (i < indent) {
                this.append(this.indentUnit);
                ++i;
            }
        }
    }

    public static class RootNode
    extends ElementNode {
        public static ElementNode newRoot() {
            return new RootNode();
        }

        public RootNode() {
            super(null, false);
        }

        @Override
        public void flush(NodeWriter sb, int indent) {
            for (NamedNode c : this.children) {
                c.flush(sb, indent);
            }
        }
    }

    public static class TextNode
    extends NamedNode {
        public TextNode(String text) {
            this.name = text;
        }

        @Override
        public void flush(NodeWriter sb, int indent) {
            if (indent >= 0) {
                sb.appendIndent(indent);
            }
            sb.append(this.name);
            if (indent >= 0) {
                sb.append("\n");
            }
        }
    }
}

