/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd.composite;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TagAttributesTableViewer
extends TableViewer {
    private boolean isHandle = true;
    private boolean isTraversed = false;

    public TagAttributesTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    public TagAttributesTableViewer(Composite parent) {
        super(parent);
    }

    public TagAttributesTableViewer(Table table) {
        super(table);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        if (this.getColumnViewerEditor() != null) {
            this.getTable().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (TagAttributesTableViewer.this.isHandle || !TagAttributesTableViewer.this.isHandle && TagAttributesTableViewer.this.isTraversed) {
                        TagAttributesTableViewer.this.handleKeyReleasedEvent(e);
                    }
                    TagAttributesTableViewer.this.isHandle = true;
                    TagAttributesTableViewer.this.isTraversed = false;
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            this.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TagAttributesTableViewer.this.isTraversed = false;
                    TagAttributesTableViewer.this.isHandle = true;
                }
            });
            this.getTable().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.character == '\r') {
                        e.doit = false;
                    }
                    if (TagAttributesTableViewer.this.isCellEditorActive() && e.detail == 2) {
                        e.doit = false;
                        e.detail = 0;
                        TagAttributesTableViewer.this.isTraversed = true;
                    }
                }
            });
        }
    }

    private void handleKeyReleasedEvent(KeyEvent keyEvent) {
        if (keyEvent.character == '\r' && keyEvent.doit) {
            TableItem[] selectedItems = this.getTable().getSelection();
            if (selectedItems == null || selectedItems.length != 1) {
                return;
            }
            TableItem item = selectedItems[0];
            ViewerRow row = this.getViewerRowFromItem((Widget)item);
            ViewerCell cell = row.getCell(1);
            if (cell != null) {
                this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(cell));
            }
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        super.setCellEditors(editors);
        editors[1].addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                TagAttributesTableViewer.this.isHandle = false;
            }

            public void cancelEditor() {
                TagAttributesTableViewer.this.isHandle = false;
            }

            public void applyEditorValue() {
            }
        });
    }
}

