/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import java.util.Iterator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.jboss.tools.common.model.ui.forms.AbstractFormContainer;
import org.jboss.tools.common.model.ui.forms.IForm;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class DefaultFormContainer
extends AbstractFormContainer {
    private Composite composite;
    private IWidgetSettings settings;

    public DefaultFormContainer() {
    }

    public DefaultFormContainer(IForm form) {
        this.addForm(form);
    }

    @Override
    public Control createControl(Composite parent, IWidgetSettings settings) {
        this.settings = settings;
        this.composite = new Composite(parent, 0);
        settings.setupControl((Control)this.composite);
        this.composite.setLayout(this.getLayout());
        this.composite.setLayoutData(this.getLayoutData());
        int i = 0;
        while (i < this.size()) {
            this.get(i).createControl(this.composite, settings);
            ++i;
        }
        return this.composite;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public boolean addForm(IForm form) {
        if (this.composite != null) {
            Control control = form.getControl();
            if (control == null) {
                control = form.createControl(this.composite, this.settings);
            } else {
                control.setParent(this.composite);
            }
            GridData gd = new GridData(1808);
            control.setLayoutData((Object)gd);
            this.reflow();
        }
        form.setParent(this);
        form.setEnabled(this.isEnabled());
        return this.forms.add(form);
    }

    protected void reflow() {
        this.composite.setRedraw(false);
        this.composite.getParent().setRedraw(false);
        this.composite.layout(true);
        this.composite.getParent().layout(true);
        this.composite.setRedraw(true);
        this.composite.getParent().setRedraw(true);
    }

    @Override
    public void addForm(int index, IForm form) {
    }

    @Override
    public boolean removeForm(IForm form) {
        Control control = form.getControl();
        control.setParent(null);
        this.reflow();
        return this.forms.remove(form);
    }

    @Override
    public IForm removeForm(int index) {
        return null;
    }

    @Override
    public void clear() {
        for (IForm form : this.forms) {
            form.dispose();
            Object var2_2 = null;
        }
        this.forms.clear();
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        int i = 0;
        while (i < this.size()) {
            this.get(i).dispose();
            ++i;
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.dispose();
        }
        this.composite = null;
    }

    @Override
    public void initialize(Object model) {
        int i = 0;
        while (i < this.size()) {
            this.get(i).initialize(model);
            ++i;
        }
    }

    @Override
    public void commitChanges(boolean onSave) {
        int i = 0;
        while (i < this.size()) {
            this.get(i).commitChanges(onSave);
            ++i;
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        boolean result = Boolean.FALSE;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            IForm form = (IForm)i.next();
            result &= form.doGlobalAction(actionId);
        }
        return result;
    }

    @Override
    public void expandTo(Object object) {
        int i = 0;
        while (i < this.size()) {
            this.get(i).expandTo(object);
            ++i;
        }
    }

    @Override
    public void update() {
        int i = 0;
        while (i < this.size()) {
            this.get(i).update();
            ++i;
        }
    }

    @Override
    public void store(IMemento memento) {
        if (this.forms != null && this.forms.size() > 0) {
            for (IForm form : this.forms) {
                IMemento formMemento = memento.getChild(form.getHeadingText());
                if (formMemento == null) {
                    formMemento = memento.createChild(form.getHeadingText());
                }
                form.store(formMemento);
            }
        }
    }

    @Override
    public void load(IMemento memento) {
        if (this.forms != null && this.forms.size() > 0) {
            for (IForm form : this.forms) {
                IMemento formMemento = memento.getChild(form.getHeadingText());
                if (formMemento == null) {
                    formMemento = memento.createChild(form.getHeadingText());
                }
                form.load(formMemento);
            }
        }
    }
}

