/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.editor.form.RightFormContainer;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIMessages;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.XChildrenTableStructuredAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.JavaEclipseChoicerEditor;
import org.jboss.tools.common.model.ui.attribute.editor.TableStructuredEditor;
import org.jboss.tools.common.model.ui.attribute.editor.TableStructuredFieldEditor;
import org.jboss.tools.common.model.ui.forms.AttributeControlType;
import org.jboss.tools.common.model.ui.forms.ExpandableForm;
import org.jboss.tools.common.model.ui.forms.IFormActionData;
import org.jboss.tools.common.model.ui.forms.IFormAttributeData;
import org.jboss.tools.common.model.ui.forms.IFormContainer;
import org.jboss.tools.common.model.ui.forms.IFormData;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class Form
extends ExpandableForm {
    private XAttributeSupport support;
    private XModelObject xmo;
    private TableStructuredEditor tableEditor;
    private XChildrenTableStructuredAdapter tableAdapter;
    private IFormData formData;
    private boolean table = false;
    private ArrayList<ExtendedFieldEditor> fieldEditors = new ArrayList();

    private Form() {
    }

    protected XAttributeSupport getSupport() {
        return this.support;
    }

    protected XModelObject getModelObject() {
        return this.xmo;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
        if (this.tableEditor != null) {
            this.tableEditor.dispose();
        }
        this.tableEditor = null;
        if (this.tableAdapter != null) {
            this.tableAdapter.dispose();
        }
        this.tableAdapter = null;
        if (this.fieldEditors != null) {
            for (ExtendedFieldEditor object : this.fieldEditors) {
                if (!(object instanceof ExtendedFieldEditor)) continue;
                object.dispose();
            }
            this.fieldEditors.clear();
        }
        this.fieldEditors = null;
    }

    public Form(IFormData formData) {
        this.formData = formData;
        this.table = formData.getEntities() != null;
        this.setHeadingText(formData.getHeader());
        this.support = new XAttributeSupport(formData.getWidgetSettings());
        this.setCollapsable(Boolean.TRUE);
    }

    @Override
    protected Control createClientArea(Composite parent, IWidgetSettings settings) {
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(1);
        settings.setupControl((Control)composite);
        GridLayout layout = new GridLayout(2, Boolean.FALSE.booleanValue());
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        Control[] control = null;
        GridData gd = null;
        String description = this.formData.getDescription();
        if (description != null && description.length() > 0) {
            Label label = new Label(composite, 64);
            label.setText(description);
            settings.setupControl((Control)label);
            gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }
        if (this.xmo == null) {
            return composite;
        }
        IFormAttributeData[] attributes = this.formData.getAttributes();
        if (!this.table) {
            int i = 0;
            while (i < attributes.length) {
                IPropertyEditor editor = this.support.getPropertyEditorByName(attributes[i].getName());
                if (editor != null) {
                    if (attributes[i].getWraperClassName() != null && !(editor instanceof JavaEclipseChoicerEditor)) {
                        try {
                            Class<?> wraperClass = Class.forName(attributes[i].getWraperClassName());
                            Constructor<?> wraperConstructor = wraperClass.getConstructor(IWidgetSettings.class);
                            IPropertyFieldEditor wraper = (IPropertyFieldEditor)wraperConstructor.newInstance(this.formData.getWidgetSettings());
                            ((ExtendedFieldEditor)((Object)wraper)).setLabelText(editor.getLabelText());
                            wraper.setPropertyEditor(editor);
                            ((ExtendedFieldEditor)((Object)wraper)).fillIntoGrid(composite, 2);
                            ((ExtendedFieldEditor)((Object)wraper)).setEnabled(this.xmo.isAttributeEditable(attributes[i].getName()));
                            this.fieldEditors.add((ExtendedFieldEditor)((Object)wraper));
                            this.support.registerFieldEditor(editor.getAttributeName(), (ExtendedFieldEditor)((Object)wraper));
                        }
                        catch (ClassNotFoundException e) {
                            ModelUIPlugin.getPluginLog().logError((Throwable)e);
                        }
                        catch (NoSuchMethodException e) {
                            ModelUIPlugin.getPluginLog().logError((Throwable)e);
                        }
                        catch (InstantiationException e) {
                            ModelUIPlugin.getPluginLog().logError((Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            ModelUIPlugin.getPluginLog().logError((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            ModelUIPlugin.getPluginLog().logError((Throwable)e);
                        }
                    } else {
                        ExtendedFieldEditor fieldEditor = (ExtendedFieldEditor)((Object)((IFieldEditor)((Object)editor.getFieldEditor(composite))));
                        this.fieldEditors.add(fieldEditor);
                        control = ((IFieldEditor)((Object)fieldEditor)).getControls(composite);
                        control[0].setLayoutData(attributes[i].getLayoutDataFactory().createLayoutData(AttributeControlType.LABEL));
                        control[1].setLayoutData(attributes[i].getLayoutDataFactory().createLayoutData(AttributeControlType.EDITOR));
                        fieldEditor.setEnabled(this.xmo.isAttributeEditable(attributes[i].getName()));
                        this.support.registerFieldEditor(editor.getAttributeName(), fieldEditor);
                    }
                } else {
                    ModelUIPlugin.getPluginLog().logInfo(NLS.bind((String)ModelUIMessages.Form_CANNOT_LOAD_ATTRIBUTE, (Object)attributes[i].getName()));
                }
                ++i;
            }
        } else {
            ExtendedFieldEditor fieldEditor = (ExtendedFieldEditor)((Object)((IFieldEditor)((Object)this.tableEditor.getFieldEditor(composite))));
            this.fieldEditors.add(fieldEditor);
            control = ((IFieldEditor)((Object)fieldEditor)).getControls(composite);
            control[0].dispose();
            if (fieldEditor instanceof TableStructuredFieldEditor) {
                ((TableStructuredFieldEditor)fieldEditor).updateTableLayoutData();
                gd = (GridData)control[1].getLayoutData();
            }
            if (gd == null) {
                gd = new GridData(768);
                gd.heightHint = 300;
            }
            gd.horizontalSpan = 2;
            control[1].setLayoutData((Object)gd);
            fieldEditor.setEnabled(this.xmo.isObjectEditable());
        }
        return composite;
    }

    @Override
    public void initialize(Object model) {
        this.xmo = (XModelObject)model;
        if (this.xmo == null) {
            ModelUIPlugin.getPluginLog().logInfo("Error to create form " + this.formData.getHeader() + ". Model object cannot be null.", (Throwable)new IllegalArgumentException("Parameter cannot be null"));
            return;
        }
        this.model = this.xmo.getModel();
        this.support.init(this.xmo);
        this.support.setAutoStore(Boolean.TRUE);
        IFormAttributeData[] attributes = this.formData.getAttributes();
        IFormActionData[] actions = this.formData.getActions();
        String[] entities = this.formData.getEntities();
        if (this.table) {
            int i;
            this.tableAdapter = new XChildrenTableStructuredAdapter();
            this.tableAdapter.setShownEntities(entities);
            this.tableAdapter.getActionMapping().clear();
            XModelEntity childEntity = null;
            if (entities != null) {
                i = 0;
                while (i < entities.length && childEntity == null) {
                    childEntity = this.xmo.getModel().getMetaData().getEntity(entities[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < actions.length) {
                this.tableAdapter.getActionMapping().put(actions[i].getActionLabel(), actions[i].getActionPath());
                ++i;
            }
            String[] shownProperties = new String[attributes.length];
            String[] columnLabels = new String[attributes.length];
            int[] widths = new int[attributes.length];
            int i2 = 0;
            while (i2 < attributes.length) {
                shownProperties[i2] = attributes[i2].getName();
                String label = null;
                if (attributes[i2].getDisplayName() != null && attributes[i2].getDisplayName().length() > 0) {
                    label = attributes[i2].getDisplayName();
                } else if (childEntity != null && childEntity.getAttribute(attributes[i2].getName()) != null) {
                    label = WizardKeys.getAttributeDisplayName((XAttribute)childEntity.getAttribute(attributes[i2].getName()), (boolean)true);
                }
                columnLabels[i2] = label != null ? label : "";
                widths[i2] = attributes[i2].getWidth();
                ++i2;
            }
            this.tableAdapter.setShownProperties(shownProperties);
            this.tableAdapter.setColumnLabels(columnLabels);
            this.tableAdapter.setWidths(widths);
            this.tableAdapter.setModelObject(this.xmo);
            this.tableEditor = new TableStructuredEditor(this.formData.getWidgetSettings());
            this.tableEditor.setLabelText("");
            this.tableEditor.setInput(this.tableAdapter);
        }
    }

    private ISelectionChangedListener findSelectionChangedListener(IFormContainer container) {
        if (container == null) {
            return null;
        }
        if (container instanceof RightFormContainer) {
            return ((RightFormContainer)container).getSelectionChangedListener();
        }
        return this.findSelectionChangedListener(container.getParent());
    }

    @Override
    public void setParent(IFormContainer container) {
        super.setParent(container);
        if (this.tableAdapter != null) {
            this.tableAdapter.setSelectionChangedListener(this.findSelectionChangedListener(container));
        }
    }

    @Override
    public void update() {
        if (this.support != null) {
            this.support.load();
            this.support.updateEnablementByModelObject();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        return this.support.doGlobalAction(actionId);
    }
}

