/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.ui.IMemento;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MementoDOM
implements IMemento {
    private Element element;
    private static final String ID = "id";
    private static final String MEMENTO = "Memento";
    private static final String TYPE = "type";
    private Hashtable hash = new Hashtable();

    private MementoDOM() {
    }

    private MementoDOM(Element owner, String type) {
        this.element = owner.getOwnerDocument().createElement(MEMENTO);
        this.element.setAttribute(TYPE, type);
        owner.appendChild(this.element);
    }

    public MementoDOM(Node node) {
        this.element = (Element)node;
    }

    private IMemento getMemento(Node node) {
        if (node == null) {
            return null;
        }
        IMemento memento = (IMemento)this.hash.get(node);
        if (memento == null) {
            memento = new MementoDOM(node);
            this.hash.put(node, memento);
        }
        return memento;
    }

    public IMemento createChild(String type) {
        return new MementoDOM(this.element, type);
    }

    public IMemento createChild(String type, String id) {
        MementoDOM newMemento = new MementoDOM(this.element, type);
        newMemento.setID(id);
        return newMemento;
    }

    public IMemento getChild(String type) {
        NodeList nl = this.element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && type.equals(((Element)node).getAttribute(TYPE))) {
                return this.getMemento(node);
            }
            ++i;
        }
        return null;
    }

    public IMemento[] getChildren(String type) {
        NodeList nl = this.element.getElementsByTagName(type);
        ArrayList<IMemento> list = new ArrayList<IMemento>();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && type.equals(((Element)node).getAttribute(TYPE))) {
                list.add(this.getMemento(node));
            }
            ++i;
        }
        return list.toArray(new IMemento[list.size()]);
    }

    public Float getFloat(String key) {
        return new Float(this.element.getAttribute(key));
    }

    public String getID() {
        return this.element.getAttribute(ID);
    }

    public Integer getInteger(String key) {
        return Integer.valueOf(this.element.getAttribute(key));
    }

    public String getString(String key) {
        return this.element.getAttribute(key);
    }

    public String getTextData() {
        return this.element.getNodeValue();
    }

    public void putFloat(String key, float value) {
        this.element.setAttribute(key, "" + value);
    }

    public void putInteger(String key, int value) {
        this.element.setAttribute(key, "" + value);
    }

    public void putMemento(IMemento memento) {
        this.element.appendChild(((MementoDOM)memento).getElement());
    }

    public void putString(String key, String value) {
        this.element.setAttribute(key, value);
    }

    public void putTextData(String data) {
        this.element.setNodeValue(data);
    }

    public void setID(String id) {
        this.element.setAttribute(ID, id);
    }

    private Element getElement() {
        return this.element;
    }

    public String[] getAttributeKeys() {
        NamedNodeMap map = this.element.getAttributes();
        int size = map.getLength();
        String[] attributes = new String[size];
        int i = 0;
        while (i < size) {
            Node node = map.item(i);
            attributes[i] = node.getNodeName();
            ++i;
        }
        return attributes;
    }

    public Boolean getBoolean(String key) {
        String attr = this.getString(key);
        if (attr == null) {
            return null;
        }
        return Boolean.valueOf(attr);
    }

    public void putBoolean(String key, boolean value) {
        this.putString(key, value ? "true" : "false");
    }

    public String getType() {
        return this.getString(TYPE);
    }

    public IMemento[] getChildren() {
        ArrayList<IMemento> result = new ArrayList<IMemento>();
        NodeList nl = this.element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element) {
                IMemento memento = this.getMemento(node);
                result.add(memento);
            }
            ++i;
        }
        return result.toArray(new IMemento[result.size()]);
    }
}

