/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class ModelResourceHandler
extends AbstractHandler {
    IResource resource = null;
    protected XModelObject object;
    protected List<XModelObject> objects = new ArrayList<XModelObject>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.resource = null;
        this.object = null;
        this.objects.clear();
        IStructuredSelection structuredSelection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (structuredSelection.size() == 1) {
            Object o = structuredSelection.getFirstElement();
            this.process(o);
            if (this.object == null) {
                this.object = this.getObjectByResource(this.resource);
            }
        } else if (structuredSelection.size() > 1) {
            for (Object o : structuredSelection) {
                this.object = null;
                this.process(o);
                if (this.object == null && this.resource != null) {
                    this.object = this.getObjectByResource(this.resource);
                }
                if (this.object != null) {
                    this.objects.add(this.object);
                    continue;
                }
                this.resource = null;
                this.objects.clear();
                return null;
            }
        }
        if (this.compureEnabled()) {
            this.doRun();
        }
        return null;
    }

    protected boolean compureEnabled() {
        boolean enabled;
        boolean bl = enabled = this.object != null;
        if (enabled) {
            XAction a = this.object.getModelEntity().getActionList().getAction(this.getActionPath());
            enabled = a != null && (this.objects.size() < 2 ? a.isEnabled(this.object) : a.isEnabled(this.object, this.objects.toArray(new XModelObject[0])));
        }
        return enabled;
    }

    private void doRun() {
        Properties p = new Properties();
        this.initProperties(p);
        if (this.objects.size() < 2) {
            XActionInvoker.invoke((String)this.getActionPath(), (XModelObject)this.object, (Properties)p);
        } else {
            XModelObject[] os = this.objects.toArray(new XModelObject[0]);
            XActionInvoker.invoke((String)this.getActionPath(), (XModelObject)this.object, (XModelObject[])os, (Properties)p);
        }
    }

    protected String getActionPath() {
        return null;
    }

    protected void initProperties(Properties p) {
    }

    private void process(Object o) {
        if (!(this.checkModelObject(o) || this.checkFile(o) || this.checkProject(o))) {
            this.checkFolder(o);
        }
    }

    XModelObject getObjectByResource(IResource resource) {
        Object object = null;
        if (resource != null && !this.isRelevantProject(resource.getProject())) {
            resource = null;
        }
        if (resource == null) {
            object = null;
        } else if (resource instanceof IProject) {
            IModelNature n = EclipseResourceUtil.getModelNature((IProject)((IProject)resource));
            object = n != null ? FileSystemsHelper.getFileSystems((XModel)n.getModel()) : null;
        } else {
            object = EclipseResourceUtil.getObjectByResource((IResource)resource);
            if (object == null) {
                object = EclipseResourceUtil.createObjectForResource((IResource)resource);
            }
            if (object != null) {
                this.checkModelObject(object);
            }
        }
        return object;
    }

    protected boolean isRelevantProject(IProject project) {
        return true;
    }

    protected boolean checkModelObject(Object object) {
        if (object instanceof XModelObject) {
            this.object = (XModelObject)object;
            return true;
        }
        return false;
    }

    protected boolean checkFile(Object object) {
        if (object instanceof IFile) {
            if (this.isSupportingImplementation(IFile.class)) {
                this.resource = (IFile)object;
            }
        } else if (object instanceof IClassFile) {
            if (this.isSupportingImplementation(IFile.class)) {
                try {
                    this.resource = ((IClassFile)object).getCorrespondingResource();
                }
                catch (JavaModelException javaModelException) {}
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean checkFolder(Object object) {
        if (object instanceof IFolder) {
            if (this.isSupportingImplementation(IFolder.class)) {
                this.resource = (IFolder)object;
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean checkProject(Object object) {
        IProject project = null;
        if (object instanceof IProject) {
            if (!this.isSupportingImplementation(IProject.class)) {
                return true;
            }
            project = (IProject)object;
        } else if (object instanceof IJavaProject) {
            if (!this.isSupportingImplementation(IJavaProject.class)) {
                return true;
            }
            project = ((IJavaProject)object).getProject();
        } else {
            return false;
        }
        if (!(project == null || project.isOpen() && this.hasModelNature(project))) {
            project = null;
        }
        this.resource = project;
        return true;
    }

    protected boolean hasModelNature(IProject project) {
        String[] s = EclipseResourceUtil.getModelNatureNames();
        int i = 0;
        while (i < s.length) {
            try {
                if (project.hasNature(s[i])) {
                    return true;
                }
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            ++i;
        }
        return false;
    }

    protected boolean isSupportingImplementation(Class cls) {
        return cls == IFile.class || cls == XModelObject.class;
    }
}

