/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.navigator.decorator;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.navigator.decorator.XModelObjectDecorator;

public class DecoratorManager {
    public static final String EXTENSION_POINT_ID = "org.jboss.tools.common.model.ui.labelDecorator";
    private Map<String, XModelObjectDecorator> mapByName = new HashMap<String, XModelObjectDecorator>();
    private Map<String, XModelObjectDecorator> mapByEntity = new HashMap<String, XModelObjectDecorator>();
    private Map<String, Set<XModelObjectDecorator>> mapByPartition = new HashMap<String, Set<XModelObjectDecorator>>();
    private Map<String, String> entityByPartition = new HashMap<String, String>();

    private DecoratorManager() {
        this.load();
    }

    public static DecoratorManager getInstance() {
        return DecoratorManagerHolder.INSTANCE;
    }

    public XModelObjectDecorator getDecoratorByEntity(String entity) {
        return this.mapByEntity.get(entity);
    }

    public Set<XModelObjectDecorator> getDecoratorsByPartition(String partition) {
        return this.mapByPartition.get(partition);
    }

    public String getBaseEntityForPartition(String partition) {
        return this.entityByPartition.get(partition);
    }

    public String[] getPartitions() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.mapByPartition.keySet());
        return set.toArray(new String[0]);
    }

    private void load() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            return;
        }
        IExtension[] es = point.getExtensions();
        if (es != null) {
            int i = 0;
            while (i < es.length) {
                IConfigurationElement[] elements = es[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    XModelObjectDecorator d = new XModelObjectDecorator();
                    d.load(elements[j]);
                    String name = d.getName();
                    String partition = d.getPartition();
                    Set<String> entities = d.getEntities();
                    this.mapByName.put(name, d);
                    Set<XModelObjectDecorator> set = this.mapByPartition.get(partition);
                    if (set == null) {
                        set = new HashSet<XModelObjectDecorator>();
                        this.mapByPartition.put(partition, set);
                    }
                    set.add(d);
                    for (String entity : entities) {
                        this.mapByEntity.put(entity, d);
                        if (!entity.startsWith("File") || this.entityByPartition.get(partition) != null) continue;
                        this.entityByPartition.put(partition, entity);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.loadFromPreferences();
    }

    public void loadFromPreferences() {
        IPreferenceStore p = DecoratorManager.getPreferences();
        for (Map.Entry<String, XModelObjectDecorator> entry : this.mapByName.entrySet()) {
            XModelObjectDecorator d = entry.getValue();
            String key = "org.jboss.tools.common.model.ui.labelDecorator." + entry.getKey();
            String value = p.getString(key);
            if (value == null || value.length() <= 0) continue;
            d.setValue(value);
        }
    }

    public void applyToPreferences() {
        IPreferenceStore p = DecoratorManager.getPreferences();
        for (Map.Entry<String, XModelObjectDecorator> entry : this.mapByName.entrySet()) {
            XModelObjectDecorator d = entry.getValue();
            String key = "org.jboss.tools.common.model.ui.labelDecorator." + entry.getKey();
            String value = d.getValue();
            if (value != null && !value.equals(d.getDefaultValue()) && !value.equals("{name}")) {
                p.setValue(key, value);
                continue;
            }
            p.setValue(key, "");
        }
        if (p instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)p).save();
            }
            catch (IOException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public void setDefaults() {
        for (XModelObjectDecorator d : this.mapByName.values()) {
            d.setValue(d.getDefaultValue());
        }
    }

    public static IPreferenceStore getPreferences() {
        return ModelUIPlugin.getDefault().getPreferenceStore();
    }

    /* synthetic */ DecoratorManager(DecoratorManager decoratorManager) {
        this();
    }

    public static class DecoratorManagerHolder {
        public static DecoratorManager INSTANCE = new DecoratorManager(null);
    }
}

