/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.objecteditor;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintAList;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;

public class XAttributeInfo {
    XModelObject object;
    String name;
    String value;
    IPropertyEditor propertyEditor;
    Map<String, String> visualToModel = null;
    Map<String, String> modelToVisual = null;

    public XAttributeInfo(XModelObject object, String name) {
        this.object = object;
        this.name = name;
        this.value = this.getValue();
        XAttribute a = object.getModelEntity().getAttribute(name);
        this.visualToModel = null;
        if (a != null && a.getConstraint() instanceof XAttributeConstraintAList) {
            this.visualToModel = new HashMap<String, String>();
            this.modelToVisual = new HashMap<String, String>();
            String[] vs = ((XAttributeConstraintAList)a.getConstraint()).getValues();
            int i = 0;
            while (i < vs.length) {
                String vv = WizardKeys.getVisualListValue((XAttribute)a, (String)vs[i]);
                this.visualToModel.put(vv, vs[i]);
                this.modelToVisual.put(vs[i], vv);
                ++i;
            }
        }
    }

    public XModelObject getObject() {
        return this.object;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        String v = this.object.getAttributeValue(this.name);
        if (this.modelToVisual != null && v != null && this.modelToVisual.containsKey(v)) {
            v = this.modelToVisual.get(v);
        }
        return v;
    }

    public boolean isEditable() {
        if (!this.object.isAttributeEditable(this.name)) {
            return false;
        }
        XAttribute a = this.object.getModelEntity().getAttribute(this.name);
        return a != null && !a.getEditor().getName().equals("Uneditable");
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void commit() throws XModelException {
        String modelValue = this.value;
        if (this.visualToModel != null && this.visualToModel.containsKey(this.value)) {
            modelValue = this.visualToModel.get(this.value);
        }
        if (this.propertyEditor != null && this.propertyEditor.getInput() instanceof IModelPropertyEditorAdapter) {
            IModelPropertyEditorAdapter adapter = (IModelPropertyEditorAdapter)this.propertyEditor.getInput();
            adapter.setValue(modelValue);
            adapter.store();
        } else {
            this.object.getModel().editObjectAttribute(this.object, this.name, modelValue);
        }
        this.value = this.getValue();
    }
}

