/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.objecteditor;

import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.dnd.ControlDragDrop;
import org.jboss.tools.common.model.ui.dnd.IControlDragDropProvider;
import org.jboss.tools.common.model.ui.dnd.IControlDropListener;
import org.jboss.tools.common.model.ui.objecteditor.Messages;
import org.jboss.tools.common.model.ui.objecteditor.XTable;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.common.model.ui.swt.util.BorderLayout;
import org.jboss.tools.common.model.util.AbstractTableHelper;

public class XChildrenEditor
implements CommandBarListener {
    protected static Color DEFAULT_COLOR = Display.getDefault().getSystemColor(2);
    protected static Color GREYED_COLOR = Display.getDefault().getSystemColor(15);
    protected static Color RED_COLOR = Display.getDefault().getSystemColor(3);
    public static String ADD = Messages.XChildrenEditor_Add;
    public static String DELETE = Messages.XChildrenEditor_Delete;
    public static String EDIT = Messages.XChildrenEditor_Edit;
    public static String UP = Messages.XChildrenEditor_Up;
    public static String DOWN = Messages.XChildrenEditor_Down;
    protected Composite control;
    protected AbstractTableHelper helper = this.createHelper();
    protected XTable xtable = new XTable();
    protected boolean lock = false;
    protected CommandBar bar = new CommandBar();
    protected SelectionListener selectionListener = null;
    DnDProvider dndProvider = new DnDProvider();
    ControlDragDrop dnd = new ControlDragDrop();
    long updateTimeStamp = -1L;
    AbstractSelectionProvider selectionProvider = new SP();

    public void dispose() {
        if (this.xtable != null) {
            this.xtable.dispose();
        }
        this.xtable = null;
        if (this.bar != null) {
            this.bar.dispose();
        }
        this.bar = null;
    }

    public XChildrenEditor() {
        this.bar.addCommandBarListener(this);
        this.xtable.setTableProvider(new XTableProviderImpl());
    }

    public void setMnemonicEnabled(boolean b) {
        this.bar.setMnemonicEnabled(b);
    }

    public void setHeaderVisible(boolean b) {
        this.xtable.setHeaderVisible(b);
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        BorderLayout bl = new BorderLayout();
        this.control.setLayout((Layout)bl);
        this.xtable.createControl(this.control);
        bl.centerComposite = this.xtable.getControl();
        this.createCommandBar();
        this.enableSelectionListener();
        this.update();
        this.dnd.setProvider(this.dndProvider);
        this.dnd.enable();
        this.xtable.getTable().addMouseListener((MouseListener)new DoubleClickListener());
        this.xtable.update();
        return this.control;
    }

    public Control getControl() {
        return this.control;
    }

    protected int[] getColumnWidthHints() {
        int l = this.helper.getHeader().length;
        int[] is = new int[l];
        int i = 0;
        while (i < l) {
            is[i] = 10;
            ++i;
        }
        return is;
    }

    protected void createCommandBar() {
        String[] stringArray;
        if (this.areUpDounActionsEnabled()) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = ADD;
            stringArray2[1] = EDIT;
            stringArray2[2] = DELETE;
            stringArray2[3] = UP;
            stringArray = stringArray2;
            stringArray2[4] = DOWN;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = ADD;
            stringArray3[1] = EDIT;
            stringArray = stringArray3;
            stringArray3[2] = DELETE;
        }
        String[] commands = stringArray;
        this.bar.setCommands(commands);
        this.bar.getLayout().direction = 512;
        this.bar.getLayout().buttonWidth = this.convertHorizontalDLUsToPixels((Control)this.control, 61);
        this.setMargins(this.bar);
        this.bar.createControl(this.control);
        BorderLayout bl = (BorderLayout)this.control.getLayout();
        bl.eastComposite = this.bar.getControl();
        bl.eastWidth = -1;
    }

    protected void setMargins(CommandBar bar) {
        bar.getLayout().setMargins(0, 10, 0, 0);
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    protected AbstractTableHelper createHelper() {
        return null;
    }

    public void setObject(XModelObject object) {
        this.helper.setModelObject(object);
        if (this.xtable != null && this.xtable.getTable() != null && this.xtable.getSelectionIndex() < 0 && this.xtable.getTable().getItemCount() > 0) {
            this.xtable.getTable().select(0);
        }
    }

    protected boolean areUpDounActionsEnabled() {
        return false;
    }

    public void update() {
        long ts;
        if (this.xtable.getControl() == null || this.xtable.getControl().isDisposed()) {
            return;
        }
        long l = ts = this.helper.getModelObject() == null ? -1L : this.helper.getModelObject().getTimeStamp();
        if (ts != this.updateTimeStamp || ts == -1L) {
            this.updateTimeStamp = ts;
            this.lock = true;
            this.xtable.update();
            this.lock = false;
        }
        if (this.selectionListener != null) {
            this.updateBar();
        }
    }

    protected Color getItemColor(int i) {
        return DEFAULT_COLOR;
    }

    protected void enableSelectionListener() {
        this.selectionListener = new TL();
        this.xtable.getTable().addSelectionListener(this.selectionListener);
        this.updateBar();
    }

    protected void onSelectionChanged() {
        if (!this.lock) {
            this.updateBar();
            this.selectionProvider.fireSelectionChanged();
        }
    }

    @Override
    public void action(String command) {
        if (ADD.equals(command)) {
            this.add();
        } else if (DELETE.equals(command)) {
            this.delete();
        } else if (EDIT.equals(command)) {
            this.edit();
        } else if (UP.equals(command)) {
            this.up();
        } else if (DOWN.equals(command)) {
            this.down();
        }
        this.update();
        if (this.xtable.isActive()) {
            this.xtable.getTable().setFocus();
        }
    }

    protected void add() {
        if (this.helper.getModelObject() == null) {
            return;
        }
        Set set = this.getKeys();
        this.callAction(this.helper.getModelObject(), this.getAddActionPath());
        this.update();
        int i = this.getAddedKey(set);
        if (i >= 0) {
            this.xtable.setSelection(i);
            this.onSelectionChanged();
        }
    }

    protected void delete() {
        XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
        if (o != null) {
            this.callAction(o, "DeleteActions.Delete");
        }
    }

    protected void edit() {
        XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
        if (o != null) {
            this.callAction(o, "Edit");
        }
    }

    protected void up() {
        int r1 = this.xtable.getSelectionIndex();
        int r2 = r1 - 1;
        if (r2 < 0) {
            return;
        }
        this.move(r1, r2);
    }

    protected void down() {
        int r1 = this.xtable.getSelectionIndex();
        int r2 = r1 + 1;
        if (r1 < 0 || r2 >= this.xtable.getTable().getItemCount()) {
            return;
        }
        this.move(r1, r2);
    }

    private void move(int r1, int r2) {
        XModelObject o1 = this.helper.getModelObject(r1);
        XModelObject o2 = this.helper.getModelObject(r2);
        this.callAction(o1, "CopyActions.Copy");
        this.callAction(o2, "MoveActions.Move");
        if (this.helper.getModelObject(r2) == o1) {
            this.xtable.getViewer().setSelection((ISelection)new StructuredSelection((Object)o1), true);
            ((SP)this.getSelectionProvider()).fireSelectionChanged();
        }
    }

    protected Set getKeys() {
        return this.xtable.getKeys();
    }

    protected int getAddedKey(Set set) {
        return this.xtable.getAddedKey(set);
    }

    protected String getAddActionPath() {
        return "CreateActions.AddKeyPair";
    }

    protected void updateBar() {
        boolean enabled = !this.isReadOnly();
        boolean multi = this.xtable.getTable().getSelectionIndices().length > 1;
        int r = !enabled ? -1 : this.xtable.getSelectionIndex();
        this.bar.setEnabled(ADD, enabled);
        this.bar.setEnabled(DELETE, r >= 0);
        this.bar.setEnabled(EDIT, r >= 0 && !multi);
        if (this.areUpDounActionsEnabled()) {
            this.bar.setEnabled(UP, r > 0 && !multi);
            this.bar.setEnabled(DOWN, r >= 0 && r < this.helper.size() - 1 && !multi);
        }
    }

    protected boolean isReadOnly() {
        return this.helper == null || this.helper.getModelObject() == null || !this.helper.getModelObject().isObjectEditable();
    }

    public void callAction(XModelObject o, String path) {
        Properties p = new Properties();
        p.put("shell", this.bar.getControl().getShell());
        int i = this.xtable.getSelectionIndex();
        p.put("insertAfter", (Object)i);
        XActionInvoker.invoke((String)path, (XModelObject)o, (XModelObject[])this.getTargets(), (Properties)p);
    }

    private XModelObject[] getTargets() {
        int[] is = this.xtable.getTable().getSelectionIndices();
        if (is.length < 2) {
            return null;
        }
        XModelObject[] os = new XModelObject[is.length];
        int i = 0;
        while (i < os.length) {
            os[i] = this.helper.getModelObject(is[i]);
            ++i;
        }
        return os;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public XModelObject getSelectedObject() {
        return ((SP)this.selectionProvider).getSelectedModelObject();
    }

    class DnDProvider
    implements IControlDragDropProvider,
    IControlDropListener {
        DnDProvider() {
        }

        @Override
        public Control getControl() {
            return XChildrenEditor.this.xtable.getTable();
        }

        @Override
        public XModelObject getModelObjectForWidget(Widget widget) {
            if (widget == null) {
                return null;
            }
            Object o = widget.getData();
            return o instanceof XModelObject ? (XModelObject)o : null;
        }

        @Override
        public Widget[] getSelection() {
            return XChildrenEditor.this.xtable.getTable().getSelection();
        }

        @Override
        public Properties getDropProperties(int x, int y) {
            return new Properties();
        }

        @Override
        public void drop(Properties p) {
            XModelObject draggedObject = (XModelObject)p.get("draggedObject");
            if (draggedObject == null) {
                return;
            }
            XChildrenEditor.this.xtable.getViewer().cancelEditing();
            XChildrenEditor.this.update();
            XChildrenEditor.this.xtable.getViewer().setSelection((ISelection)new StructuredSelection((Object)draggedObject));
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        DoubleClickListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (XChildrenEditor.this.bar.isEnabled(EDIT)) {
                XChildrenEditor.this.action(EDIT);
            }
        }
    }

    class SP
    extends AbstractSelectionProvider {
        SP() {
        }

        @Override
        protected XModelObject getSelectedModelObject() {
            if (XChildrenEditor.this.xtable.getTable() == null || XChildrenEditor.this.xtable.getTable().isDisposed()) {
                return null;
            }
            int r = XChildrenEditor.this.xtable.getSelectionIndex();
            return XChildrenEditor.this.helper.getModelObject(r);
        }

        @Override
        protected void setSelectedModelObject(XModelObject object) {
            if (XChildrenEditor.this.xtable.getTable() == null || XChildrenEditor.this.xtable.getTable().isDisposed()) {
                return;
            }
            if (object == null || object.getPath() == null) {
                return;
            }
            XModelObject o = XChildrenEditor.this.helper.getModelObject();
            if (o != null && !object.getPath().startsWith(o.getPath())) {
                return;
            }
            int i = 0;
            while (i < XChildrenEditor.this.helper.size()) {
                if (XChildrenEditor.this.helper.getModelObject(i) == object) {
                    XChildrenEditor.this.xtable.setSelection(i);
                    XChildrenEditor.this.updateBar();
                    return;
                }
                ++i;
            }
        }
    }

    class TL
    implements SelectionListener {
        TL() {
        }

        public void widgetSelected(SelectionEvent e) {
            XChildrenEditor.this.onSelectionChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class XTableProviderImpl
    implements XTableProvider {
        XTableProviderImpl() {
        }

        @Override
        public int getColumnCount() {
            return XChildrenEditor.this.helper.getHeader().length;
        }

        @Override
        public int getRowCount() {
            return XChildrenEditor.this.helper.size();
        }

        @Override
        public String getColumnName(int c) {
            return XChildrenEditor.this.helper.getVisibleHeader()[c];
        }

        @Override
        public String getValueAt(int r, int c) {
            return XChildrenEditor.this.helper.getValueAt(r, c);
        }

        @Override
        public Color getColor(int r) {
            return XChildrenEditor.this.getItemColor(r);
        }

        @Override
        public int getWidthHint(int c) {
            return XChildrenEditor.this.getColumnWidthHints()[c];
        }

        @Override
        public Object getDataAt(int r) {
            return XChildrenEditor.this.helper.getModelObject(r);
        }

        @Override
        public void dispose() {
        }
    }
}

