/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.preferences.IPreferencePageExt;
import org.jboss.tools.common.model.ui.preferences.XMOBasedPreferencesPage;
import org.jboss.tools.common.model.ui.util.ModelUtilities;

public class TabbedPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Map<String, PreferencePage> map = new HashMap<String, PreferencePage>();
    List<PreferencePage> pageList = new ArrayList<PreferencePage>();

    public TabbedPreferencesPage(String[] paths) {
        this.addAllPreferencePage(this.convertPathArrayToPreferencePageList(paths));
    }

    public TabbedPreferencesPage() {
    }

    public final XModel getPreferenceModel() {
        return ModelUtilities.getPreferenceModel();
    }

    private List convertPathArrayToPreferencePageList(String[] path) {
        XModel model = this.getPreferenceModel();
        if (model == null) {
            throw new IllegalArgumentException("Preference XModel not loaded.");
        }
        if (path == null) {
            throw new IllegalArgumentException("String array with path's cannot be null");
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("Path array should contains at least one element.");
        }
        ArrayList<XMOBasedPreferencesPage> pages = new ArrayList<XMOBasedPreferencesPage>();
        int i = 0;
        while (i < path.length) {
            XModelObject o = model.getByPath(path[i]);
            XMOBasedPreferencesPage page = new XMOBasedPreferencesPage(o);
            pages.add(page);
            this.map.put(path[i], page);
            ++i;
        }
        return pages;
    }

    public XMOBasedPreferencesPage getXMOTabPage(String name) {
        return (XMOBasedPreferencesPage)this.map.get(name);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        TabFolder tabbedComposite = new TabFolder(parent, 0);
        tabbedComposite.setBackground(parent.getBackground());
        for (PreferencePage element : this.pageList) {
            TabItem newTab = new TabItem(tabbedComposite, 0);
            element.createControl((Composite)tabbedComposite);
            if (element instanceof XMOBasedPreferencesPage) {
                ((XMOBasedPreferencesPage)element).initPageProperties();
            }
            newTab.setControl(element.getControl());
            newTab.setText(element.getTitle());
        }
        return tabbedComposite;
    }

    public void addPreferencePage(PreferencePage page) {
        this.pageList.add(page);
        if (page instanceof XMOBasedPreferencesPage) {
            this.map.put(page.getTitle(), page);
        }
    }

    public void addAllPreferencePage(List page) {
        Iterator iter = page.iterator();
        while (iter.hasNext()) {
            this.addPreferencePage((PreferencePage)iter.next());
        }
    }

    public boolean performCancel() {
        boolean cancel = true;
        for (PreferencePage preferencePage : this.pageList) {
            boolean bl = cancel = preferencePage.performCancel() && cancel;
        }
        return cancel;
    }

    public void performDefaults() {
        Iterator<PreferencePage> iter = this.pageList.iterator();
        while (iter.hasNext()) {
            IPreferencePage element = (IPreferencePage)iter.next();
            if (!(element instanceof IPreferencePageExt)) continue;
            IPreferencePageExt elementExt = (IPreferencePageExt)iter.next();
            elementExt.performDefaults();
        }
        super.performDefaults();
    }

    public void performHelp() {
        super.performHelp();
    }

    public boolean performOk() {
        boolean isOk = true;
        for (PreferencePage page : this.pageList) {
            boolean bl = isOk = page.performOk() && isOk;
        }
        return isOk;
    }

    public void dispose() {
        for (PreferencePage element : this.pageList) {
            element.dispose();
        }
        super.dispose();
    }
}

