/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.swt.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.swt.util.VerticalFillLayoutData;

public class VerticalFillLayout
extends Layout {
    public int leftMargin = -1;
    public int rightMargin = -1;

    public static Control createSeparator(Composite parent, int height) {
        Composite c = new Composite(parent, 0);
        VerticalFillLayoutData d = new VerticalFillLayoutData();
        d.heightHint = height;
        c.setLayoutData((Object)d);
        return c;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int w = 0;
        int m = 0;
        if (this.leftMargin != -1) {
            m = this.leftMargin;
        }
        if (this.rightMargin != -1) {
            m += this.rightMargin;
        }
        int h = 0;
        Control[] cs = composite.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (cs[i].isVisible() || cs[i].isEnabled()) {
                VerticalFillLayoutData data;
                Point p = cs[i].computeSize(wHint, -1);
                Object d = cs[i].getLayoutData();
                VerticalFillLayoutData verticalFillLayoutData = data = d instanceof VerticalFillLayoutData ? (VerticalFillLayoutData)d : null;
                h = data != null && data.heightHint != -1 ? (h += data.heightHint) : (h += p.y);
                if (w < p.x) {
                    w = p.x;
                }
            }
            ++i;
        }
        return new Point(w + m, h);
    }

    protected void layout(Composite composite, boolean flushCache) {
        int x = composite.getClientArea().x;
        int y = composite.getClientArea().y;
        int width = composite.getClientArea().width;
        if (this.leftMargin != -1) {
            x += this.leftMargin;
            width -= this.leftMargin;
        }
        if (this.rightMargin != -1) {
            width -= this.rightMargin;
        }
        Control[] cs = composite.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (cs[i].isVisible() || cs[i].isEnabled()) {
                Point p = cs[i].computeSize(width, -1);
                Object d = cs[i].getLayoutData();
                VerticalFillLayoutData data = d instanceof VerticalFillLayoutData ? (VerticalFillLayoutData)d : null;
                int dh = data != null && data.heightHint != -1 ? data.heightHint : p.y;
                cs[i].setBounds(x, y, width, dh);
                y += dh;
            }
            ++i;
        }
    }
}

