/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.templates.configuration.MetaConfiguration;
import org.jboss.tools.common.model.ui.templates.model.MetaClassTemplate;
import org.jboss.tools.common.model.ui.templates.model.MetaGroup;
import org.jboss.tools.common.model.ui.templates.model.MetaTemplateConstants;
import org.jboss.tools.common.model.ui.templates.model.MetaValue;
import org.jboss.tools.common.model.ui.templates.model.MetaValueList;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.common.xml.XMLUtilities;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class MetaConfigurationLoader
implements MetaTemplateConstants {
    static MetaConfigurationLoader instance = new MetaConfigurationLoader();
    private static final String GLOBAL_FILE_NAME = "/globalTemplates.xml";
    private static final String PROJECT_FILE_NAME = "/.projectTemplates";
    public static final String PREFERENCE_KEY = "global_templates";

    static {
        try {
            String path = FileLocator.resolve((URL)MetaConfigurationLoader.class.getResource("/dtds/meta-templates.dtd")).toString();
            XMLEntityResolver.registerPublicEntity((String)"-//Red Hat Inc.//DTD Meta Templates 1.0//EN", (String)path);
        }
        catch (IOException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void loadExtensionConfiguration(MetaConfiguration c) {
        this.processExtensions(c);
    }

    public void loadGlobalConfiguration(MetaConfiguration c) {
        String text = ModelUIPlugin.getDefault().getPluginPreferences().getString(PREFERENCE_KEY);
        if (text != null && text.length() > 0) {
            Document document = XMLUtilities.getDocument((Reader)new StringReader(text), (EntityResolver)this.createResolver());
            this.loadConfiguration(c, document);
        }
    }

    public void loadProjectConfiguration(MetaConfiguration c, IProject project) {
        Document document = this.getDocument((IPath)new Path(this.getProjectLocation(project)));
        if (document != null) {
            this.loadConfiguration(c, document);
        }
    }

    public void saveGlobalConfiguration(MetaConfiguration c) {
        Element element = XMLUtilities.createDocumentElement((String)"meta-template-groups");
        this.saveConfiguration(c, element);
        StringWriter writer = new StringWriter();
        try {
            XMLUtilities.serialize((Element)element, (Writer)writer);
        }
        catch (IOException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        ModelUIPlugin.getDefault().getPluginPreferences().setValue(PREFERENCE_KEY, writer.toString());
    }

    public void saveProjectConfiguration(MetaConfiguration c, IProject project) {
        this.saveConfiguration(c, this.getProjectLocation(project));
    }

    void saveConfiguration(MetaConfiguration c, String location) {
        File f = new File(location);
        if (c.isOverriding()) {
            Element element = XMLUtilities.createDocumentElement((String)"meta-template-groups");
            this.saveConfiguration(c, element);
            try {
                XMLUtilities.serialize((Element)element, (String)location);
            }
            catch (IOException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        } else if (f.isFile()) {
            f.delete();
        }
    }

    void loadConfiguration(MetaConfiguration c, Document document) {
        Element[] groups = XMLUtilities.getChildren((Element)document.getDocumentElement(), (String)"meta-templates");
        int i = 0;
        while (i < groups.length) {
            MetaGroup g = c.addGroup(groups[i].getAttribute("uri"));
            this.loadGroup(g, groups[i], null);
            ++i;
        }
    }

    protected String getGlobalLocation() {
        String location = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.jboss.tools.common.model.ui.templates")).toString();
        return String.valueOf(location) + GLOBAL_FILE_NAME;
    }

    protected String getProjectLocation(IProject project) {
        return String.valueOf(project.getLocation().toString()) + PROJECT_FILE_NAME;
    }

    private void processExtensions(MetaConfiguration c) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.jboss.tools.common.model.ui.metaTemplates");
        if (extensionPoint == null) {
            ModelUIPlugin.getPluginLog().logError("Cannot find extension point \"org.jboss.tools.common.model.ui.metaTemplates");
        }
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            String name = extension.getNamespaceIdentifier();
            if ("include".equals(member.getName())) {
                this.doInclude(member, c);
            } else if ("meta-templates".equals(member.getName())) {
                this.doMetaTemplate(member, c);
            } else {
                ModelUIPlugin.getPluginLog().logInfo("Error in declaring extension \"org.jboss.tools.common.model.ui.metaTemplates\" at " + name);
            }
            ++m;
        }
    }

    private void doMetaTemplate(IConfigurationElement element, MetaConfiguration c) {
        MetaGroup g = c.addGroup(element.getAttribute("uri"));
        this.loadGroup(g, element, null);
    }

    private void doInclude(IConfigurationElement element, MetaConfiguration c) {
        URL url = null;
        String name = element.getDeclaringExtension().getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)name);
        try {
            url = FileLocator.resolve((URL)bundle.getEntry("/"));
        }
        catch (IOException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        String file = element.getAttribute("file");
        String translations = element.getAttribute("translations");
        try {
            Document document;
            String fullPath = FileLocator.resolve((URL)url).getFile();
            ResourceBundle properties = null;
            if (translations != null && translations.length() > 0) {
                properties = this.getResourceBundle((IPath)new Path(String.valueOf(fullPath) + translations));
            }
            if ((document = this.getDocument((IPath)new Path(String.valueOf(fullPath) + file))) != null) {
                Element root = document.getDocumentElement();
                MetaGroup g = c.addGroup(root.getAttribute("uri"));
                this.loadGroup(g, root, properties);
            }
        }
        catch (IOException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private ResourceBundle getResourceBundle(IPath path) {
        ResourceBundle properties;
        block15: {
            properties = null;
            File propertiesFile = path.toFile();
            if (propertiesFile.canRead()) {
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(propertiesFile);
                        properties = new PropertyResourceBundle(is);
                    }
                    catch (IOException e) {
                        ModelUIPlugin.getPluginLog().logError((Throwable)e);
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                        properties = new ResourceBundle(){

                            @Override
                            protected Object handleGetObject(String key) {
                                return null;
                            }

                            @Override
                            public Enumeration<String> getKeys() {
                                return Collections.enumeration(Collections.emptyList());
                            }
                        };
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                    properties = new /* invalid duplicate definition of identical inner class */;
                    throw throwable;
                }
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                properties = new /* invalid duplicate definition of identical inner class */;
            }
        }
        return properties;
    }

    Document getDocument(IPath path) {
        File file = new File(path.toString());
        if (!file.isFile()) {
            return null;
        }
        try {
            return XMLUtilities.getDocument((Reader)new FileReader(file), (EntityResolver)this.createResolver());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    XMLEntityResolver createResolver() {
        XMLEntityResolver resolver = XMLEntityResolver.getInstance();
        return resolver;
    }

    void loadGroup(MetaGroup g, IConfigurationElement element, ResourceBundle properties) {
        IConfigurationElement[] cs = element.getChildren();
        int i = 0;
        while (i < cs.length) {
            if ("meta-template".equals(cs[i].getName())) {
                MetaClassTemplate t = g.addMetaClassTemplate(cs[i].getAttribute("axis"));
                this.loadClass(t, cs[i], properties);
            }
            ++i;
        }
    }

    void loadGroup(MetaGroup g, Element element, ResourceBundle properties) {
        Element[] cs = XMLUtilities.getChildren((Element)element, (String)"meta-template");
        int i = 0;
        while (i < cs.length) {
            String axis = cs[i].getAttribute("axis");
            if (axis != null && properties != null && axis.startsWith("%")) {
                axis = properties.getString(axis);
            }
            MetaClassTemplate t = g.addMetaClassTemplate(axis);
            this.loadClass(t, cs[i], properties);
            ++i;
        }
    }

    void loadClass(MetaClassTemplate t, IConfigurationElement element, ResourceBundle properties) {
        String displayName = element.getAttribute("displayName");
        if (displayName != null && properties != null && displayName.startsWith("%")) {
            displayName = properties.getString(displayName);
        }
        t.setDisplayName(displayName);
        String xEntity = element.getAttribute("xEntity");
        if (xEntity != null && properties != null && xEntity.startsWith("%")) {
            xEntity = properties.getString(xEntity);
        }
        t.setXEntity(xEntity);
        IConfigurationElement[] childs = element.getChildren();
        ArrayList<String> is = new ArrayList<String>();
        int i = 0;
        while (i < childs.length) {
            IConfigurationElement child = childs[i];
            String name = child.getAttribute("name");
            if (name != null && properties != null && name.startsWith("%")) {
                name = properties.getString(name);
            }
            if ("super-class".equals(child.getName())) {
                t.getSuperClass().setValue(name);
            } else if ("interface".equals(child.getName()) && name != null && name.length() > 0) {
                is.add(name);
            }
            ++i;
        }
        t.getInterfaces().setValues(is.toArray(new String[0]));
    }

    void loadClass(MetaClassTemplate t, Element element, ResourceBundle properties) {
        String displayName = element.getAttribute("displayName");
        if (displayName != null && displayName.startsWith("%")) {
            displayName = properties.getString(displayName);
        }
        t.setDisplayName(displayName);
        String xEntity = element.getAttribute("xEntity");
        if (xEntity != null && xEntity.startsWith("%")) {
            xEntity = properties.getString(xEntity);
        }
        t.setXEntity(xEntity);
        NodeList cs = element.getChildNodes();
        ArrayList<String> is = new ArrayList<String>();
        int i = 0;
        while (i < cs.getLength()) {
            Node cn = cs.item(i);
            if (cn.getNodeType() == 1) {
                Element child = (Element)cn;
                String name = child.getAttribute("name");
                if (name != null && name.startsWith("%")) {
                    name = properties.getString(name);
                }
                if ("super-class".equals(child.getNodeName())) {
                    t.getSuperClass().setValue(name);
                } else if ("interface".equals(child.getNodeName()) && name != null && name.length() > 0) {
                    is.add(name);
                }
            }
            ++i;
        }
        t.getInterfaces().setValues(is.toArray(new String[is.size()]));
    }

    void saveConfiguration(MetaConfiguration c, Element element) {
        for (MetaGroup g : c.getMetaTemplateGroups()) {
            if (!g.isOverriding()) continue;
            Element ge = XMLUtilities.createElement((Element)element, (String)"meta-templates");
            ge.setAttribute("uri", g.getUri());
            for (MetaClassTemplate t : g.getTemplates()) {
                if (!t.isOverriding()) continue;
                Element te = XMLUtilities.createElement((Element)ge, (String)"meta-template");
                if (t.getAxis() != null) {
                    te.setAttribute("axis", t.getAxis());
                }
                if (t.getDisplayName() != null) {
                    te.setAttribute("displayName", t.getDisplayName());
                }
                if (t.getXEntity() != null) {
                    te.setAttribute("xEntity", t.getXEntity());
                }
                MetaValue superClass = t.getSuperClass();
                Element sce = XMLUtilities.createElement((Element)te, (String)"super-class");
                sce.setAttribute("name", superClass.getValue());
                MetaValueList interfaces = t.getInterfaces();
                String[] is = interfaces.getValues();
                int i = 0;
                while (i < is.length) {
                    Element ise = XMLUtilities.createElement((Element)te, (String)"interface");
                    ise.setAttribute("name", is[i]);
                    ++i;
                }
            }
        }
    }
}

