/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates.configuration;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.model.ui.templates.configuration.IMetaConfigurationSave;
import org.jboss.tools.common.model.ui.templates.configuration.MetaConfiguration;
import org.jboss.tools.common.model.ui.templates.configuration.MetaConfigurationLoader;
import org.jboss.tools.common.model.ui.templates.model.MetaElementFactory;

public class MetaConfigurationManager {
    static MetaConfigurationManager instance = new MetaConfigurationManager();
    private MetaConfigurationLoader loader = new MetaConfigurationLoader();
    private MetaConfiguration extensionConfiguration;
    private MetaConfiguration globalConfiguration;
    private HashMap<String, MetaConfiguration> projectConfigurations = new HashMap();

    public static MetaConfigurationManager getInstance() {
        return instance;
    }

    public MetaConfiguration getExtensionConfiguration() {
        if (this.extensionConfiguration == null) {
            this.extensionConfiguration = this.createExtensionConfiguration();
        }
        return this.extensionConfiguration;
    }

    public MetaConfiguration getGlobalConfiguration() {
        if (this.globalConfiguration == null) {
            this.globalConfiguration = this.createGlobalConfiguration();
        }
        return this.globalConfiguration;
    }

    public MetaConfiguration getProjectConfiguration(IProject project) {
        MetaConfiguration projectConfiguration = this.projectConfigurations.get(project.getName());
        if (projectConfiguration == null) {
            projectConfiguration = this.createProjectConfiguration(project);
            this.projectConfigurations.put(project.getName(), projectConfiguration);
        }
        return projectConfiguration;
    }

    public MetaConfiguration getWorkingCopy(final MetaConfiguration source) {
        final MetaConfiguration c = MetaElementFactory.instance.createConfiguraton(source);
        c.setSaveAgent(new IMetaConfigurationSave(){

            @Override
            public void save() {
                c.commitToParent();
                source.save();
            }
        });
        return c;
    }

    private MetaConfiguration createExtensionConfiguration() {
        MetaConfiguration c = MetaElementFactory.instance.createConfiguraton(null);
        this.loader.loadExtensionConfiguration(c);
        return c;
    }

    private MetaConfiguration createGlobalConfiguration() {
        final MetaConfiguration c = MetaElementFactory.instance.createConfiguraton(this.getExtensionConfiguration());
        this.loader.loadGlobalConfiguration(c);
        c.setSaveAgent(new IMetaConfigurationSave(){

            @Override
            public void save() {
                MetaConfigurationManager.this.loader.saveGlobalConfiguration(c);
            }
        });
        return c;
    }

    private MetaConfiguration createProjectConfiguration(final IProject p) {
        final MetaConfiguration c = MetaElementFactory.instance.createConfiguraton(this.getGlobalConfiguration());
        this.loader.loadProjectConfiguration(c, p);
        c.setSaveAgent(new IMetaConfigurationSave(){

            @Override
            public void save() {
                MetaConfigurationManager.this.loader.saveProjectConfiguration(c, p);
            }
        });
        return c;
    }

    public void saveGlobalConfiguration() {
        this.loader.saveGlobalConfiguration(this.globalConfiguration);
    }

    public void saveProjectConfiguration(IProject p) {
        this.loader.saveProjectConfiguration(this.getProjectConfiguration(p), p);
    }
}

