/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.texteditors.dnd;

import java.util.Properties;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.ControlDragDrop;
import org.jboss.tools.common.model.ui.dnd.IControlDragDropProvider;
import org.jboss.tools.common.model.ui.dnd.IControlDropListener;
import org.jboss.tools.common.model.ui.texteditors.dnd.TextEditorDropProvider;

public class TextEditorDrop
implements IControlDragDropProvider,
IControlDropListener {
    ControlDragDrop dnd = new ControlDragDrop();
    TextEditorDropProvider provider;

    public TextEditorDrop() {
        this.dnd.setProvider(this);
    }

    public void setTextEditorDropProvider(TextEditorDropProvider provider) {
        this.provider = provider;
    }

    public void enable() {
        this.dnd.enableDrop();
    }

    @Override
    public Control getControl() {
        return this.provider.getSourceViewer().getTextWidget();
    }

    @Override
    public XModelObject getModelObjectForWidget(Widget widget) {
        return this.provider.getModelObject();
    }

    @Override
    public Widget[] getSelection() {
        return new Widget[]{this.getControl()};
    }

    @Override
    public Properties getDropProperties(int x, int y) {
        String context;
        Properties p = new Properties();
        p.setProperty("isDrop", "true");
        p.setProperty("actionSourceGUIComponentID", "editor");
        p.setProperty("accepsAsString", "true");
        String text = this.provider.getSourceViewer().getDocument().get();
        p.setProperty("text", text);
        int pos = this.getPosition(x, y);
        p.setProperty("pos", "" + pos);
        p.put("viewer", this.provider.getSourceViewer());
        if (this.provider instanceof TextEditorDropProvider2 && (context = ((TextEditorDropProvider2)((Object)this.provider)).getContext(pos)) != null) {
            p.put("text-context", context);
        }
        return p;
    }

    private int getPosition(int x, int y) {
        ITextViewerExtension5 ext;
        int off;
        ISourceViewer v = this.provider.getSourceViewer();
        StyledText t = v.getTextWidget();
        Point pp = t.toControl(x, y);
        x = pp.x;
        y = pp.y;
        int lineIndex = (t.getTopPixel() + y) / t.getLineHeight();
        int result = 0;
        if (lineIndex >= t.getLineCount()) {
            result = t.getCharCount();
        } else {
            int c = 0;
            c = t.getOffsetAtLocation(new Point(x, y));
            if (c < 0) {
                c = 0;
            }
            result = c;
        }
        if (v instanceof ITextViewerExtension5 && (off = (ext = (ITextViewerExtension5)v).widgetOffset2ModelOffset(result)) >= 0) {
            result = off;
        }
        return result;
    }

    @Override
    public void drop(Properties p) {
        ISourceViewer v = this.provider.getSourceViewer();
        int x = (Integer)p.get("drop.x");
        int y = (Integer)p.get("drop.y");
        int c = this.getPosition(x, y);
        Point sp = v.getTextWidget().getSelectionRange();
        if (sp == null || c < sp.x || c >= sp.x + sp.y) {
            v.getTextWidget().setCaretOffset(c);
        }
        this.provider.insert(p);
    }

    public static interface TextEditorDropProvider2 {
        public String getContext(int var1);
    }
}

