/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.ui.editor.EditorDescriptor;
import org.jboss.tools.common.util.FileUtil;

public class PaletteContents {
    private IEditorPart editorPart;
    private String[] natureTypes;
    private String[] editorTypes;
    public static String TYPE_MOBILE = "mobile";
    public static String TYPE_JSF = "jsf";

    public PaletteContents(IEditorPart editorPart) {
        this.editorPart = editorPart;
        if (editorPart == null) {
            this.emptyInit();
            return;
        }
        EditorDescriptor editorDescriptor = (EditorDescriptor)editorPart.getAdapter(EditorDescriptor.class);
        this.editorTypes = editorDescriptor != null ? editorDescriptor.getEditorTypes() : new String[0];
        this.natureTypes = this.computeNatureTypes();
    }

    public boolean update() {
        if (this.editorPart == null) {
            return false;
        }
        String[] ns = this.computeNatureTypes();
        if (this.changed(ns)) {
            this.natureTypes = ns;
            return true;
        }
        return false;
    }

    boolean changed(String[] ns) {
        return this.natureTypes.length != ns.length || this.natureTypes.length > 0 && !this.natureTypes[0].equals(ns[0]);
    }

    private String[] computeNatureTypes() {
        IFile file;
        IEditorInput input;
        String[] result = new String[]{};
        if (this.editorPart != null && (input = this.editorPart.getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            String doctype = FileUtil.getDoctype((String)FileUtil.getContentFromEditorOrFile((IFile)file));
            result = "html".equalsIgnoreCase(doctype) || doctype == null && FileUtil.isHTMLFile((IFile)file) ? new String[]{TYPE_MOBILE} : new String[]{TYPE_JSF};
        }
        return result;
    }

    private void emptyInit() {
        this.natureTypes = new String[0];
        this.editorTypes = new String[0];
    }

    public boolean empty() {
        return this.natureTypes.length <= 0 && this.editorTypes.length <= 0;
    }

    public String[] getNatureTypes() {
        return this.natureTypes;
    }

    public String[] getEditorTypes() {
        return this.editorTypes;
    }
}

