/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.common.model.ui.views.palette.IPaletteAdapter;
import org.jboss.tools.common.model.ui.views.palette.IPalettePageAdapter;
import org.jboss.tools.common.model.ui.views.palette.PaletteAdapter;
import org.jboss.tools.common.model.ui.views.palette.PaletteContents;
import org.osgi.framework.Bundle;

public class PaletteCreator {
    public static final String PALETTE_GEF_ID = "org.jboss.tools.jst.web.ui";
    IPalettePageAdapter palettePage;
    private IPaletteAdapter paletteAdapter = null;
    private Composite root = null;
    private Control palette = null;
    private IWorkbenchPart lastPart = null;
    private boolean lastPaletteEnabled = false;
    private static final String ERROR_GETTING_ACTIVE_EDITOR = "Error while getting active text editor";

    public PaletteCreator(IPalettePageAdapter palettePage) {
        this.palettePage = palettePage;
    }

    public Control createPartControlImpl(Composite parent) {
        this.paletteAdapter = this.createPaletteAdapter();
        this.paletteAdapter.setPaletteContents(this.palettePage.getPaletteContents());
        this.paletteAdapter.setPaletteViewPart(this.palettePage);
        this.root = new Composite(parent, 0);
        this.root.setLayout((Layout)new FillLayout());
        this.palette = this.paletteAdapter.createControl(this.root);
        return this.palette;
    }

    public void initActionBars() {
        this.paletteAdapter.initActionBars();
    }

    public Control getControl() {
        return this.root;
    }

    private IPaletteAdapter createPaletteAdapter() {
        try {
            Class cls;
            Bundle b = Platform.getBundle((String)PALETTE_GEF_ID);
            Class clazz = cls = b == null ? null : b.loadClass("org.jboss.tools.jst.web.ui.palette.PaletteAdapter");
            if (cls != null) {
                return (IPaletteAdapter)cls.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return new PaletteAdapter();
    }

    public void dispose() {
        if (this.palette != null) {
            if (!this.palette.isDisposed()) {
                this.palette.dispose();
            }
            this.palette = null;
        }
        if (this.root != null) {
            if (!this.root.isDisposed()) {
                this.root.dispose();
            }
            this.root = null;
        }
        if (this.paletteAdapter != null) {
            this.paletteAdapter.dispose();
        }
        this.paletteAdapter = null;
    }

    public void setFocus() {
        if (this.palette != null && !this.palette.isDisposed()) {
            this.palette.setFocus();
        }
    }

    public void partActivated(IWorkbenchPart part) {
        IEditorPart part1 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part1 instanceof IEditorPart) {
            this.paletteAdapter.setPaletteContents(new PaletteContents(part1));
            this.lastPaletteEnabled = true;
            this.paletteAdapter.setEnabled(this.lastPaletteEnabled);
            this.lastPart = part1;
        } else {
            this.paletteAdapter.setEnabled(false);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.lastPart != null && this.palettePage.getPage().getActiveEditor() != this.lastPart) {
            this.lastPart = null;
            this.paletteAdapter.setPaletteContents(new PaletteContents(null));
            this.lastPaletteEnabled = false;
            this.paletteAdapter.setEnabled(false);
        }
    }

    public ITextEditor getActiveTextEditor() {
        IWorkbenchPage page = this.palettePage.getPage();
        IEditorPart part = page.getActiveEditor();
        if (part == null) {
            return null;
        }
        return this.getActiveTextEditor((IWorkbenchPart)part);
    }

    public void insertIntoEditor(XModelObject macro) {
        IWorkbenchPage page = this.palettePage.getPage();
        IEditorPart part = page.getActiveEditor();
        if (part == null) {
            return;
        }
        ITextEditor editor = this.getActiveTextEditor((IWorkbenchPart)part);
        if (editor == null) {
            return;
        }
        if (!editor.isEditable()) {
            return;
        }
        if (this.dropIntoEditor(editor, macro)) {
            return;
        }
        if (this.dropIntoEditor2(editor, macro)) {
            return;
        }
    }

    private boolean dropIntoEditor(ITextEditor editor, XModelObject macro) {
        Method m;
        block6: {
            m = editor.getClass().getMethod("runDropCommand", String.class, String.class);
            if (m != null) break block6;
            return false;
        }
        try {
            m.setAccessible(true);
            Properties p = new Properties();
            p.setProperty("isDrag", "true");
            XActionInvoker.invoke((String)"CopyActions.Copy", (XModelObject)macro, (Properties)p);
            Object[] objectArray = new Object[2];
            objectArray[0] = "vpe/model";
            m.invoke((Object)editor, objectArray);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return false;
        }
        catch (IllegalArgumentException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return false;
        }
    }

    private boolean dropIntoEditor2(ITextEditor editor, XModelObject macro) {
        SpecialWizard w = SpecialWizardFactory.createSpecialWizard((String)"org.jboss.tools.jst.web.ui.internal.editor.outline.DefaultDropCommandRunner");
        if (w == null) {
            return false;
        }
        Properties p = new Properties();
        p.setProperty("isDrag", "true");
        XActionInvoker.invoke((String)"CopyActions.Copy", (XModelObject)macro, (Properties)p);
        p.setProperty("flavor", "vpe/model");
        p.put("textEditor", editor);
        w.setObject((Object)p);
        int r = w.execute();
        return r == 0;
    }

    public boolean isEnabled() {
        return this.lastPart != null;
    }

    private ITextEditor getActiveTextEditor(IWorkbenchPart part) {
        ITextEditor editor = null;
        if (part instanceof EditorPartWrapper) {
            part = ((EditorPartWrapper)part).getEditor();
        }
        if (part instanceof ITextEditor) {
            editor = (ITextEditor)part;
        } else if (part instanceof MultiPageEditorPart) {
            try {
                Method m = MultiPageEditorPart.class.getDeclaredMethod("getActiveEditor", new Class[0]);
                m.setAccessible(true);
                Object o = m.invoke((Object)part, new Object[0]);
                if (o instanceof ITextEditor) {
                    editor = (ITextEditor)o;
                }
            }
            catch (NoSuchMethodException t) {
                ModelUIPlugin.getPluginLog().logError(ERROR_GETTING_ACTIVE_EDITOR, (Throwable)t);
            }
            catch (IllegalArgumentException t) {
                ModelUIPlugin.getPluginLog().logError(ERROR_GETTING_ACTIVE_EDITOR, (Throwable)t);
            }
            catch (IllegalAccessException t) {
                ModelUIPlugin.getPluginLog().logError(ERROR_GETTING_ACTIVE_EDITOR, (Throwable)t);
            }
            catch (InvocationTargetException t) {
                ModelUIPlugin.getPluginLog().logError(ERROR_GETTING_ACTIVE_EDITOR, (Throwable)t);
            }
        }
        return editor;
    }

    public IPaletteAdapter getAdapter() {
        return this.paletteAdapter;
    }
}

