/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.common.model.ui.views.palette.IIgnoreSelection;
import org.jboss.tools.common.model.ui.views.palette.IPositionCorrector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class PaletteInsertHelper {
    public static final String PROPERTY_SELECTION_PROVIDER = "selectionProvider";
    public static final String PROPERTY_START_TEXT = "start text";
    public static final String PROPERTY_END_TEXT = "end text";
    public static final String PROPERTY_REFORMAT_BODY = "automatically reformat tag body";
    public static final String PROPERTY_TAG_NAME = "tag name";
    public static final String PROPERTY_NEW_LINE = "new line";

    protected void insertIntoEditor(ITextEditor editor, Properties p, IPositionCorrector corrector) {
        if (editor == null) {
            return;
        }
        if (!PaletteInsertHelper.isEditable(editor)) {
            ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
            String name = editor.getEditorInput().getName();
            String mes = "Source " + name + " is read-only";
            if (editor != null && this.isEditable(editor.getEditorInput())) {
                mes = "Please activate Source tab.";
            }
            d.showDialog("Warning", mes, new String[]{"OK"}, null, 2);
            return;
        }
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        ISelectionProvider selProvider = editor.getSelectionProvider();
        p.put(PROPERTY_SELECTION_PROVIDER, selProvider);
        this.insertIntoEditorInternal(doc, p, corrector);
    }

    public ITextSelection correctSelection(IDocument document, ITextSelection selection, IPositionCorrector corrector) {
        int start = selection.getOffset();
        int end = start + selection.getLength();
        IStructuredModel model = null;
        try {
            IDOMDocument xmlDocument;
            model = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)((IStructuredDocument)document));
            IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            if (xmlDocument != null) {
                if (corrector != null) {
                    selection = corrector.correctSelection((org.w3c.dom.Document)xmlDocument, selection);
                    start = selection.getOffset();
                    end = start + selection.getLength();
                }
                ITextSelection iTextSelection = this.basicCorrectSelection(model, start, end);
                return iTextSelection;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return new TextSelection(document, start, end - start);
    }

    protected void insertIntoEditorInternal(IDocument doc, Properties p, IPositionCorrector corrector) {
        String startText = p.getProperty(PROPERTY_START_TEXT);
        String endText = p.getProperty(PROPERTY_END_TEXT);
        String newline = p.getProperty(PROPERTY_NEW_LINE);
        boolean reformat = "yes".equals(p.getProperty(PROPERTY_REFORMAT_BODY));
        ISelectionProvider selProvider = (ISelectionProvider)p.get(PROPERTY_SELECTION_PROVIDER);
        if (doc == null || selProvider == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)selProvider.getSelection();
        selection = this.correctSelection(doc, selection, corrector);
        int offset = selection.getOffset();
        int length = selection.getLength();
        startText = startText == null ? "" : PaletteInsertHelper.prepare(PaletteInsertHelper.prepare(startText, "\\n", PaletteInsertHelper.getLineDelimiter(doc)), "\\t", "\t");
        endText = endText == null ? "" : PaletteInsertHelper.prepare(PaletteInsertHelper.prepare(endText, "\\n", PaletteInsertHelper.getLineDelimiter(doc)), "\\t", "\t");
        int start = offset;
        int end = offset + length;
        String body = "";
        try {
            String lastLineEnding;
            String firstLineBeginning;
            int firstLine = doc.getLineOfOffset(start);
            int firstLineStart = doc.getLineOffset(firstLine);
            String string = firstLineBeginning = start == firstLineStart ? "" : doc.get(firstLineStart, start - firstLineStart).trim();
            if (firstLineBeginning.isEmpty()) {
                int n = start = firstLine == 0 ? firstLineStart : doc.getLineOffset(firstLine - 1) + doc.getLineLength(firstLine - 1) - PaletteInsertHelper.getLineDelimiter(doc, firstLine - 1).length();
            }
            if (start < 0) {
                start = 0;
            } else if (start > doc.getLength()) {
                start = doc.getLength();
            }
            int lastLine = doc.getLineOfOffset(end);
            int lastLineEnd = doc.getLineOffset(lastLine) + doc.getLineLength(lastLine) - PaletteInsertHelper.getLineDelimiter(doc, lastLine).length();
            String string2 = lastLineEnding = end == lastLineEnd ? "" : doc.get(end, lastLineEnd - end).trim();
            if (lastLineEnding.isEmpty()) {
                end = lastLineEnd;
            }
            if (end < 0) {
                end = 0;
            } else if (end > doc.getLength()) {
                end = doc.getLength();
            }
            body = end == start ? "" : doc.get(start, end - start);
        }
        catch (BadLocationException e1) {
            ModelUIPlugin.getDefault().logError(e1);
        }
        String text = reformat ? PaletteInsertHelper.formatText(doc, start, end - start, body, selection, startText, endText, newline) : String.valueOf(startText) + body + endText;
        int pos = text.indexOf("|");
        if (pos >= 0) {
            text = String.valueOf(text.substring(0, pos)) + text.substring(pos + 1);
        } else {
            pos = text.length();
        }
        if (start >= 0 && end <= doc.getLength() && end - start >= 0 && !text.isEmpty()) {
            try {
                doc.replace(start, end - start, text);
            }
            catch (BadLocationException ex) {
                ModelUIPlugin.getDefault().logError(ex);
            }
            TextSelection sel = new TextSelection(start + pos, 0);
            selProvider.setSelection((ISelection)sel);
        }
    }

    static boolean isEditable(ITextEditor editor) {
        if (editor == null) {
            return false;
        }
        return editor.isEditable();
    }

    protected boolean isEditable(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            IFile f = ((IFileEditorInput)input).getFile();
            return f != null && !f.isReadOnly();
        }
        return true;
    }

    protected void modify(ISourceViewer v, Properties p, String[] texts) {
    }

    protected void insertIntoEditor(ISourceViewer v, Properties p, IPositionCorrector corrector) {
        String startText = p.getProperty(PROPERTY_START_TEXT);
        String endText = p.getProperty(PROPERTY_END_TEXT);
        ISelectionProvider selProvider = (ISelectionProvider)p.get(PROPERTY_SELECTION_PROVIDER);
        if (selProvider == null) {
            p.put(PROPERTY_SELECTION_PROVIDER, v.getSelectionProvider());
        }
        IDocument d = v.getDocument();
        String[] texts = new String[]{startText, endText};
        this.modify(v, p, texts);
        startText = texts[0];
        endText = texts[1];
        if (startText != null) {
            p.setProperty(PROPERTY_START_TEXT, startText);
        }
        if (endText != null) {
            p.setProperty(PROPERTY_END_TEXT, endText);
        }
        IEditorPart activeEditor = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.insertIntoEditorInternal(d, p, corrector);
        if (v instanceof IIgnoreSelection) {
            ((IIgnoreSelection)v).setIgnore(true);
        }
        if (activeEditor != null) {
            activeEditor.getSite().getPage().activate((IWorkbenchPart)activeEditor);
        }
        if (v instanceof IIgnoreSelection) {
            ((IIgnoreSelection)v).setIgnore(false);
        }
    }

    protected ITextSelection basicCorrectSelection(IStructuredModel model, int start, int end) {
        IDOMDocument xmlDocument;
        IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
        if (xmlDocument != null) {
            if (start == end) {
                IndexedRegion region = model.getIndexedRegion(start);
                if (region instanceof ElementImpl) {
                    ElementImpl element = (ElementImpl)region;
                    int startOffset = element.getStartOffset();
                    int startEndOffset = element.getStartEndOffset();
                    int endStartOffset = element.getEndStartOffset();
                    int endOffset = element.getEndOffset();
                    if (start >= startOffset && start <= startEndOffset) {
                        start = start - startOffset < startEndOffset - start ? (end = startOffset) : (end = startEndOffset);
                    } else if (start >= endStartOffset && start <= endOffset) {
                        start = start - endStartOffset < endOffset - start ? (end = endStartOffset) : (end = endOffset);
                    }
                } else if (region instanceof DocumentTypeImpl) {
                    DocumentTypeImpl element = (DocumentTypeImpl)region;
                    int startOffset = element.getStartOffset();
                    int endOffset = element.getEndOffset();
                    if (start >= startOffset && start <= endOffset) {
                        start = start - startOffset < endOffset - start ? (end = startOffset) : (end = endOffset);
                    } else if (start >= endOffset && start <= endOffset) {
                        start = start - endOffset < endOffset - start ? (end = endOffset) : (end = endOffset);
                    }
                } else if (region instanceof CommentImpl) {
                    int startOffset = region.getStartOffset();
                    int endOffset = region.getEndOffset();
                    if (start >= startOffset && start <= endOffset) {
                        start = start - startOffset < endOffset - start ? (end = startOffset) : (end = endOffset);
                    }
                }
            } else {
                IndexedRegion startRegion = model.getIndexedRegion(start);
                IndexedRegion endRegion = model.getIndexedRegion(end);
                if (startRegion != null && endRegion != null) {
                    IndexedRegion commonRegion = this.findCommonRegion(startRegion, endRegion, start, end);
                    if (commonRegion != null) {
                        if (commonRegion instanceof ElementImpl) {
                            ElementImpl root = (ElementImpl)commonRegion;
                            ElementImpl firstElement = this.findElement(root, start, end);
                            if (firstElement != null) {
                                ElementImpl lastElement = firstElement;
                                Object lastNode = firstElement;
                                while (lastNode.getNextSibling() != null) {
                                    if (!((lastNode = lastNode.getNextSibling()) instanceof ElementImpl)) continue;
                                    Object element = lastNode;
                                    if ((element.getStartEndOffset() == element.getEndOffset() || element.getStartEndOffset() <= start || element.getEndStartOffset() >= end) && (element.getStartEndOffset() != element.getEndOffset() || element.getStartOffset() < start || element.getEndOffset() > end)) break;
                                    lastElement = lastNode;
                                }
                                if (firstElement != null) {
                                    start = firstElement.getStartOffset();
                                    end = lastElement != null ? lastElement.getEndOffset() : firstElement.getEndOffset();
                                }
                            } else {
                                start = end = this.findMinimalDistance(startRegion, endRegion, start, end);
                            }
                        }
                    } else {
                        start = end = this.findMinimalDistance(startRegion, endRegion, start, end);
                    }
                }
            }
        }
        return new TextSelection((IDocument)model.getStructuredDocument(), start, end - start);
    }

    private int findMinimalDistance(IndexedRegion startRegion, IndexedRegion endRegion, int start, int end) {
        int middle = start + (end - start) / 2;
        ElementImpl startElement = null;
        if (startRegion instanceof Text) {
            startElement = (ElementImpl)((Text)startRegion).getParentNode();
        } else if (startRegion instanceof ElementImpl) {
            startElement = (ElementImpl)startRegion;
        }
        ElementImpl endElement = null;
        if (endRegion instanceof Text) {
            endElement = (ElementImpl)((Text)endRegion).getParentNode();
        } else if (endRegion instanceof ElementImpl) {
            endElement = (ElementImpl)endRegion;
        }
        int[] offsets = new int[]{startElement.getStartOffset(), startElement.getStartEndOffset(), startElement.getEndStartOffset(), startElement.getEndOffset(), endElement.getStartOffset(), endElement.getStartEndOffset(), endElement.getEndStartOffset(), endElement.getEndOffset()};
        int[] distances = new int[8];
        int i = 0;
        while (i < 8) {
            distances[i] = Math.abs(offsets[i] - middle);
            ++i;
        }
        int minDistance = distances[0];
        int offset = offsets[0];
        int index = 0;
        while (index < distances.length) {
            if (distances[index] < minDistance) {
                minDistance = distances[index];
                offset = offsets[index];
            }
            ++index;
        }
        return offset;
    }

    private ElementImpl findElement(ElementImpl root, int start, int end) {
        if (root.getStartEndOffset() != root.getEndOffset() && root.getStartEndOffset() > start && root.getEndStartOffset() < end || root.getStartEndOffset() == root.getEndOffset() && root.getStartOffset() >= start && root.getEndOffset() <= end) {
            return root;
        }
        NodeList list = root.getChildNodes();
        int index = 0;
        while (index < list.getLength()) {
            ElementImpl result;
            Node child = list.item(index);
            if (child instanceof ElementImpl && (result = this.findElement((ElementImpl)child, start, end)) != null) {
                return result;
            }
            ++index;
        }
        return null;
    }

    private IndexedRegion findCommonRegion(IndexedRegion startRegion, IndexedRegion endRegion, int start, int end) {
        if (startRegion.getStartOffset() == endRegion.getStartOffset()) {
            return startRegion;
        }
        IndexedRegion startElement = null;
        if (startRegion instanceof Text) {
            startElement = (IndexedRegion)((Text)startRegion).getParentNode();
        } else if (startRegion instanceof ElementImpl) {
            startElement = startRegion;
        }
        IndexedRegion endElement = null;
        if (endRegion instanceof Text) {
            endElement = (IndexedRegion)((Text)endRegion).getParentNode();
        } else if (endRegion instanceof ElementImpl) {
            endElement = endRegion;
        }
        while (startElement != null) {
            IndexedRegion elem = endElement;
            while (elem != null) {
                if (startElement.getStartOffset() == elem.getStartOffset()) {
                    return startElement;
                }
                elem = (IndexedRegion)((Node)elem).getParentNode();
            }
            startElement = (IndexedRegion)((Node)startElement).getParentNode();
        }
        return null;
    }

    protected static String prepare(String text, String pattern, String replacer) {
        int index;
        String res = text;
        while ((index = res.indexOf(pattern)) != -1) {
            res = String.valueOf(res.substring(0, index)) + replacer + res.substring(index + pattern.length());
        }
        return res;
    }

    protected static String createIndent(String line, boolean increase, String lineDelimiter) {
        String indentString = PaletteInsertHelper.getIndentOfLine(line, lineDelimiter);
        int tabWidth = IElementGenerator.NodeWriter.getTabWidth();
        int displayedWidth = PaletteInsertHelper.calculateDisplayedWidth(indentString, tabWidth);
        if (increase) {
            displayedWidth += tabWidth;
        }
        return PaletteInsertHelper.createIndent(displayedWidth);
    }

    protected static String createIndent(int displayedWidth) {
        StringBuilder indent = new StringBuilder();
        int tabWidth = IElementGenerator.NodeWriter.getTabWidth();
        boolean useSpaces = IElementGenerator.NodeWriter.useSpaces();
        if (useSpaces) {
            while (indent.length() < displayedWidth) {
                indent = indent.append(' ');
            }
        } else {
            int width = 0;
            while (width < displayedWidth) {
                indent = indent.append(width + tabWidth <= displayedWidth ? (char)'\t' : ' ');
                width += width + tabWidth <= displayedWidth ? tabWidth : 1;
            }
        }
        return indent.toString();
    }

    protected static String createIndent(IDocument doc, boolean increase, int offset) {
        String lineDelimiter = PaletteInsertHelper.getLineDelimiter(doc);
        String lineText = "";
        try {
            int line = doc.getLineOfOffset(offset);
            while (line >= 0) {
                String text;
                int lineOffset = doc.getLineOffset(line);
                int lineLength = doc.getLineLength(line);
                String string = text = lineLength == 0 ? "" : doc.get(lineOffset, lineLength);
                if (text.trim().length() > 0) {
                    lineText = text;
                    break;
                }
                --line;
            }
        }
        catch (BadLocationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return PaletteInsertHelper.createIndent(lineText, increase, lineDelimiter);
    }

    protected static boolean shouldIncreaseIndent(StringBuilder buffer, int offset) {
        return PaletteInsertHelper.shouldIncreaseIndent((IDocument)new Document(buffer.toString()), offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean shouldIncreaseIndent(IDocument doc, int offset) {
        try {
            ArrayList<String> closingTags = new ArrayList<String>();
            int line = doc.getLineOfOffset(offset);
            String text = "";
            while (line >= 0) {
                String lineText;
                int lineLength;
                int lineOffset = doc.getLineOffset(line);
                int n = lineLength = offset < lineOffset + (lineLength = doc.getLineLength(line)) ? offset - lineOffset : lineLength;
                if (lineLength > 0 && !(lineText = doc.get(lineOffset, lineLength)).trim().isEmpty()) {
                    text = lineText;
                    break;
                }
                --line;
            }
            int index = text.length();
            while (true) {
                String tagName;
                if (index < 0) {
                    return false;
                }
                if ((index = text.lastIndexOf(60, index - 1)) == -1) {
                    return false;
                }
                boolean closingTag = index + 1 >= text.length() || '/' == text.charAt(index + 1);
                int tagEnd = text.indexOf(62, index);
                boolean selfClosingTag = tagEnd == -1 || '/' == text.charAt(tagEnd - 1) || '-' == text.charAt(tagEnd - 1) && '-' == text.charAt(tagEnd - 2);
                StringBuilder sb = new StringBuilder();
                int i = index + 1;
                while (i < tagEnd) {
                    char ch = text.charAt(i);
                    if (ch != '/') {
                        if (!Character.isJavaIdentifierStart(ch)) break;
                        sb.append(ch);
                    }
                    ++i;
                }
                if ("br".equalsIgnoreCase(tagName = sb.toString()) || "hr".equals(tagName)) continue;
                if (closingTag) {
                    closingTags.add(tagName);
                }
                if (closingTag || selfClosingTag) continue;
                int closingTagIndex = closingTags.indexOf(tagName);
                if (closingTagIndex == -1) {
                    return true;
                }
                closingTags.remove(closingTagIndex);
            }
        }
        catch (BadLocationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return false;
    }

    protected static int calMinIndentWidth(String text, String lineDelimiter) {
        if (text == null) {
            return 0;
        }
        LineIterator textLines = new LineIterator(text);
        int minIndentWidth = -1;
        while (textLines.hasNext()) {
            String line = (String)textLines.next();
            int lineIndent = PaletteInsertHelper.calculateDisplayedWidth(PaletteInsertHelper.getIndentOfLine(line, lineDelimiter), IElementGenerator.NodeWriter.getTabWidth());
            if (minIndentWidth != -1 && minIndentWidth <= lineIndent) continue;
            minIndentWidth = lineIndent;
        }
        return minIndentWidth;
    }

    protected static String formatText(IDocument d, int offset, int length, String body, ITextSelection selection, String startText, String endText, String newline) {
        boolean inlineFormatting;
        String lineDelimiter = PaletteInsertHelper.getLineDelimiter(d);
        startText = PaletteInsertHelper.trimNewLines(startText);
        endText = PaletteInsertHelper.trimNewLines(endText);
        body = body == null ? "" : body;
        int minStartTextIndentWidth = PaletteInsertHelper.calMinIndentWidth(startText, lineDelimiter);
        int minEndTextIndentWidth = PaletteInsertHelper.calMinIndentWidth(endText, lineDelimiter);
        int minBodyIndentWidth = PaletteInsertHelper.calMinIndentWidth(body, lineDelimiter);
        int tabWidth = IElementGenerator.NodeWriter.getTabWidth();
        boolean indentBody = startText.trim().length() > 0 && endText.trim().length() > 0;
        boolean increaseIndent = PaletteInsertHelper.shouldIncreaseIndent(d, offset);
        String firstLineIndent = PaletteInsertHelper.createIndent(d, increaseIndent, offset);
        int bodyIndentWidth = PaletteInsertHelper.calculateDisplayedWidth(firstLineIndent, tabWidth) + (indentBody ? tabWidth : 0);
        int selectedLineIndentWidth = PaletteInsertHelper.calculateDisplayedWidth(PaletteInsertHelper.createIndent(d, false, selection.getOffset()), tabWidth);
        String bodyPrefix = "";
        String bodySuffix = "";
        try {
            bodyPrefix = selection.getOffset() == offset ? "" : d.get(offset, selection.getOffset() - offset);
            bodySuffix = offset + length == selection.getOffset() + selection.getLength() ? "" : d.get(selection.getOffset() + selection.getLength(), offset + length - selection.getOffset() - selection.getLength());
        }
        catch (BadLocationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirstOrLast = false;
        try {
            int line = d.getLineOfOffset(offset);
            int lineOffset = d.getLineOffset(line);
            int lineLength = d.getLineLength(line);
            notFirstOrLast = !d.get(lineOffset, offset - lineOffset).trim().isEmpty() && !d.get(offset, lineOffset + lineLength - offset).trim().isEmpty();
        }
        catch (BadLocationException ex) {
            ModelUIPlugin.getPluginLog().logError((Throwable)ex);
        }
        boolean bl = inlineFormatting = startText.indexOf(10) == -1 && endText.indexOf(10) == -1 && (selection.getLength() != 0 && selection.getText().indexOf(10) == -1 || notFirstOrLast);
        if (inlineFormatting) {
            String insertLine = String.valueOf(bodyPrefix) + bodySuffix;
            String prefix = "";
            String indent = "";
            if (bodyPrefix.lastIndexOf(10) != -1) {
                prefix = insertLine.trim().isEmpty() ? bodyPrefix.substring(0, bodyPrefix.lastIndexOf(10) + 1) : bodyPrefix.substring(bodyPrefix.lastIndexOf(10) + 1);
                indent = firstLineIndent;
            }
            buffer.append(prefix).append(PaletteInsertHelper.createIndent(PaletteInsertHelper.calculateDisplayedWidth(indent, tabWidth))).append(startText.trim()).append(selection.getText()).append(endText.trim());
        } else {
            String line;
            boolean appendLastDelimiter = true;
            try {
                int line2 = d.getLineOfOffset(offset + length);
                int lineOffset = d.getLineOffset(line2);
                int lineLength = d.getLineLength(line2) - (offset + length - lineOffset);
                String lastLine = lineLength == 0 ? "" : d.get(offset + length, lineLength);
                appendLastDelimiter = !lastLine.trim().isEmpty();
            }
            catch (BadLocationException ex) {
                ModelUIPlugin.getPluginLog().logError((Throwable)ex);
            }
            int firstLineIndentWidth = PaletteInsertHelper.calculateDisplayedWidth(firstLineIndent, tabWidth);
            int indentWidth = 0;
            if (!startText.trim().isEmpty()) {
                LineIterator textLines = new LineIterator(startText);
                while (textLines.hasNext()) {
                    line = (String)textLines.next();
                    indentWidth = firstLineIndentWidth + PaletteInsertHelper.calculateDisplayedWidth(PaletteInsertHelper.getIndentOfLine(line, lineDelimiter), tabWidth) - minStartTextIndentWidth;
                    buffer = buffer.append(lineDelimiter);
                    buffer = buffer.append(PaletteInsertHelper.createIndent(indentWidth));
                    buffer = buffer.append(line.trim());
                }
            }
            if (!selection.getText().trim().isEmpty()) {
                bodyIndentWidth = indentWidth + (PaletteInsertHelper.shouldIncreaseIndent(buffer, buffer.length()) ? tabWidth : 0);
                LineIterator textLines = new LineIterator(selection.getText());
                while (textLines.hasNext()) {
                    line = (String)textLines.next();
                    indentWidth = bodyIndentWidth + PaletteInsertHelper.calculateDisplayedWidth(PaletteInsertHelper.getIndentOfLine(line, lineDelimiter), tabWidth) - minBodyIndentWidth;
                    buffer = buffer.append(lineDelimiter);
                    buffer = buffer.append(PaletteInsertHelper.createIndent(indentWidth));
                    buffer = buffer.append(line.trim());
                }
            } else if (startText.indexOf(124) == -1 && endText.indexOf(124) == -1) {
                buffer.append('|');
            }
            if (!endText.trim().isEmpty()) {
                LineIterator textLines = new LineIterator(endText);
                while (textLines.hasNext()) {
                    line = (String)textLines.next();
                    indentWidth = firstLineIndentWidth + PaletteInsertHelper.calculateDisplayedWidth(PaletteInsertHelper.getIndentOfLine(line, lineDelimiter), tabWidth) - minEndTextIndentWidth;
                    indentWidth = firstLineIndentWidth + PaletteInsertHelper.calculateDisplayedWidth(PaletteInsertHelper.getIndentOfLine(line, lineDelimiter), tabWidth) - minStartTextIndentWidth;
                    buffer = buffer.append(lineDelimiter);
                    buffer = buffer.append(PaletteInsertHelper.createIndent(indentWidth));
                    buffer = buffer.append(line.trim());
                }
            }
            if (appendLastDelimiter && !inlineFormatting) {
                int selectionEnd = selection.getOffset() + selection.getLength();
                try {
                    int endLine = d.getLineOfOffset(selectionEnd);
                    int selectionLineEnd = d.getLineOffset(endLine) + d.getLineLength(endLine);
                    String string = selectionEnd == selectionLineEnd ? "" : d.get(selectionEnd, selectionLineEnd - selectionEnd).trim();
                }
                catch (BadLocationException e) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e);
                }
                indentWidth = selectedLineIndentWidth;
                buffer = buffer.append(lineDelimiter);
                buffer = buffer.append(PaletteInsertHelper.createIndent(indentWidth));
            }
        }
        return buffer.toString();
    }

    protected static String trimNewLines(String text) {
        if (text == null) {
            return "";
        }
        char[] data = text.toCharArray();
        int start = 0;
        while (start < data.length) {
            if ('\n' != data[start] && '\r' != data[start]) break;
            ++start;
        }
        int end = data.length;
        while (end > 0) {
            if ('\n' != data[end - 1] && '\r' != data[end - 1]) break;
            --end;
        }
        return new String(Arrays.copyOfRange(data, start, end));
    }

    protected static int calculateDisplayedWidth(String string, int tabWidth) {
        int column = 0;
        int i = 0;
        while (i < string.length()) {
            column = '\t' == string.charAt(i) ? (column += tabWidth - column % tabWidth) : ++column;
            ++i;
        }
        return column;
    }

    protected static String getLineDelimiter(IDocument document, int line) throws BadLocationException {
        String delim = document.getLineDelimiter(line);
        return delim == null ? "" : delim;
    }

    public static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return System.getProperty("line.separator");
    }

    protected static String getIndentOfLine(String line, String lineDelimiter) {
        int i = 0;
        while (i < line.length()) {
            if (!Character.isWhitespace(line.charAt(i)) || lineDelimiter != null && lineDelimiter.indexOf(line.charAt(i)) != -1) break;
            ++i;
        }
        return line.substring(0, i);
    }

    protected static final class LineIterator
    implements Iterator {
        private final IDocument fDocument;
        private int fLineIndex;

        public LineIterator(String string) {
            this.fDocument = new Document(string);
        }

        @Override
        public boolean hasNext() {
            return this.fLineIndex != this.fDocument.getNumberOfLines();
        }

        public Object next() {
            try {
                IRegion region = this.fDocument.getLineInformation(this.fLineIndex++);
                return this.fDocument.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

