/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.views.palette.IPositionCorrector;

public class PaletteInsertManager {
    static PaletteInsertManager instance = new PaletteInsertManager();
    static String POINT_ID = "org.jboss.tools.common.model.ui.InsertTagWizard";
    static String ATTR_CORRECTOR_CLASS = "corrector-class";
    HashMap<String, IConfigurationElement> tagWizards = null;
    Map<String, List<String>> keywords = null;

    public static PaletteInsertManager getInstance() {
        return instance;
    }

    public String getWizardName(Properties properties) {
        IConfigurationElement o = this.getElement(properties);
        return o != null ? o.getAttribute("class") : null;
    }

    public Object createWizardInstance(Properties properties) {
        IConfigurationElement o = this.getElement(properties);
        try {
            return o.createExecutableExtension("class");
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }

    public IPositionCorrector createCorrectorInstance(String palettePath) {
        IConfigurationElement o = this.getElement(palettePath, null);
        if (o != null) {
            String correctorClassName = o.getAttribute(ATTR_CORRECTOR_CLASS);
            try {
                if (correctorClassName != null) {
                    return (IPositionCorrector)o.createExecutableExtension(ATTR_CORRECTOR_CLASS);
                }
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
                return null;
            }
        }
        return null;
    }

    public List<String> getKeyWords(String palettePath) {
        if (this.keywords == null) {
            this.loadKeywords();
        }
        palettePath = palettePath.replace('%', '_').replace(' ', '_');
        return this.keywords.get(palettePath);
    }

    private IConfigurationElement getElement(Properties properties) {
        String palettePath = properties.getProperty("palettePath");
        if (palettePath == null) {
            return null;
        }
        return this.getElement(palettePath, properties.getProperty("tag name"));
    }

    private IConfigurationElement getElement(String palettePath, String tagName) {
        IConfigurationElement result;
        if (this.tagWizards == null) {
            this.loadWizards();
        }
        if ((result = this.tagWizards.get(palettePath = palettePath.replace('%', '_').replace(' ', '_'))) == null && tagName != null) {
            result = this.tagWizards.get(tagName);
        }
        return result;
    }

    private void loadWizards() {
        this.tagWizards = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        IExtension[] es = point.getExtensions();
        int i = 0;
        while (i < es.length) {
            IConfigurationElement[] elements = es[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String name = elements[j].getAttribute("name");
                String className = elements[j].getAttribute("class");
                if (name != null && name.trim().length() > 0 && className != null && className.trim().length() > 0) {
                    this.tagWizards.put(name.trim(), elements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void loadKeywords() {
        this.keywords = new HashMap<String, List<String>>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        IExtension[] es = point.getExtensions();
        int i = 0;
        while (i < es.length) {
            IConfigurationElement[] elements = es[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String[] ks;
                String name = elements[j].getAttribute("name");
                String keywordString = elements[j].getAttribute("keywords");
                if (keywordString != null && (ks = keywordString.split(",")).length > 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    String[] stringArray = ks;
                    int n = ks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String k = stringArray[n2];
                        list.add(k);
                        ++n2;
                    }
                    this.keywords.put(name, list);
                }
                ++j;
            }
            ++i;
        }
    }
}

