/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette;

import java.util.Properties;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.views.palette.IPositionCorrector;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertHelper;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertManager;

public class XModelPaletteInsertHelper
extends PaletteInsertHelper {
    static XModelPaletteInsertHelper instance = new XModelPaletteInsertHelper();

    public static XModelPaletteInsertHelper getInstance() {
        return instance;
    }

    @Override
    protected boolean isEditable(IEditorInput input) {
        XModelObject o;
        if (input instanceof IModelObjectEditorInput && (o = ((IModelObjectEditorInput)input).getXModelObject()) != null && !o.isObjectEditable()) {
            return false;
        }
        return super.isEditable(input);
    }

    public int correctOffset(IDocument document, int offset, String paletteItemPath) {
        ITextSelection selection = this.correctSelection(document, (ITextSelection)new TextSelection(document, offset, 0), paletteItemPath);
        return selection.getOffset();
    }

    public ITextSelection correctSelection(IDocument document, ITextSelection selection, String paletteItemPath) {
        IPositionCorrector corrector = this.getCorrector(paletteItemPath);
        return this.correctSelection(document, selection, corrector);
    }

    public void insertIntoEditor(ISourceViewer v, Properties p) {
        String paletteItemPath = p.getProperty("palettePath");
        IPositionCorrector corrector = this.getCorrector(paletteItemPath);
        this.insertIntoEditor(v, p, corrector);
    }

    public void insertIntoEditor(ITextEditor editor, Properties p) {
        String paletteItemPath = p.getProperty("palettePath");
        IPositionCorrector corrector = this.getCorrector(paletteItemPath);
        this.insertIntoEditor(editor, p, corrector);
    }

    private IPositionCorrector getCorrector(String paletteItemPath) {
        if (paletteItemPath == null) {
            return null;
        }
        return PaletteInsertManager.getInstance().createCorrectorInstance(paletteItemPath);
    }
}

