/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette.editor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.views.palette.editor.PaletteDialog;

public class PaletteDialogState {
    PaletteDialog dialog;
    Rectangle bounds = null;
    int[] ws = null;
    Object[] es = new Object[0];
    Object selected = null;
    int v_scroll = -1;

    public PaletteDialogState(PaletteDialog dialog) {
        this.dialog = dialog;
    }

    public void saveState() {
        this.bounds = this.dialog.getShell().getBounds();
        this.es = this.dialog.treeViewer.getExpandedElements();
        this.saveSelection();
        this.v_scroll = this.dialog.treeViewer.getTree().getVerticalBar().getSelection();
        this.ws = this.dialog.sash.getWeights();
    }

    public void loadState() {
        if (this.bounds != null) {
            this.dialog.getShell().setBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        } else {
            Rectangle r = Display.getDefault().getClientArea();
            int w = 620;
            int h = 420;
            int x = (r.width - w) / 2;
            int y = (r.height - h) / 2;
            this.dialog.getShell().setBounds(x, y, w, h);
        }
        this.loadSash();
        this.loadExpansion();
        this.loadSelection();
        if (this.v_scroll > 0) {
            this.dialog.treeViewer.getTree().getVerticalBar().setSelection(this.v_scroll);
        }
    }

    void loadSash() {
        if (this.ws == null || this.ws.length == 0) {
            this.ws = new int[]{25, 50};
        }
        this.dialog.sash.setWeights(this.ws);
    }

    void loadExpansion() {
        if (this.es == null || this.es.length < 2) {
            XModel model = PreferenceModelUtilities.getPreferenceModel();
            this.es = new Object[2];
            this.es[0] = model.getByPath("XStudio");
            this.es[1] = model.getByPath("XStudio/Palette");
        }
        this.dialog.treeViewer.setExpandedElements(this.es);
    }

    void saveSelection() {
        this.selected = null;
        ISelection s = this.dialog.treeViewer.getSelection();
        if (s.isEmpty()) {
            return;
        }
        StructuredSelection ss = (StructuredSelection)s;
        this.selected = ss.getFirstElement();
    }

    void loadSelection() {
        if (this.selected == null) {
            this.selected = PreferenceModelUtilities.getPreferenceModel().getByPath("XStudio/Palette");
        }
        this.dialog.treeViewer.setSelection((ISelection)new StructuredSelection(this.selected), true);
        this.dialog.objectEditor.setModelObject((XModelObject)this.selected);
    }
}

