/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.query.list;

class CheckObject {
    boolean checked;
    String[] objectData;
    CheckObject parent;
    CheckObject[] children = new CheckObject[0];

    public CheckObject(CheckObject parent, String[] objectData) {
        this.parent = parent;
        this.objectData = objectData;
    }

    public void addChild(CheckObject child) {
        CheckObject[] cs = new CheckObject[this.children.length + 1];
        System.arraycopy(this.children, 0, cs, 0, this.children.length);
        cs[this.children.length] = child;
        this.children = cs;
    }

    public CheckObject getParent() {
        return this.parent;
    }

    public CheckObject[] getChildren() {
        return this.children;
    }

    public boolean isDisabled() {
        return "yes".equals(this.objectData[1]);
    }

    public boolean isNotDisabled() {
        return this.parent == null || !this.parent.isDisabled() && this.parent.isNotDisabled();
    }

    public void flip() {
        this.objectData[1] = this.isDisabled() ? "no" : "yes";
    }

    public void setEnabled(boolean b) {
        this.objectData[1] = b ? "no" : "yes";
    }

    public String getPath() {
        return this.objectData[0];
    }

    public CheckObject getByPath(String path) {
        if (!path.startsWith(String.valueOf(this.getPath()) + "/")) {
            return null;
        }
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].getPath().equals(path)) {
                return this.children[i];
            }
            CheckObject c = this.children[i].getByPath(path);
            if (c != null) {
                return c;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        String n = this.objectData[0];
        int i = n.lastIndexOf(47);
        return n.substring(i + 1);
    }
}

