/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.editor.ObjectTextEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.propertieseditor.PropertiesEditor;
import org.jboss.tools.common.propertieseditor.text.PropertiesTextEditor;

public class PropertiesCompoundEditor
extends ObjectMultiPageEditor {
    protected PropertiesEditor propertiesEditor;

    public static boolean isPropertiesFile(XModelObject object) {
        return object != null && "FilePROPERTIES".equals(object.getModelEntity().getName());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.propertiesEditor != null) {
            this.propertiesEditor.dispose();
        }
        this.propertiesEditor = null;
    }

    @Override
    protected void doCreatePages() {
        this.createPropertiesPage();
        this.createTextPage();
        this.initEditors();
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.propertiesEditor != null && this.propertiesEditor.isDirty();
    }

    protected void createPropertiesPage() {
        this.propertiesEditor = new PropertiesEditor();
        this.propertiesEditor.setObject(this.object);
        this.propertiesEditor.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertiesCompoundEditor.this.firePropertyChange(257);
            }
        };
        int index = -1;
        try {
            this.propertiesEditor.init(this.getEditorSite(), this.getEditorInput());
            index = this.addPage((IEditorPart)this.propertiesEditor, this.getEditorInput());
        }
        catch (PartInitException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return;
        }
        this.setPageText(index, "Properties");
        if (!PropertiesCompoundEditor.isPropertiesFile(this.getModelObject())) {
            return;
        }
        this.propertiesEditor.update();
        this.propertiesEditor.refresh();
    }

    @Override
    protected ObjectTextEditor createTextEditor() {
        return new PropertiesTextEditor();
    }

    @Override
    protected void setNormalMode() {
        if (this.treeFormPage != null) {
            this.treeFormPage.initialize(this.getModelObject());
            this.treeFormPage.setErrorMode(this.isErrorMode());
        }
        if (this.propertiesEditor == null) {
            return;
        }
        if (PropertiesCompoundEditor.isPropertiesFile(this.getModelObject())) {
            this.propertiesEditor.setObject(this.object);
            this.propertiesEditor.update();
        }
        this.updateSelectionProvider();
    }

    @Override
    protected void checkErrorMode() {
    }

    @Override
    protected void updateEditableMode() {
        if (this.propertiesEditor != null) {
            this.propertiesEditor.update();
        }
    }

    @Override
    public Object getAdapter(Class cls) {
        return super.getAdapter(cls);
    }

    @Override
    protected void updateSelectionProvider() {
        int index;
        if (this.propertiesEditor != null) {
            this.selectionProvider.addHost("guiEditor", this.propertiesEditor.getSelectionProvider());
        }
        if (this.textEditor != null) {
            this.selectionProvider.addHost("textEditor", this.getTextSelectionProvider());
        }
        if ((index = this.getActivePage()) == this.getSourcePageIndex()) {
            if (this.textEditor != null) {
                this.selectionProvider.setHost(this.getTextSelectionProvider());
            }
            return;
        }
        if (this.propertiesEditor != null && this.propertiesEditor.getSelectionProvider() != null) {
            ISelectionProvider p = this.propertiesEditor.getSelectionProvider();
            this.selectionProvider.setHost(p);
            if (p instanceof AbstractSelectionProvider) {
                ((AbstractSelectionProvider)p).fireSelectionChanged();
            }
        }
    }

    @Override
    protected String[] getSupportedNatures() {
        return new String[0];
    }

    @Override
    protected void synchronizeSelectionWithText() {
        if (this.getTextSelectionProvider() == null || this.propertiesEditor == null) {
            return;
        }
        ISelection s = this.getTextSelectionProvider().getSelection();
        if (s == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        Object o = ((IStructuredSelection)s).getFirstElement();
        if (!(o instanceof XModelObject) || o == this.getModelObject()) {
            return;
        }
        this.propertiesEditor.getSelectionProvider().setSelection(s);
        if (this.outline != null) {
            this.outline.setSelection(s);
        }
    }
}

